/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.relaxng.program;

import com.caucho.relaxng.RelaxException;
import com.caucho.relaxng.program.EmptyItem;
import com.caucho.relaxng.program.GroupItem;
import com.caucho.relaxng.program.InElementItem;
import com.caucho.relaxng.program.Item;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.xml.QName;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChoiceItem
extends Item {
    protected static final L10N L = new L10N(ChoiceItem.class);
    private ArrayList<Item> _items = new ArrayList();
    private boolean _allowEmpty = false;

    public static Item create(Item left, Item right) {
        ChoiceItem choice = new ChoiceItem();
        choice.addItem(left);
        choice.addItem(right);
        return choice.getMin();
    }

    public void addItem(Item item) {
        if (item == null) {
            return;
        }
        if (item instanceof EmptyItem) {
            this._allowEmpty = true;
            return;
        }
        if (item instanceof ChoiceItem) {
            ChoiceItem choice = (ChoiceItem)item;
            if (choice._allowEmpty) {
                this._allowEmpty = true;
            }
            for (int i = 0; i < choice._items.size(); ++i) {
                this.addItem(choice._items.get(i));
            }
            return;
        }
        for (int i = 0; i < this._items.size(); ++i) {
            Item subItem = this._items.get(i);
            if (item.equals(subItem)) {
                return;
            }
            if (item instanceof InElementItem && subItem instanceof InElementItem) {
                InElementItem elt1 = (InElementItem)item;
                InElementItem elt2 = (InElementItem)subItem;
                if (elt1.getElementItem().equals(elt2.getElementItem())) {
                    subItem = InElementItem.create(elt1.getElementItem(), ChoiceItem.create(elt1.getContinuationItem(), elt2.getContinuationItem()));
                    this._items.remove(i);
                    this.addItem(subItem);
                    return;
                }
            }
            if (!(item instanceof GroupItem) || !(subItem instanceof GroupItem)) continue;
            GroupItem group1 = (GroupItem)item;
            GroupItem group2 = (GroupItem)subItem;
            if (!group1.getFirst().equals(group2.getFirst())) continue;
            subItem = GroupItem.create(group1.getFirst(), ChoiceItem.create(group1.getSecond(), group2.getSecond()));
            this._items.remove(i);
            this.addItem(subItem);
            return;
        }
        this._items.add(item);
    }

    public Item getMin() {
        if (!this._allowEmpty && this._items.size() == 0) {
            return null;
        }
        if (this._allowEmpty && this._items.size() == 0) {
            return EmptyItem.create();
        }
        if (this._items.size() == 1 && (!this._allowEmpty || this._items.get(0).allowEmpty())) {
            return this._items.get(0);
        }
        return this;
    }

    @Override
    public void firstSet(HashSet<QName> set) {
        for (int i = 0; i < this._items.size(); ++i) {
            this._items.get(i).firstSet(set);
        }
    }

    @Override
    public void requiredFirstSet(HashSet<QName> set) {
        if (this.allowEmpty()) {
            return;
        }
        for (int i = 0; i < this._items.size(); ++i) {
            this._items.get(i).requiredFirstSet(set);
        }
    }

    @Override
    public boolean allowEmpty() {
        if (this._allowEmpty) {
            return true;
        }
        for (int i = 0; i < this._items.size(); ++i) {
            if (!this._items.get(i).allowEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Item interleaveContinuation(Item cont) {
        ChoiceItem item = new ChoiceItem();
        for (int i = 0; i < this._items.size(); ++i) {
            item.addItem(this._items.get(i).interleaveContinuation(cont));
        }
        return item.getMin();
    }

    @Override
    public Item inElementContinuation(Item cont) {
        ChoiceItem item = new ChoiceItem();
        for (int i = 0; i < this._items.size(); ++i) {
            item.addItem(this._items.get(i).inElementContinuation(cont));
        }
        return item.getMin();
    }

    @Override
    public Item groupContinuation(Item cont) {
        ChoiceItem item = new ChoiceItem();
        for (int i = 0; i < this._items.size(); ++i) {
            item.addItem(this._items.get(i).groupContinuation(cont));
        }
        return item.getMin();
    }

    @Override
    public Iterator<Item> getItemsIterator() {
        if (this._items.size() == 0) {
            return this.emptyItemIterator();
        }
        return this._items.iterator();
    }

    @Override
    public Item startElement(QName name) throws RelaxException {
        Item result = null;
        ChoiceItem choice = null;
        for (int i = 0; i < this._items.size(); ++i) {
            Item next = this._items.get(i).startElement(name);
            if (next == null) continue;
            if (result == null) {
                result = next;
                continue;
            }
            if (choice == null) {
                choice = new ChoiceItem();
                choice.addItem(result);
            }
            choice.addItem(next);
        }
        if (choice != null) {
            return choice.getMin();
        }
        return result;
    }

    @Override
    public void attributeSet(HashSet<QName> set) {
        for (int i = 0; i < this._items.size(); ++i) {
            this._items.get(i).attributeSet(set);
        }
    }

    @Override
    public boolean allowAttribute(QName name, String value) throws RelaxException {
        for (int i = this._items.size() - 1; i >= 0; --i) {
            if (!this._items.get(i).allowAttribute(name, value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Item setAttribute(QName name, String value) throws RelaxException {
        if (!this.allowAttribute(name, value)) {
            return this;
        }
        ChoiceItem choice = new ChoiceItem();
        if (this._allowEmpty) {
            choice.addItem(EmptyItem.create());
        }
        for (int i = this._items.size() - 1; i >= 0; --i) {
            Item next = this._items.get(i).setAttribute(name, value);
            if (next == null) {
                return null;
            }
            choice.addItem(next);
        }
        return choice.getMin();
    }

    @Override
    public Item attributeEnd() {
        ChoiceItem choice = new ChoiceItem();
        if (this._allowEmpty) {
            choice._allowEmpty = true;
        }
        for (int i = this._items.size() - 1; i >= 0; --i) {
            Item next = this._items.get(i).attributeEnd();
            if (next == null) continue;
            choice.addItem(next);
        }
        if (choice.equals(this)) {
            return this;
        }
        return choice.getMin();
    }

    @Override
    public Item text(CharSequence data) throws RelaxException {
        Item result = null;
        ChoiceItem choice = null;
        for (int i = 0; i < this._items.size(); ++i) {
            Item next = this._items.get(i).text(data);
            if (next == null) continue;
            if (result == null) {
                result = next;
                continue;
            }
            if (choice == null) {
                choice = new ChoiceItem();
                choice.addItem(result);
            }
            choice.addItem(next);
        }
        if (choice != null) {
            return choice.getMin();
        }
        return result;
    }

    @Override
    public Item endElement() throws RelaxException {
        ChoiceItem choice = new ChoiceItem();
        if (this._allowEmpty) {
            choice._allowEmpty = true;
        }
        for (int i = this._items.size() - 1; i >= 0; --i) {
            Item next = this._items.get(i).endElement();
            if (next == null) continue;
            choice.addItem(next);
        }
        if (choice.equals(this)) {
            return this;
        }
        return choice.getMin();
    }

    public int hashCode() {
        int hash = 37;
        for (int i = 0; i < this._items.size(); ++i) {
            hash += this._items.get(i).hashCode();
        }
        return hash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ChoiceItem)) {
            return false;
        }
        ChoiceItem choice = (ChoiceItem)o;
        return this.isSubset(choice) && choice.isSubset(this);
    }

    private boolean isSubset(ChoiceItem item) {
        if (this._items.size() != item._items.size()) {
            return false;
        }
        for (int i = 0; i < this._items.size(); ++i) {
            Item subItem = this._items.get(i);
            if (item._items.contains(subItem)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean allowsElement(QName name) {
        for (int i = 0; i < this._items.size(); ++i) {
            Item subItem = this._items.get(i);
            if (!subItem.allowsElement(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toSyntaxDescription(int depth) {
        CharBuffer cb = CharBuffer.allocate();
        if (this._items.size() > 1) {
            cb.append("(");
        }
        boolean isSimple = true;
        for (int i = 0; i < this._items.size(); ++i) {
            Item item = this._items.get(i);
            if (!item.isSimpleSyntax()) {
                isSimple = false;
            }
            if (i == 0) {
                if (!isSimple) {
                    cb.append(" ");
                }
            } else if (isSimple) {
                cb.append(" | ");
            } else {
                this.addSyntaxNewline(cb, depth);
                cb.append("| ");
            }
            cb.append(item.toSyntaxDescription(depth + 2));
        }
        if (this._items.size() > 1) {
            cb.append(')');
        }
        if (this._allowEmpty) {
            cb.append('?');
        }
        return cb.close();
    }

    @Override
    protected boolean isSimpleSyntax() {
        return this._items.size() == 1 && this._items.get(0).isSimpleSyntax();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("ChoiceItem[");
        for (int i = 0; i < this._items.size(); ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(this._items.get(i));
        }
        sb.append("]");
        return sb.toString();
    }
}

