/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.relaxng.program;

import com.caucho.log.Log;
import com.caucho.relaxng.RelaxException;
import com.caucho.relaxng.program.EmptyItem;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.xml.QName;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Item {
    protected static final L10N L = new L10N(Item.class);
    protected static final Logger log = Log.open(Item.class);
    private static final Iterator<Item> EMPTY_ITEM_ITERATOR = new Iterator<Item>(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Item next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    };

    public void firstSet(HashSet<QName> set) {
    }

    public void requiredFirstSet(HashSet<QName> set) {
        if (!this.allowEmpty()) {
            this.firstSet(set);
        }
    }

    public boolean allowEmpty() {
        return false;
    }

    public Iterator<Item> getItemsIterator() {
        return this.emptyItemIterator();
    }

    protected Iterator<Item> emptyItemIterator() {
        return EMPTY_ITEM_ITERATOR;
    }

    protected Iterator<Item> itemIterator(final Item item) {
        if (item == null) {
            return this.emptyItemIterator();
        }
        return new Iterator<Item>(){
            private boolean _done;

            @Override
            public boolean hasNext() {
                return !this._done;
            }

            @Override
            public Item next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this._done = true;
                return item;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Item startElement(QName name) throws RelaxException {
        return null;
    }

    public boolean allowsElement(QName name) {
        return false;
    }

    public void attributeSet(HashSet<QName> set) {
    }

    public boolean allowAttribute(QName name, String value) throws RelaxException {
        return false;
    }

    public Item setAttribute(QName name, String value) throws RelaxException {
        return this;
    }

    public Item attributeEnd() {
        return this;
    }

    public Item text(CharSequence text) throws RelaxException {
        return null;
    }

    public Item endElement() throws RelaxException {
        if (this.allowEmpty()) {
            return EmptyItem.create();
        }
        return null;
    }

    public Item interleaveContinuation(Item cont) {
        throw new IllegalStateException(String.valueOf(this.getClass().getName()));
    }

    public Item inElementContinuation(Item cont) {
        throw new IllegalStateException(String.valueOf(this.getClass().getName()));
    }

    public Item groupContinuation(Item cont) {
        throw new IllegalStateException(String.valueOf(this.getClass().getName()));
    }

    public String toSyntaxDescription(int depth) {
        return this.toString();
    }

    protected boolean isSimpleSyntax() {
        return false;
    }

    protected void addSyntaxNewline(CharBuffer cb, int depth) {
        cb.append('\n');
        for (int i = 0; i < depth; ++i) {
            cb.append(' ');
        }
    }

    protected RelaxException error(String msg) {
        return new RelaxException(msg);
    }
}

