/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.resin;

import com.caucho.config.ConfigException;
import com.caucho.config.program.ContainerProgram;
import com.caucho.config.program.PropertyValueProgram;
import com.caucho.util.L10N;
import com.caucho.webbeans.cfg.WbComponentConfig;
import com.caucho.webbeans.manager.WebBeansContainer;

public class BeanEmbed {
    private static final L10N L = new L10N(BeanEmbed.class);
    private Object _value;
    private String _className;
    private String _name;
    private ContainerProgram _init = new ContainerProgram();

    public BeanEmbed() {
    }

    public BeanEmbed(Object value) {
        this.setValue(value);
    }

    public BeanEmbed(Object value, String name) {
        this.setValue(value);
        this.setName(name);
    }

    public BeanEmbed(String className) {
        this.setClass(className);
    }

    public BeanEmbed(String className, String name) {
        this.setClass(className);
        this.setName(name);
    }

    public void setClass(String className) {
        this._className = className;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setValue(Object value) {
        this._value = value;
    }

    public void addProperty(String name, Object value) {
        this._init.addProgram(new PropertyValueProgram(name, value));
    }

    public void validate() {
        if (this._value != null) {
            return;
        }
    }

    protected void configure() {
        try {
            WebBeansContainer webBeans = WebBeansContainer.create();
            if (this._value != null) {
                if (this._name != null) {
                    webBeans.addSingleton(this._value, this._name);
                } else {
                    webBeans.addSingleton(this._value);
                }
            } else {
                if (this._className == null) {
                    throw new ConfigException(L.l("BeanEmbed must either have a value or a class"));
                }
                WbComponentConfig comp = new WbComponentConfig();
                comp.setScope("singleton");
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                Class<?> cl = Class.forName(this._className, false, loader);
                comp.setClass(cl);
                if (this._name != null) {
                    comp.setName(this._name);
                }
                if (this._init != null) {
                    comp.setInit(this._init);
                }
                comp.init();
            }
        }
        catch (Exception e) {
            throw ConfigException.create((Throwable)e);
        }
    }
}

