/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.resin;

import com.caucho.config.ConfigException;
import com.caucho.config.program.ContainerProgram;
import com.caucho.config.program.PropertyValueProgram;
import com.caucho.server.dispatch.FilterMapping;
import java.util.HashMap;
import java.util.Map;

public class FilterMappingEmbed {
    private String _urlPattern;
    private String _servletName;
    private String _filterName;
    private String _filterClass;
    private HashMap<String, String> _initParamMap = new HashMap();
    private ContainerProgram _init = new ContainerProgram();

    public FilterMappingEmbed() {
    }

    public FilterMappingEmbed(String filterName) {
        this.setFilterName(filterName);
    }

    public FilterMappingEmbed(String filterName, String urlPattern) {
        this.setFilterName(filterName);
        this.setUrlPattern(urlPattern);
    }

    public FilterMappingEmbed(String filterName, String urlPattern, String filterClass) {
        this.setFilterName(filterName);
        this.setUrlPattern(urlPattern);
        this.setFilterClass(filterClass);
    }

    public void setFilterName(String filterName) {
        this._filterName = filterName;
    }

    public String getFilterName() {
        return this._filterName;
    }

    public void setFilterClass(String filterClass) {
        this._filterClass = filterClass;
    }

    public String getFilterClass() {
        return this._filterClass;
    }

    public void setUrlPattern(String urlPattern) {
        this._urlPattern = urlPattern;
    }

    public String getUrlPattern() {
        return this._urlPattern;
    }

    public void setServletName(String servletName) {
        this._servletName = servletName;
    }

    public void setInitParam(String name, String value) {
        this._initParamMap.put(name, value);
    }

    public void addProperty(String name, Object value) {
        this._init.addProgram(new PropertyValueProgram(name, value));
    }

    protected void configure(FilterMapping filterMapping) {
        try {
            if (this._urlPattern != null) {
                filterMapping.createUrlPattern().addText(this._urlPattern).init();
            }
            if (this._servletName != null) {
                filterMapping.addServletName(this._servletName);
            }
            filterMapping.setFilterName(this._filterName);
            if (this._filterClass != null) {
                filterMapping.setFilterClass(this._filterClass);
            }
            for (Map.Entry<String, String> entry : this._initParamMap.entrySet()) {
                filterMapping.setInitParam(entry.getKey(), entry.getValue());
            }
            filterMapping.setInit(this._init);
        }
        catch (Exception e) {
            throw ConfigException.create((Throwable)e);
        }
    }
}

