/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.resin;

import com.caucho.config.Config;
import com.caucho.config.ConfigContext;
import com.caucho.config.ConfigException;
import com.caucho.config.program.ConfigProgram;
import com.caucho.config.types.RawString;
import com.caucho.lifecycle.Lifecycle;
import com.caucho.resin.BeanEmbed;
import com.caucho.resin.HttpEmbed;
import com.caucho.resin.PortEmbed;
import com.caucho.resin.WebAppEmbed;
import com.caucho.resin.WebAppLocalDeployEmbed;
import com.caucho.server.cluster.Cluster;
import com.caucho.server.cluster.ClusterServer;
import com.caucho.server.cluster.Server;
import com.caucho.server.connection.StreamConnection;
import com.caucho.server.host.Host;
import com.caucho.server.host.HostConfig;
import com.caucho.server.http.HttpRequest;
import com.caucho.server.resin.Resin;
import com.caucho.server.webapp.WebApp;
import com.caucho.server.webapp.WebAppConfig;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.VfsStream;
import com.caucho.vfs.WriteStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.util.ArrayList;

public class ResinEmbed {
    private static final String EMBED_CONF = "classpath:com/caucho/resin/resin-embed.xml";
    private Resin _resin = new Resin();
    private Cluster _cluster;
    private ClusterServer _clusterServer;
    private Host _host;
    private Server _server;
    private String _serverHeader;
    private final ArrayList<BeanEmbed> _beanList = new ArrayList();
    private final ArrayList<WebAppEmbed> _webAppList = new ArrayList();
    private Lifecycle _lifecycle = new Lifecycle();

    public ResinEmbed() {
        this(EMBED_CONF);
    }

    public ResinEmbed(String configFile) {
        try {
            Config config = new Config();
            config.configure((Object)this._resin, Vfs.lookup(configFile));
        }
        catch (Exception e) {
            throw ConfigException.create((Throwable)e);
        }
        this._cluster = this._resin.findCluster("");
        this._clusterServer = this._cluster.findServer("");
    }

    public void addPort(PortEmbed port) {
        port.bindTo(this._clusterServer);
    }

    public void setPorts(PortEmbed[] ports) {
        for (PortEmbed port : ports) {
            this.addPort(port);
        }
    }

    public void setServerHeader(String serverName) {
        this._serverHeader = serverName;
    }

    public void addWebApp(WebAppEmbed webApp) {
        if (webApp == null) {
            throw new NullPointerException();
        }
        this._webAppList.add(webApp);
    }

    public void setWebApps(WebAppEmbed[] webApps) {
        for (WebAppEmbed webApp : webApps) {
            this.addWebApp(webApp);
        }
    }

    public void addBean(BeanEmbed bean) {
        this._beanList.add(bean);
        if (this._lifecycle.isActive()) {
            Thread thread = Thread.currentThread();
            ClassLoader oldLoader = thread.getContextClassLoader();
            try {
                try {
                    thread.setContextClassLoader(this._server.getClassLoader());
                    bean.configure();
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Throwable e) {
                    throw ConfigException.create((Throwable)e);
                }
                Object var6_4 = null;
                thread.setContextClassLoader(oldLoader);
            }
            catch (Throwable throwable) {
                Object var6_5 = null;
                thread.setContextClassLoader(oldLoader);
                throw throwable;
            }
        }
    }

    public void start() {
        if (!this._lifecycle.toActive()) {
            return;
        }
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            try {
                this._resin.start();
                this._server = this._resin.getServer();
                thread.setContextClassLoader(this._server.getClassLoader());
                if (this._serverHeader != null) {
                    this._server.setServerHeader(this._serverHeader);
                }
                for (BeanEmbed beanEmbed : this._beanList) {
                    beanEmbed.configure();
                }
                HostConfig hostConfig = new HostConfig();
                this._server.addHost(hostConfig);
                this._host = this._server.getHost("", 0);
                thread.setContextClassLoader(this._host.getClassLoader());
                for (WebAppEmbed webApp : this._webAppList) {
                    WebAppConfig config = new WebAppConfig();
                    config.setContextPath(webApp.getContextPath());
                    config.setRootDirectory(new RawString(webApp.getRootDirectory()));
                    config.addBuilderProgram(new WebAppProgram(webApp));
                    this._host.addWebApp(config);
                }
                Object var8_8 = null;
                thread.setContextClassLoader(oldLoader);
            }
            catch (Exception e) {
                throw ConfigException.create((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            thread.setContextClassLoader(oldLoader);
            throw throwable;
        }
    }

    public void stop() {
        if (!this._lifecycle.toStop()) {
            return;
        }
        try {
            this._resin.stop();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw ConfigException.create((Throwable)e);
        }
    }

    public void join() {
        while (!this._resin.isClosed()) {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {}
        }
    }

    public void destroy() {
        if (!this._lifecycle.toDestroy()) {
            return;
        }
        try {
            this._resin.destroy();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw ConfigException.create((Throwable)e);
        }
    }

    public void request(InputStream is, OutputStream os) throws IOException {
        this.start();
        TestConnection conn = this.createConnection();
        conn.request(is, os);
    }

    public void request(String httpRequest, OutputStream os) throws IOException {
        this.start();
        TestConnection conn = this.createConnection();
        conn.request(httpRequest, os);
    }

    public String request(String httpRequest) throws IOException {
        this.start();
        TestConnection conn = this.createConnection();
        return conn.request(httpRequest);
    }

    private TestConnection createConnection() {
        TestConnection conn = new TestConnection();
        return conn;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.destroy();
    }

    public static void main(String[] args) throws Exception {
        ResinEmbed resin = new ResinEmbed();
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("--port=")) {
                int port = Integer.parseInt(args[i].substring("--port=".length()));
                HttpEmbed http = new HttpEmbed(port);
                resin.addPort(http);
                continue;
            }
            if (!args[i].startsWith("--deploy:")) continue;
            String valueString = args[i].substring("--deploy:".length());
            String[] values = valueString.split("[=,]");
            String role = null;
            for (int j = 0; j < values.length; j += 2) {
                if (!values[j].equals("role")) continue;
                role = values[j + 1];
            }
            WebAppLocalDeployEmbed webApp = new WebAppLocalDeployEmbed();
            if (role != null) {
                webApp.setRole(role);
            }
            resin.addWebApp(webApp);
        }
        resin.start();
        resin.join();
    }

    static class WebAppProgram
    extends ConfigProgram {
        private final WebAppEmbed _config;

        WebAppProgram(WebAppEmbed webAppConfig) {
            this._config = webAppConfig;
        }

        public void inject(Object bean, ConfigContext env) throws ConfigException {
            this._config.configure((WebApp)bean);
        }
    }

    private class TestConnection {
        StreamConnection _conn;
        HttpRequest _request;
        VfsStream _vfsStream;
        ReadStream _readStream;
        WriteStream _writeStream;
        InetAddress _localAddress;
        InetAddress _remoteAddress;
        int _port = 6666;
        char[] _chars = new char[1024];
        byte[] _bytes = new byte[1024];

        TestConnection() {
            this._conn = new StreamConnection();
            this._request = new HttpRequest(ResinEmbed.this._resin.getServer(), this._conn);
            this._request.init();
            this._vfsStream = new VfsStream(null, null);
            this._readStream = new ReadStream();
            this._writeStream = new WriteStream();
            try {
                this._localAddress = InetAddress.getByName("127.0.0.1");
                this._remoteAddress = InetAddress.getByName("127.0.0.1");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public HttpRequest getRequest() {
            return this._request;
        }

        public void setVirtualHost(String virtualHost) {
            this._conn.setVirtualHost(virtualHost);
        }

        public void setPort(int port) {
            if (port > 0) {
                this._port = port;
            }
        }

        public void setLocalIP(String ip) throws IOException {
            this._localAddress = InetAddress.getByName(ip);
        }

        public void setRemoteIP(String ip) throws IOException {
            this._remoteAddress = InetAddress.getByName(ip);
        }

        public void setSecure(boolean isSecure) {
            this._conn.setSecure(isSecure);
        }

        public String request(String input) throws IOException {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            this.request(input, (OutputStream)os);
            return ((Object)os).toString();
        }

        public boolean allocateKeepalive() {
            return true;
        }

        public void request(String input, OutputStream os) throws IOException {
            int len = input.length();
            if (this._chars.length < len) {
                this._chars = new char[len];
                this._bytes = new byte[len];
            }
            input.getChars(0, len, this._chars, 0);
            for (int i = 0; i < len; ++i) {
                this._bytes[i] = (byte)this._chars[i];
            }
            ByteArrayInputStream is = new ByteArrayInputStream(this._bytes, 0, len);
            this.request(is, os);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void request(InputStream is, OutputStream os) throws IOException {
            Thread.yield();
            WriteStream out = Vfs.openWrite(os);
            out.setDisableClose(true);
            ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
            try {
                try {
                    this._vfsStream.init(is, os);
                    this._conn.setStream(is, os);
                    this._conn.setLocalAddress(this._localAddress);
                    this._conn.setLocalPort(this._port);
                    this._conn.setRemoteAddress(this._remoteAddress);
                    this._conn.setRemotePort(9666);
                    try {
                        Thread.sleep(10L);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    while (this._request.handleRequest()) {
                        out.flush();
                    }
                    Object var7_7 = null;
                }
                catch (EOFException e) {
                    Object var7_8 = null;
                    out.flush();
                    Thread.currentThread().setContextClassLoader(oldLoader);
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                out.flush();
                Thread.currentThread().setContextClassLoader(oldLoader);
                throw throwable;
            }
            out.flush();
            Thread.currentThread().setContextClassLoader(oldLoader);
        }

        public void close() {
        }
    }
}

