/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.resin;

import com.caucho.config.ConfigException;
import com.caucho.config.program.ContainerProgram;
import com.caucho.config.program.PropertyValueProgram;
import com.caucho.resin.ServletProtocolEmbed;
import com.caucho.server.dispatch.ServletMapping;
import java.util.HashMap;
import java.util.Map;

public class ServletMappingEmbed {
    private String _urlPattern;
    private String _servletName;
    private String _servletClass;
    private int _loadOnStartup = -1;
    private HashMap<String, String> _initParamMap = new HashMap();
    private ContainerProgram _init = new ContainerProgram();
    private ServletProtocolEmbed _protocol;

    public ServletMappingEmbed() {
    }

    public ServletMappingEmbed(String servletName) {
        this.setServletName(servletName);
    }

    public ServletMappingEmbed(String servletName, String urlPattern) {
        this.setServletName(servletName);
        this.setUrlPattern(urlPattern);
    }

    public ServletMappingEmbed(String servletName, String urlPattern, String servletClass) {
        this.setUrlPattern(urlPattern);
        this.setServletName(servletName);
        this.setServletClass(servletClass);
    }

    public void setServletName(String servletName) {
        this._servletName = servletName;
    }

    public String getServletName() {
        return this._servletName;
    }

    public void setServletClass(String servletClass) {
        this._servletClass = servletClass;
    }

    public String getServletClass() {
        return this._servletClass;
    }

    public void setUrlPattern(String urlPattern) {
        this._urlPattern = urlPattern;
    }

    public String getUrlPattern() {
        return this._urlPattern;
    }

    public void setLoadOnStartup(int loadOnStartup) {
        this._loadOnStartup = loadOnStartup;
    }

    public void setInitParam(String name, String value) {
        this._initParamMap.put(name, value);
    }

    public void addProperty(String name, Object value) {
        this._init.addProgram(new PropertyValueProgram(name, value));
    }

    public void setProtocol(ServletProtocolEmbed protocol) {
        this._protocol = protocol;
    }

    protected void configure(ServletMapping servletMapping) {
        try {
            if (this._urlPattern != null) {
                servletMapping.addURLPattern(this._urlPattern);
            }
            servletMapping.setServletName(this._servletName);
            if (this._servletClass != null) {
                servletMapping.setServletClass(this._servletClass);
            }
            for (Map.Entry<String, String> entry : this._initParamMap.entrySet()) {
                servletMapping.setInitParam(entry.getKey(), entry.getValue());
            }
            servletMapping.setInit(this._init);
            if (this._loadOnStartup >= 0) {
                servletMapping.setLoadOnStartup(this._loadOnStartup);
            }
            if (this._protocol != null) {
                servletMapping.setProtocol(this._protocol.createProtocol());
            }
            servletMapping.init();
        }
        catch (Exception e) {
            throw ConfigException.create((Throwable)e);
        }
    }
}

