/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.resin;

import com.caucho.config.ConfigException;
import com.caucho.config.program.ContainerProgram;
import com.caucho.config.types.InitParam;
import com.caucho.resin.BeanEmbed;
import com.caucho.resin.FilterEmbed;
import com.caucho.resin.FilterMappingEmbed;
import com.caucho.resin.ServletEmbed;
import com.caucho.resin.ServletMappingEmbed;
import com.caucho.server.dispatch.FilterConfigImpl;
import com.caucho.server.dispatch.FilterMapping;
import com.caucho.server.dispatch.ServletConfigImpl;
import com.caucho.server.dispatch.ServletMapping;
import com.caucho.server.webapp.WebApp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class WebAppEmbed {
    private String _contextPath = "/";
    private String _rootDirectory = ".";
    private String _archivePath;
    private HashMap<String, String> _contextParamMap = new HashMap();
    private ContainerProgram _init = new ContainerProgram();
    private final ArrayList<BeanEmbed> _beanList = new ArrayList();
    private final ArrayList<ServletEmbed> _servletList = new ArrayList();
    private final ArrayList<ServletMappingEmbed> _servletMappingList = new ArrayList();
    private final ArrayList<FilterEmbed> _filterList = new ArrayList();
    private final ArrayList<FilterMappingEmbed> _filterMappingList = new ArrayList();

    public WebAppEmbed() {
    }

    public WebAppEmbed(String contextPath) {
        this.setContextPath(contextPath);
    }

    public WebAppEmbed(String contextPath, String rootDirectory) {
        this.setContextPath(contextPath);
        this.setRootDirectory(rootDirectory);
    }

    public void setContextPath(String contextPath) {
        this._contextPath = contextPath;
    }

    public String getContextPath() {
        return this._contextPath;
    }

    public void setRootDirectory(String rootDirectory) {
        this._rootDirectory = rootDirectory;
    }

    public String getRootDirectory() {
        return this._rootDirectory;
    }

    public void setArchivePath(String archivePath) {
        this._archivePath = archivePath;
    }

    public String getArchivePath() {
        return this._archivePath;
    }

    public void addServlet(ServletEmbed servlet) {
        if (servlet == null) {
            throw new NullPointerException();
        }
        this._servletList.add(servlet);
    }

    public void addServletMapping(ServletMappingEmbed servletMapping) {
        if (servletMapping == null) {
            throw new NullPointerException();
        }
        this._servletMappingList.add(servletMapping);
    }

    public void addFilter(FilterEmbed filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        this._filterList.add(filter);
    }

    public void addFilterMapping(FilterMappingEmbed filterMapping) {
        if (filterMapping == null) {
            throw new NullPointerException();
        }
        this._filterMappingList.add(filterMapping);
    }

    public void addBean(BeanEmbed bean) {
        this._beanList.add(bean);
    }

    public void setContextParam(String name, String value) {
        this._contextParamMap.put(name, value);
    }

    protected void configure(WebApp webApp) {
        try {
            for (Map.Entry<String, String> entry : this._contextParamMap.entrySet()) {
                InitParam initParam = new InitParam(entry.getKey(), entry.getValue());
                webApp.addContextParam(initParam);
            }
            for (BeanEmbed beanEmbed : this._beanList) {
                beanEmbed.configure();
            }
            for (ServletEmbed servletEmbed : this._servletList) {
                ServletConfigImpl servlet = webApp.createServlet();
                servletEmbed.configure(servlet);
                webApp.addServlet(servlet);
            }
            for (ServletMappingEmbed servletMappingEmbed : this._servletMappingList) {
                ServletMapping servletMapping = webApp.createServletMapping();
                servletMappingEmbed.configure(servletMapping);
                webApp.addServletMapping(servletMapping);
            }
            for (FilterEmbed filterEmbed : this._filterList) {
                FilterConfigImpl filter = new FilterConfigImpl();
                filterEmbed.configure(filter);
                webApp.addFilter(filter);
            }
            for (FilterMappingEmbed filterMappingEmbed : this._filterMappingList) {
                FilterMapping filterMapping = new FilterMapping();
                filterMappingEmbed.configure(filterMapping);
                webApp.addFilterMapping(filterMapping);
            }
        }
        catch (Exception e) {
            throw ConfigException.create((Throwable)e);
        }
    }
}

