/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.resin.deploy;

import com.caucho.config.types.RawString;
import com.caucho.server.webapp.WebApp;
import com.caucho.server.webapp.WebAppConfig;
import com.caucho.server.webapp.WebAppContainer;
import com.caucho.server.webapp.WebAppController;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.servlet.GenericServlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class LocalDeployServlet
extends GenericServlet {
    private static final Logger log = Logger.getLogger(LocalDeployServlet.class.getName());
    private static final L10N L = new L10N(LocalDeployServlet.class);
    private boolean _isEnable;
    private String _role = "manager";
    private HashMap<String, WebAppContainer> _webAppMap = new HashMap();

    public void setEnable(boolean isEnable) {
        this._isEnable = isEnable;
    }

    public void setRole(String role) {
        this._role = "*".equals(role) || "".equals(role) || "any".equals(role) ? null : role;
    }

    public WebApp getWebApp() {
        return (WebApp)this.getServletContext();
    }

    public WebAppContainer getWebAppContainer() {
        return this.getWebApp().getParent();
    }

    public void service(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        if (!this._isEnable) {
            log.warning(L.l("LocalDeployServlet[] non-enabled access from IP='{0}'", (Object)req.getRemoteAddr()));
            res.sendError(403);
            return;
        }
        String addr = req.getRemoteAddr();
        if (!addr.startsWith("127.")) {
            log.warning(L.l("LocalDeployServlet[] non-local access from IP='{0}'", (Object)req.getRemoteAddr()));
            res.sendError(403);
            return;
        }
        if (this._role != null && !req.isUserInRole(this._role)) {
            log.warning(L.l("LocalDeployServlet[] user not in role '{0}' from IP='{1}'", (Object)this._role, (Object)req.getRemoteAddr()));
            res.sendError(403);
            return;
        }
        String action = req.getParameter("action");
        if (!"add-web-app".equals(action)) {
            log.warning(L.l("LocalDeployServlet[] unknown action '{0}' from IP='{1}'", (Object)action, (Object)req.getRemoteAddr()));
            res.sendError(403);
            return;
        }
        this.addWebApp(req, res);
    }

    private void addWebApp(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        Path warPath;
        Path rootDirectory;
        String contextPath = req.getParameter("context-path");
        String root = req.getParameter("root");
        String war = req.getParameter("war");
        if ("".equals(root)) {
            root = null;
        }
        if ("".equals(war)) {
            war = null;
        }
        if (contextPath == null || "".equals(contextPath)) {
            log.warning(L.l("LocalDeployServlet[] add-web-app requires context-path from IP='{0}'", (Object)req.getRemoteAddr()));
            res.sendError(403);
            return;
        }
        if (root == null && war == null) {
            log.warning(L.l("LocalDeployServlet[] add-web-app requires root or war from IP='{0}'", (Object)req.getRemoteAddr()));
            res.sendError(403);
            return;
        }
        WebAppContainer container = this.getWebAppContainer();
        Path containerRoot = container.getRootDirectory();
        if (root == null) {
            rootDirectory = containerRoot.lookup("work").lookup("./" + contextPath);
            rootDirectory.mkdirs();
        } else {
            rootDirectory = containerRoot.lookup(root);
        }
        if (war != null && !(warPath = containerRoot.lookup(war)).exists()) {
            log.warning(L.l("LocalDeployServlet[] add-web-app war='{0}' cannot be read, from IP='{0}'", (Object)warPath.getURL(), (Object)req.getRemoteAddr()));
        }
        WebAppController controller = container.findController(contextPath);
        PrintWriter out = res.getWriter();
        if (controller != null) {
            out.println("web-app " + contextPath + " exists");
            return;
        }
        WebAppConfig webApp = new WebAppConfig();
        webApp.setContextPath(contextPath);
        webApp.setRootDirectory(new RawString(rootDirectory.getURL()));
        if (war != null) {
            webApp.setArchivePath(new RawString(war));
        }
        try {
            container.addWebApp(webApp);
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        out.println("OK");
    }
}

