/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.resources;

import com.caucho.config.ConfigException;
import com.caucho.config.types.BeanConfig;
import com.caucho.config.types.CronType;
import com.caucho.config.types.Period;
import com.caucho.config.types.Trigger;
import com.caucho.loader.Environment;
import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.loader.EnvironmentListener;
import com.caucho.resources.TimerTrigger;
import com.caucho.server.connection.StubServletRequest;
import com.caucho.server.connection.StubServletResponse;
import com.caucho.server.webapp.WebApp;
import com.caucho.util.Alarm;
import com.caucho.util.AlarmListener;
import com.caucho.util.L10N;
import com.caucho.webbeans.manager.WebBeansContainer;
import java.lang.annotation.Annotation;
import java.util.Date;
import java.util.TimerTask;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.el.ELContext;
import javax.el.MethodExpression;
import javax.resource.spi.work.Work;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.webbeans.ComponentFactory;
import javax.webbeans.In;

public class ScheduledTask
extends BeanConfig
implements AlarmListener,
EnvironmentListener {
    private static final L10N L = new L10N(ScheduledTask.class);
    private static final Logger log = Logger.getLogger(ScheduledTask.class.getName());
    @In
    private Executor _threadPool;
    private ClassLoader _loader;
    private Trigger _trigger;
    private TimerTrigger _timerTrigger = new TimerTrigger();
    private Runnable _task;
    private MethodExpression _method;
    private String _url;
    private WebApp _webApp;
    private Alarm _alarm;
    private volatile boolean _isActive;

    public ScheduledTask() {
        this._loader = Thread.currentThread().getContextClassLoader();
        this.setBeanConfigClass(Runnable.class);
    }

    public void setDelay(Period delay) {
        this._trigger = this._timerTrigger;
        this._timerTrigger.setFirstTime(Alarm.getExactTime() + delay.getPeriod());
    }

    public void setPeriod(Period period) {
        this._trigger = this._timerTrigger;
        this._timerTrigger.setPeriod(period.getPeriod());
    }

    public void setCron(String cron) {
        this._trigger = new CronType(cron);
    }

    public void setMethod(MethodExpression method) {
        this._method = method;
    }

    public void setUrl(String url) {
        if (!url.startsWith("/")) {
            throw new ConfigException(L.l("url '{0}' must be absolute", (Object)url));
        }
        this._url = url;
        ComponentFactory<WebApp> comp = WebBeansContainer.create().resolveByType(WebApp.class, new Annotation[0]);
        if (comp == null) {
            throw new ConfigException(L.l("relative url '{0}' requires web-app context", (Object)url));
        }
        this._webApp = (WebApp)comp.get();
    }

    @Deprecated
    public void setWork(Runnable work) {
        this.setTask(work);
    }

    public void setTask(Runnable task) {
        this._task = task;
        this.setClass(task.getClass());
    }

    @PostConstruct
    public void init() throws ConfigException {
        if (this._method != null) {
            this._task = new MethodTask(this._method);
        } else if (this._url == null) {
            super.init();
        }
        if (this._trigger == null) {
            this._timerTrigger.setFirstTime(0x3FFFFFFFFFFFFFFFL);
            this._trigger = this._timerTrigger;
        }
        Environment.addEnvironmentListener(this);
    }

    private void start() {
        long now = Alarm.getExactTime();
        long nextTime = this._trigger.nextTime(now);
        this._isActive = true;
        if (this._url != null) {
            this._task = new ServletTask(this._url, this._webApp);
        }
        if (this._task == null) {
            this._task = (Runnable)this.getObject();
        }
        assert (this._task != null);
        this._alarm = new Alarm("cron-resource", (AlarmListener)this, nextTime - now);
        if (log.isLoggable(Level.FINER)) {
            log.finer(this + " started. Next event at " + new Date(nextTime));
        }
    }

    private void stop() {
        this._isActive = false;
        Alarm alarm = this._alarm;
        this._alarm = null;
        if (alarm != null) {
            alarm.dequeue();
        }
        if (this._task instanceof Work) {
            ((Work)this._task).release();
        } else if (this._task instanceof TimerTask) {
            ((TimerTask)this._task).cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleAlarm(Alarm alarm) {
        if (!this._isActive) {
            return;
        }
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            Object var6_4;
            try {
                thread.setContextClassLoader(this._loader);
                log.fine(this + " executing " + this._task);
                this._threadPool.execute(this._task);
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString(), e);
                var6_4 = null;
                thread.setContextClassLoader(oldLoader);
            }
            var6_4 = null;
            thread.setContextClassLoader(oldLoader);
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            thread.setContextClassLoader(oldLoader);
            throw throwable;
        }
        long now = Alarm.getExactTime();
        long nextTime = this._trigger.nextTime(now);
        if (this._isActive) {
            alarm.queue(nextTime - now);
        }
    }

    public void environmentBind(EnvironmentClassLoader loader) throws ConfigException {
    }

    public void environmentStart(EnvironmentClassLoader loader) {
        this.start();
    }

    public void environmentStop(EnvironmentClassLoader loader) {
        this.stop();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._task + "," + this._trigger + "]";
    }

    public class ServletTask
    implements Runnable {
        private String _url;
        private WebApp _webApp;

        ServletTask(String url, WebApp webApp) {
            this._url = url;
            this._webApp = webApp;
        }

        public void run() {
            StubServletRequest req = new StubServletRequest();
            StubServletResponse res = new StubServletResponse();
            try {
                RequestDispatcher dispatcher = this._webApp.getRequestDispatcher(this._url);
                dispatcher.forward((ServletRequest)req, (ServletResponse)res);
            }
            catch (Exception e) {
                log.log(Level.FINE, e.toString(), e);
            }
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + this._url + "," + this._webApp + "]";
        }
    }

    public static class MethodTask
    implements Runnable {
        private static final Object[] _args = new Object[0];
        private ELContext _elContext;
        private MethodExpression _method;

        MethodTask(MethodExpression method) {
            this._method = method;
            this._elContext = WebBeansContainer.create().getELContext();
        }

        public void run() {
            this._method.invoke(this._elContext, _args);
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + this._method + "]";
        }
    }
}

