/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.admin;

import com.caucho.hessian.io.AbstractSerializerFactory;
import com.caucho.hessian.io.Deserializer;
import com.caucho.hessian.io.ExtSerializerFactory;
import com.caucho.hessian.io.Hessian2Input;
import com.caucho.hessian.io.Hessian2Output;
import com.caucho.hessian.io.Serializer;
import com.caucho.hessian.io.StringValueDeserializer;
import com.caucho.hessian.io.StringValueSerializer;
import com.caucho.jmx.remote.JMXService;
import com.caucho.server.admin.DeployServiceAPI;
import com.caucho.server.admin.Management;
import com.caucho.server.admin.ManagementService;
import com.caucho.util.L10N;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.management.ObjectName;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class DeployService
extends ManagementService
implements DeployServiceAPI {
    private static final Logger log = Logger.getLogger(JMXService.class.getName());
    private static final L10N L = new L10N(DeployService.class);
    private ExtSerializerFactory _extFactory;

    public DeployService(Management management) {
        super(management, "resin-deploy-service");
    }

    public void start() {
        super.start();
        this._extFactory = new ExtSerializerFactory();
        this._extFactory.addSerializer(ObjectName.class, (Serializer)new StringValueSerializer());
        this._extFactory.addDeserializer(ObjectName.class, (Deserializer)new StringValueDeserializer(ObjectName.class));
        log.info(L.l("Deploy management service started"));
    }

    public void service(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        Hessian2Input in = new Hessian2Input((InputStream)request.getInputStream());
        Hessian2Output out = new Hessian2Output((OutputStream)response.getOutputStream());
        out.findSerializerFactory().addFactory((AbstractSerializerFactory)this._extFactory);
        in.startCall();
        String method = in.getMethod();
        try {
            if ("getTargets".equals(method)) {
                if (!this.isReadAllowed(request, response)) {
                    return;
                }
                in.completeCall();
                log.finer("DeployService: getTargets");
                Target[] targets = this.getTargets();
                out.startReply();
                out.writeObject((Object)targets);
                out.completeReply();
                out.close();
            } else if ("getAvailableModules".equals(method)) {
                if (!this.isReadAllowed(request, response)) {
                    return;
                }
                String moduleType = in.readString();
                in.completeCall();
                log.finer("DeployService: getAvailableModules " + moduleType);
                TargetModuleID[] modules = this.getAvailableModules(moduleType);
                out.startReply();
                out.writeObject((Object)modules);
                out.completeReply();
                out.close();
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    public TargetModuleID[] getAvailableModules(String moduleType) {
        throw new UnsupportedOperationException("unimplemented");
    }

    public Target[] getTargets() {
        throw new UnsupportedOperationException("unimplemented");
    }

    public void distribute(Target[] targets, InputStream deploymentPlan, InputStream archiveIs) {
        throw new UnsupportedOperationException("unimplemented");
    }

    public void start(TargetModuleID[] ids) {
        throw new UnsupportedOperationException("unimplemented");
    }

    public void stop(TargetModuleID[] ids) {
        throw new UnsupportedOperationException("unimplemented");
    }

    public void undeploy(TargetModuleID[] ids) {
        throw new UnsupportedOperationException("unimplemented");
    }
}

