/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.admin;

import java.io.Serializable;
import javax.enterprise.deploy.shared.ActionType;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.shared.StateType;
import javax.enterprise.deploy.spi.status.DeploymentStatus;

public class DeploymentStatusImpl
implements DeploymentStatus,
Serializable {
    public static final int RUNNING = 0;
    public static final int COMPLETED = 1;
    public static final int FAILED = 2;
    public static final int RELEASED = 3;
    private String _message;
    private int _state = 0;

    public StateType getState() {
        switch (this._state) {
            case 0: {
                return StateType.RUNNING;
            }
            case 1: {
                return StateType.COMPLETED;
            }
            case 2: {
                return StateType.FAILED;
            }
            case 3: {
                return StateType.RELEASED;
            }
        }
        return StateType.FAILED;
    }

    public void setState(StateType stateType) {
        if (stateType == StateType.RUNNING) {
            this._state = 0;
        } else if (stateType == StateType.COMPLETED) {
            this._state = 1;
        } else if (stateType == StateType.FAILED) {
            this._state = 2;
        } else if (stateType == StateType.RELEASED) {
            this._state = 3;
        } else {
            throw new AssertionError(stateType);
        }
    }

    public CommandType getCommand() {
        return CommandType.DISTRIBUTE;
    }

    public ActionType getAction() {
        return ActionType.EXECUTE;
    }

    public String getMessage() {
        return this._message;
    }

    public void setMessage(String message) {
        this._message = message;
    }

    public boolean isCompleted() {
        return this._state == 1;
    }

    public boolean isFailed() {
        return this._state == 2;
    }

    public boolean isRunning() {
        return this._state == 0;
    }

    public String toString() {
        return "DeploymentStatusImpl[" + this.getState() + "," + this.getMessage() + "]";
    }
}

