/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.admin;

import com.caucho.hessian.io.Hessian2Input;
import com.caucho.hessian.io.HessianOutput;
import com.caucho.hessian.io.HessianProtocolException;
import com.caucho.util.CharBuffer;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.ReadWritePair;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HessianHmuxProxy
implements InvocationHandler {
    private Path _path;

    private HessianHmuxProxy(Path url) {
        this._path = url;
    }

    public static <X> X create(Path url, Class<X> api) {
        Thread thread = Thread.currentThread();
        return (X)Proxy.newProxyInstance(thread.getContextClassLoader(), new Class[]{api}, (InvocationHandler)new HessianHmuxProxy(url));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object object;
        String methodName = method.getName();
        Class<?>[] params = method.getParameterTypes();
        if (methodName.equals("equals") && params.length == 1 && params[0].equals(Object.class)) {
            Object value = args[0];
            if (value == null) return new Boolean(false);
            if (!Proxy.isProxyClass(value.getClass())) {
                return new Boolean(false);
            }
            HessianHmuxProxy handler = (HessianHmuxProxy)Proxy.getInvocationHandler(value);
            return new Boolean(this._path.equals((Object)handler._path));
        }
        if (methodName.equals("hashCode") && params.length == 0) {
            return new Integer(this._path.hashCode());
        }
        if (methodName.equals("getHessianType")) {
            return proxy.getClass().getInterfaces()[0].getName();
        }
        if (methodName.equals("getHessianURL")) {
            return this._path.toString();
        }
        if (methodName.equals("toString") && params.length == 0) {
            return "HessianHmuxProxy[" + this._path + "]";
        }
        ReadStream is = null;
        try {
            try {
                methodName = args != null ? methodName + "__" + args.length : methodName + "__0";
                is = this.sendRequest(methodName, args);
                String code = (String)is.getAttribute("status");
                if (!"200".equals(code)) {
                    CharBuffer sb = new CharBuffer();
                    while (is.readLine(sb)) {
                    }
                    throw new HessianProtocolException(code + ": " + sb);
                }
                Hessian2Input in = new Hessian2Input((InputStream)is);
                object = in.readReply(method.getReturnType());
                Object var11_14 = null;
            }
            catch (HessianProtocolException e) {
                throw new RuntimeException(e);
            }
        }
        catch (Throwable throwable) {
            Object var11_15 = null;
            try {
                if (is == null) throw throwable;
                is.close();
                throw throwable;
            }
            catch (Throwable e2) {
                throw throwable;
            }
        }
        try {}
        catch (Throwable e2) {
            // empty catch block
            return object;
        }
        if (is == null) return object;
        is.close();
        return object;
    }

    private ReadStream sendRequest(String methodName, Object[] args) throws IOException {
        ReadWritePair pair = this._path.openReadWrite();
        ReadStream is = pair.getReadStream();
        WriteStream os = pair.getWriteStream();
        try {
            HessianOutput out = new HessianOutput((OutputStream)os);
            out.call(methodName, args);
            out.flush();
            return is;
        }
        catch (IOException e) {
            try {
                os.close();
            }
            catch (Exception e1) {
                // empty catch block
            }
            try {
                is.close();
            }
            catch (Exception e1) {
                // empty catch block
            }
            throw e;
        }
        catch (RuntimeException e) {
            try {
                os.close();
            }
            catch (Exception e1) {
                // empty catch block
            }
            try {
                is.close();
            }
            catch (Exception e1) {
                // empty catch block
            }
            throw e;
        }
    }
}

