/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.admin;

import com.caucho.config.ConfigException;
import com.caucho.config.types.RawString;
import com.caucho.lifecycle.Lifecycle;
import com.caucho.security.BasicPrincipal;
import com.caucho.server.admin.ManagementAuthenticator;
import com.caucho.server.admin.TransactionLog;
import com.caucho.server.admin.TransactionManager;
import com.caucho.server.cluster.Cluster;
import com.caucho.server.cluster.DeployManagementService;
import com.caucho.server.cluster.Server;
import com.caucho.server.host.HostConfig;
import com.caucho.server.resin.Resin;
import com.caucho.server.security.PasswordUser;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.webbeans.manager.WebBeansContainer;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.resource.spi.ResourceAdapter;
import javax.webbeans.Standard;

public class Management {
    private static L10N L = new L10N(Management.class);
    private static Logger log = Logger.getLogger(Management.class.getName());
    public static final String HOST_NAME = "admin.caucho";
    private Cluster _cluster;
    private Resin _resin;
    private Server _server;
    private Path _path;
    private HostConfig _hostConfig;
    private ManagementAuthenticator _auth;
    private DeployManagementService _deployService;
    protected TransactionManager _transactionManager;
    private Lifecycle _lifecycle = new Lifecycle();

    public void setCluster(Cluster cluster) {
        this._cluster = cluster;
    }

    public void setResin(Resin resin) {
        this._resin = resin;
    }

    public void setServer(Server server) {
        this._server = server;
    }

    public String getServerId() {
        return Cluster.getServerId();
    }

    public void setPath(Path path) {
        this._path = path;
    }

    public Path getPath() {
        return this._path;
    }

    public void addUser(User user) {
        if (this._auth == null) {
            this._auth = new ManagementAuthenticator();
        }
        this._auth.addUser(user.getName(), user.getPasswordUser());
    }

    public String getRemoteCookie() {
        if (this._auth != null) {
            return this._auth.getHash();
        }
        return null;
    }

    public DeployManagementService createDeployService() {
        if (this._deployService == null) {
            this._deployService = new DeployManagementService(this);
        }
        return this._deployService;
    }

    public Object createJmxService() {
        throw new ConfigException(L.l("jmx-service requires Resin Professional"));
    }

    public ResourceAdapter createPing() {
        throw new ConfigException(L.l("ping requires Resin Professional"));
    }

    public void addPing(ResourceAdapter ping) {
        throw new ConfigException(L.l("ping requires Resin Professional"));
    }

    public Object createLogService() {
        throw new ConfigException(L.l("'log-service' management requires Resin Professional"));
    }

    public Object createStatService() {
        throw new ConfigException(L.l("'stat-service' management requires Resin Professional"));
    }

    public TransactionLog createXaLogService() {
        return this.createTransactionManager().createTransactionLog();
    }

    @Deprecated
    public void setManagementPath(Path managementPath) {
        if (this._path == null) {
            this._path = managementPath;
        }
    }

    @Deprecated
    public TransactionManager createTransactionManager() throws ConfigException {
        if (this._transactionManager == null) {
            this._transactionManager = new TransactionManager(this);
        }
        return this._transactionManager;
    }

    @PostConstruct
    public void init() {
        try {
            if (!this._lifecycle.toInit()) {
                return;
            }
            if (this._auth != null) {
                this._auth.init();
                WebBeansContainer webBeans = WebBeansContainer.create();
                webBeans.addSingleton(this._auth, "resin-admin", Standard.class);
            }
            if (this._transactionManager != null) {
                this._transactionManager.start();
            }
        }
        catch (Exception e) {
            throw ConfigException.create((Throwable)e);
        }
    }

    public void start(Server server) {
        try {
            if (this.getPath() != null) {
                this.getPath().mkdirs();
            }
        }
        catch (Exception e) {
            throw ConfigException.create((Throwable)e);
        }
        if (this._deployService != null) {
            this._deployService.start();
        }
    }

    public HostConfig getHostConfig() {
        if (this._hostConfig == null) {
            HostConfig hostConfig = new HostConfig();
            hostConfig.setId(HOST_NAME);
            hostConfig.setRootDirectory(new RawString("/bogus-admin"));
            hostConfig.setSkipDefaultConfig(true);
            hostConfig.init();
            try {
                if (this._server == null) {
                    this._server = this._resin.getServer();
                }
                if (this._server != null) {
                    this._server.addHost(hostConfig);
                }
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw ConfigException.create((Throwable)e);
            }
            this._hostConfig = hostConfig;
        }
        return this._hostConfig;
    }

    protected Cluster getCluster() {
        if (this._cluster == null) {
            this._cluster = Cluster.getLocal();
        }
        return this._cluster;
    }

    public void dumpThreads() {
    }

    public void destroy() {
        TransactionManager transactionManager = this._transactionManager;
        this._transactionManager = null;
        DeployManagementService deployService = this._deployService;
        this._deployService = null;
        if (transactionManager != null) {
            transactionManager.destroy();
        }
    }

    public static class User {
        private String _name;
        private String _password;
        private boolean _isDisabled;

        public void setName(String name) {
            this._name = name;
        }

        public String getName() {
            return this._name;
        }

        public void setPassword(String password) {
            this._password = password;
        }

        public String getPassword() {
            return this._password;
        }

        public void setDisable(boolean isDisabled) {
            this._isDisabled = isDisabled;
        }

        public boolean isDisable() {
            return this._isDisabled;
        }

        PasswordUser getPasswordUser() {
            if (this._name == null) {
                throw new ConfigException(L.l("management <user> requires a 'name' attribute"));
            }
            boolean isAnonymous = false;
            return new PasswordUser(new BasicPrincipal(this._name), this._password.toCharArray(), this._isDisabled, isAnonymous, new String[]{"resin-admin"});
        }
    }
}

