/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.admin;

import com.caucho.server.security.AbstractPasswordAuthenticator;
import com.caucho.server.security.PasswordUser;
import com.caucho.util.Base64;
import com.caucho.util.CharBuffer;
import com.caucho.util.Crc64;
import java.util.TreeMap;
import java.util.logging.Logger;

public class ManagementAuthenticator
extends AbstractPasswordAuthenticator {
    private static final Logger log = Logger.getLogger(ManagementAuthenticator.class.getName());
    private TreeMap<String, PasswordUser> _userMap = new TreeMap();
    private String _remoteCookie;

    public void addUser(String name, PasswordUser user) {
        this._userMap.put(name, user);
        this._remoteCookie = null;
    }

    protected PasswordUser getUser(String userName) {
        if (userName == null) {
            return null;
        }
        PasswordUser user = this._userMap.get(userName);
        if (user != null) {
            return user.copy();
        }
        return null;
    }

    public String getHash() {
        if (this._remoteCookie == null) {
            long crc64 = 0L;
            for (PasswordUser user : this._userMap.values()) {
                if (user.isDisabled()) continue;
                String item = user.getPrincipal().getName() + ":" + new String(user.getPassword());
                crc64 = Crc64.generate((long)crc64, (String)item);
            }
            if (crc64 != 0L) {
                CharBuffer cb = new CharBuffer();
                Base64.encode((CharBuffer)cb, (long)crc64);
                this._remoteCookie = cb.toString();
            }
        }
        return this._remoteCookie;
    }
}

