/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.admin;

import com.caucho.server.admin.DeploymentStatusImpl;
import com.caucho.util.L10N;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.shared.StateType;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.OperationUnsupportedException;
import javax.enterprise.deploy.spi.status.ClientConfiguration;
import javax.enterprise.deploy.spi.status.DeploymentStatus;
import javax.enterprise.deploy.spi.status.ProgressEvent;
import javax.enterprise.deploy.spi.status.ProgressListener;
import javax.enterprise.deploy.spi.status.ProgressObject;

public class ProgressObjectImpl
implements ProgressObject {
    private static final Logger log = Logger.getLogger(ProgressObjectImpl.class.getName());
    private static final L10N L = new L10N(ProgressObjectImpl.class);
    private final TargetModuleID[] _targetModuleIDs;
    private final DeploymentStatusImpl _status = new DeploymentStatusImpl();
    private final List<ProgressListener> _listeners = new LinkedList<ProgressListener>();

    ProgressObjectImpl() {
        this._targetModuleIDs = null;
    }

    public ProgressObjectImpl(TargetModuleID[] targetModuleIDs) {
        this._targetModuleIDs = targetModuleIDs;
    }

    public DeploymentStatus getDeploymentStatus() {
        if (this._status != null) {
            return this._status;
        }
        return new DeploymentStatusImpl();
    }

    public TargetModuleID[] getResultTargetModuleIDs() {
        return this._targetModuleIDs;
    }

    public ClientConfiguration getClientConfiguration(TargetModuleID id) {
        throw new UnsupportedOperationException();
    }

    public boolean isCancelSupported() {
        return false;
    }

    public void cancel() throws OperationUnsupportedException {
        throw new OperationUnsupportedException(L.l("'cancel' is not supported"));
    }

    public boolean isStopSupported() {
        return false;
    }

    public void stop() throws OperationUnsupportedException {
        throw new OperationUnsupportedException(L.l("'stop' is not supported"));
    }

    public void completed(String message) {
        boolean isChanged = this._status.getState() != StateType.COMPLETED;
        this._status.setState(StateType.COMPLETED);
        this._status.setMessage(message);
        if (isChanged) {
            this.fireProgressEvent();
        }
    }

    public void failed(String message) {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "failed " + message);
        }
        boolean isChanged = this._status.getState() != StateType.FAILED;
        this._status.setState(StateType.FAILED);
        this._status.setMessage(message);
        if (isChanged) {
            this.fireProgressEvent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProgressListener(ProgressListener listener) {
        List<ProgressListener> list = this._listeners;
        synchronized (list) {
            this._listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProgressListener(ProgressListener listener) {
        List<ProgressListener> list = this._listeners;
        synchronized (list) {
            Iterator<ProgressListener> iter = this._listeners.iterator();
            while (iter.hasNext()) {
                if (iter.next() != listener) continue;
                iter.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireProgressEvent() {
        ProgressListener[] listeners;
        if (this._targetModuleIDs == null || this._targetModuleIDs.length == 0) {
            return;
        }
        List<ProgressListener> list = this._listeners;
        synchronized (list) {
            if (this._listeners.isEmpty()) {
                return;
            }
            listeners = this._listeners.toArray(new ProgressListener[this._listeners.size()]);
        }
        ProgressEvent[] events = new ProgressEvent[this._targetModuleIDs.length];
        for (int i = 0; i < this._targetModuleIDs.length; ++i) {
            events[i] = new ProgressEvent((Object)this, this._targetModuleIDs[i], (DeploymentStatus)this._status);
        }
        for (ProgressListener listener : listeners) {
            for (ProgressEvent event : events) {
                listener.handleProgressEvent(event);
            }
        }
    }

    public String toString() {
        return "ProgressObjectImpl[" + this._status + "]";
    }
}

