/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.admin;

import com.caucho.config.ConfigException;
import com.caucho.util.L10N;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServerConnection;

public class RemoteMBeanConnectionFactory {
    private static final L10N L = new L10N(RemoteMBeanConnectionFactory.class);
    private static final Logger log = Logger.getLogger(RemoteMBeanConnectionFactory.class.getName());
    private static Constructor _constructor;

    public static MBeanServerConnection create(String serverId) {
        try {
            if (_constructor == null) {
                Class<?> cl = Class.forName("com.caucho.server.admin.RemoteMBeanServerConnection");
                _constructor = cl.getConstructor(String.class);
            }
            return (MBeanServerConnection)_constructor.newInstance(serverId);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (InvocationTargetException e) {
            throw ConfigException.create((Throwable)e);
        }
        catch (Exception e) {
            log.log(Level.FINER, e.toString(), e);
            throw new ConfigException(L.l("remote mbeans require Resin Professional"));
        }
    }
}

