/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.cluster;

import com.caucho.server.cluster.BackingContext;
import com.caucho.server.cluster.ObjectBacking;
import com.caucho.util.LruCache;
import java.util.Hashtable;

public class BackingManager {
    private Hashtable<String, BackingContext> _contextMap = new Hashtable();
    private LruCache<BackingKey, ObjectBacking> _backingCache = new LruCache(1024);
    private BackingKey _key = new BackingKey();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectBacking getBacking(String contextId, String objectId) {
        BackingManager backingManager = this;
        synchronized (backingManager) {
            this._key.init(contextId, objectId);
            ObjectBacking backing = (ObjectBacking)this._backingCache.get((Object)this._key);
            if (backing != null) {
                return backing;
            }
            BackingContext context = this.getContext(contextId);
            if (context == null) {
                return null;
            }
            backing = context.getBacking(objectId);
            this._backingCache.put((Object)new BackingKey(contextId, objectId), (Object)backing);
            return backing;
        }
    }

    public BackingContext getContext(String contextId) {
        return this._contextMap.get(contextId);
    }

    public void setContext(String contextId, BackingContext context) {
        this._contextMap.put(contextId, context);
    }

    public void removeContext(String contextId) {
        this._contextMap.remove(contextId);
    }

    static class BackingKey {
        private String _contextId;
        private String _objectId;

        BackingKey() {
        }

        BackingKey(String contextId, String objectId) {
            this._contextId = contextId;
            this._objectId = objectId;
        }

        void init(String contextId, String objectId) {
            this._contextId = contextId;
            this._objectId = objectId;
        }

        public int hashCode() {
            return this._contextId.hashCode() * 65521 + this._objectId.hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof BackingKey)) {
                return false;
            }
            BackingKey key = (BackingKey)o;
            return this._contextId.equals(key._contextId) && this._objectId.equals(key._objectId);
        }
    }
}

