/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.cluster;

import com.caucho.config.ConfigException;
import com.caucho.config.SchemaBean;
import com.caucho.config.program.ConfigProgram;
import com.caucho.config.program.ContainerProgram;
import com.caucho.config.types.Period;
import com.caucho.jmx.Jmx;
import com.caucho.lifecycle.StartLifecycleException;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.loader.Environment;
import com.caucho.loader.EnvironmentBean;
import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.loader.EnvironmentListener;
import com.caucho.loader.EnvironmentLocal;
import com.caucho.management.server.ClusterMXBean;
import com.caucho.server.cluster.ClusterAdmin;
import com.caucho.server.cluster.ClusterPort;
import com.caucho.server.cluster.ClusterServer;
import com.caucho.server.cluster.Machine;
import com.caucho.server.cluster.Server;
import com.caucho.server.cluster.ServerConnector;
import com.caucho.server.cluster.StoreManager;
import com.caucho.server.port.Port;
import com.caucho.server.resin.Resin;
import com.caucho.util.L10N;
import com.caucho.util.RandomUtil;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import com.caucho.webbeans.manager.WebBeansContainer;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Cluster
implements EnvironmentListener,
EnvironmentBean,
SchemaBean {
    private static final L10N L = new L10N(Cluster.class);
    private static final Logger log = Logger.getLogger(Cluster.class.getName());
    protected static final EnvironmentLocal<String> _serverIdLocal = new EnvironmentLocal("caucho.server-id");
    protected static final EnvironmentLocal<Cluster> _clusterLocal = new EnvironmentLocal("caucho.cluster");
    private static final int[] DECODE = new int[128];
    private String _id = "";
    private String _serverId = "";
    private EnvironmentClassLoader _classLoader;
    private Resin _resin;
    private Path _rootDirectory;
    private ClusterAdmin _admin;
    private ObjectName _objectName;
    private ArrayList<ContainerProgram> _serverDefaultList = new ArrayList();
    private ArrayList<Machine> _machineList = new ArrayList();
    private ArrayList<ClusterServer> _serverList = new ArrayList();
    private ClusterServer[] _serverArray = new ClusterServer[0];
    private StoreManager _clusterStore;
    private long _clientMaxIdleTime = 30000L;
    private long _clientFailRecoverTime = 15000L;
    private long _clientWarmupTime = 60000L;
    private long _clientReadTimeout = 600000L;
    private long _clientConnectTimeout = 5000L;
    private ContainerProgram _serverProgram = new ContainerProgram();
    private Server _server;
    private volatile boolean _isClosed;

    public Cluster(Resin resin) {
        this();
        this._resin = resin;
    }

    public Cluster() {
        this._classLoader = new EnvironmentClassLoader("cluster:??");
        _clusterLocal.set(this, this._classLoader);
        Environment.addEnvironmentListener(this, this._classLoader);
        WebBeansContainer.create().addSingletonByName(new Var(), "cluster");
        this._rootDirectory = Vfs.getPwd();
    }

    public static Cluster getLocal() {
        Cluster cluster = _clusterLocal.get();
        return cluster;
    }

    public static Cluster getCluster(ClassLoader loader) {
        Cluster cluster = _clusterLocal.get(loader);
        return cluster;
    }

    public void setId(String id) {
        if (id == null) {
            throw new NullPointerException();
        }
        this._id = id;
        this._classLoader.setId("cluster:" + this._id);
    }

    public String getId() {
        return this._id;
    }

    public Resin getResin() {
        return this._resin;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this._classLoader;
    }

    @Override
    public String getSchema() {
        return "com/caucho/server/resin/cluster.rnc";
    }

    public Path getRootDirectory() {
        return this._rootDirectory;
    }

    public void setRootDirectory(Path rootDirectory) {
        Vfs.setPwd(rootDirectory);
        this._rootDirectory = rootDirectory;
    }

    public ClusterMXBean getAdmin() {
        return this._admin;
    }

    public ClusterServer findServer(String id) {
        for (int i = this._serverList.size() - 1; i >= 0; --i) {
            ClusterServer server = this._serverList.get(i);
            if (server == null || !server.getId().equals(id)) continue;
            return server;
        }
        return null;
    }

    public void addServerDefault(ContainerProgram program) throws Throwable {
        this._serverDefaultList.add(program);
    }

    public Machine createMachine() throws Exception {
        Machine machine = new Machine(this);
        this._machineList.add(machine);
        return machine;
    }

    public ClusterServer createServer() throws Exception {
        Machine machine = this.createMachine();
        return machine.createServer();
    }

    ClusterServer createServer(ClusterServer server) {
        server.setIndex(this._serverList.size());
        for (int i = 0; i < this._serverDefaultList.size(); ++i) {
            this._serverDefaultList.get(i).configure(server);
        }
        return server;
    }

    public void addServer(ClusterServer server) throws ConfigException {
        ClusterServer oldServer = this.findServer(server.getId());
        if (oldServer != null) {
            log.warning(L.l("duplicate <server> with id='{0}'", (Object)server.getId()));
        }
        this._serverList.add(server);
        this._serverArray = new ClusterServer[this._serverList.size()];
        this._serverList.toArray(this._serverArray);
        ClusterServer selfServer = this.getSelfServer();
        if (selfServer == server) {
            WebBeansContainer webBeans = WebBeansContainer.create();
            webBeans.addSingletonByName(new ServerVar(server), "server");
        }
    }

    public ServerConnector findConnector(String address, int port) {
        for (int i = this._serverList.size() - 1; i >= 0; --i) {
            ClusterServer server = this._serverList.get(i);
            ClusterPort clusterPort = server.getClusterPort();
            if (!address.equals(clusterPort.getAddress()) || port != clusterPort.getPort()) continue;
            return null;
        }
        return null;
    }

    public StoreManager getStore() {
        return this._clusterStore;
    }

    void setStore(StoreManager store) {
        this._clusterStore = store;
    }

    public void setClientMaxIdleTime(Period period) {
        this._clientMaxIdleTime = period.getPeriod();
    }

    public long getClientMaxIdleTime() {
        return this._clientMaxIdleTime;
    }

    public void setClientLiveTime(Period period) {
        this.setClientMaxIdleTime(period);
    }

    public void setClientFailRecoverTime(Period period) {
        this._clientFailRecoverTime = period.getPeriod();
    }

    public long getClientFailRecoverTime() {
        return this._clientFailRecoverTime;
    }

    public void setClientDeadTime(Period period) {
        this.setClientFailRecoverTime(period);
    }

    public void setClientWarmupTime(Period period) {
        this._clientWarmupTime = period.getPeriod();
    }

    public long getClientWarmupTime() {
        return this._clientWarmupTime;
    }

    public void setClientConnectTimeout(Period period) {
        this._clientConnectTimeout = period.getPeriod();
    }

    public long getClientConnectTimeout() {
        return this._clientConnectTimeout;
    }

    public void setClientReadTimeout(Period period) {
        this._clientReadTimeout = period.getPeriod();
    }

    public long getClientReadTimeout() {
        return this._clientReadTimeout;
    }

    public void setClientWriteTimeout(Period period) {
    }

    public StoreManager createJdbcStore() throws ConfigException {
        if (this.getStore() != null) {
            throw new ConfigException(L.l("multiple jdbc stores are not allowed in a cluster."));
        }
        StoreManager store = null;
        try {
            Class<?> cl = Class.forName("com.caucho.server.cluster.JdbcStore");
            store = (StoreManager)cl.newInstance();
            store.setCluster(this);
            this.setStore(store);
        }
        catch (Throwable e) {
            log.log(Level.FINER, e.toString(), e);
        }
        if (store == null) {
            throw new ConfigException(L.l("'jdbc' persistent sessions are available in Resin Professional.  See http://www.caucho.com for information and licensing."));
        }
        return store;
    }

    public StoreManager createPrivateFileStore() throws ConfigException {
        StoreManager store = this.createFileStore();
        this.setStore(null);
        return store;
    }

    public StoreManager createFileStore() throws ConfigException {
        if (this.getStore() != null) {
            throw new ConfigException(L.l("multiple file stores are not allowed in a cluster."));
        }
        StoreManager store = null;
        try {
            Class<?> cl = Class.forName("com.caucho.server.cluster.FileStore");
            store = (StoreManager)cl.newInstance();
            store.setCluster(this);
            this.setStore(store);
        }
        catch (Throwable e) {
            log.log(Level.FINER, e.toString(), e);
        }
        if (store == null) {
            throw new ConfigException(L.l("'file' persistent sessions are available in Resin Professional.  See http://www.caucho.com for information and licensing."));
        }
        return store;
    }

    public StoreManager createClusterStore() throws ConfigException {
        if (this.getStore() != null) {
            throw new ConfigException(L.l("multiple cluster stores are not allowed in a cluster."));
        }
        StoreManager store = null;
        try {
            Class<?> cl = Class.forName("com.caucho.server.cluster.ClusterStore");
            store = (StoreManager)cl.newInstance();
            store.setCluster(this);
            this.setStore(store);
        }
        catch (Throwable e) {
            log.log(Level.FINER, e.toString(), e);
        }
        if (store == null) {
            throw new ConfigException(L.l("'cluster' persistent sessions are available in Resin Professional.  See http://www.caucho.com for information and licensing."));
        }
        return store;
    }

    public void addBuilderProgram(ConfigProgram program) {
        this._serverProgram.addProgram(program);
    }

    public void start() throws ConfigException {
        boolean isActive;
        ClusterServer self;
        String serverId = _serverIdLocal.get();
        if (serverId == null) {
            serverId = "";
        }
        if ((self = this.findServer(serverId)) != null) {
            _clusterLocal.set(this);
            isActive = true;
        } else if (_clusterLocal.get() == null && this._serverList.size() == 0) {
            _clusterLocal.set(this);
            isActive = true;
        } else {
            isActive = false;
        }
        try {
            String name = this._id;
            if (name == null) {
                name = "";
            }
            ObjectName objectName = Jmx.getObjectName("type=Cluster,name=" + name);
            this._admin = new ClusterAdmin(this);
            Jmx.register((Object)this._admin, objectName);
            this._objectName = objectName;
        }
        catch (Exception e) {
            log.log(Level.FINER, e.toString(), e);
        }
        for (ClusterServer server : this._serverList) {
            try {
                server.init();
            }
            catch (Exception e) {
                throw ConfigException.create((Throwable)e);
            }
        }
    }

    public static String getServerId() {
        return _serverIdLocal.get();
    }

    public ObjectName getObjectName() {
        return this._objectName == null ? null : this._objectName;
    }

    public ClusterServer getSelfServer() {
        this._serverId = _serverIdLocal.get();
        return this.getServer(this._serverId);
    }

    public ClusterServer[] getServerList() {
        return this._serverArray;
    }

    public ArrayList<Machine> getMachineList() {
        return this._machineList;
    }

    public ClusterServer getServer(String serverId) {
        for (int i = 0; i < this._serverList.size(); ++i) {
            ClusterServer server = this._serverList.get(i);
            if (server == null || !server.getId().equals(serverId)) continue;
            return server;
        }
        return null;
    }

    public ClusterServer getServer(int index) {
        for (int i = 0; i < this._serverList.size(); ++i) {
            ClusterServer server = this._serverList.get(i);
            if (server == null || server.getIndex() != index) continue;
            return server;
        }
        return null;
    }

    public ArrayList<ClusterPort> getServerPorts(String serverId) {
        ArrayList<ClusterPort> ports = new ArrayList<ClusterPort>();
        for (int i = 0; i < this._serverList.size(); ++i) {
            ClusterPort port;
            ClusterServer server = this._serverList.get(i);
            if (server == null || !(port = server.getClusterPort()).getServerId().equals(serverId)) continue;
            ports.add(port);
        }
        return ports;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Server startServer(ClusterServer clusterServer) throws StartLifecycleException {
        Cluster cluster = this;
        synchronized (cluster) {
            if (this._server != null) {
                return this._server;
            }
            Server server = new Server(clusterServer);
            this._serverProgram.configure(server);
            server.start();
            this._server = server;
            return server;
        }
    }

    public long generateBackupCode(int index) {
        int backup;
        ClusterServer[] srunList = this.getServerList();
        int srunLength = srunList.length;
        ArrayList<Machine> machineList = this.getMachineList();
        int machineLength = machineList.size();
        long backupCode = index;
        long backupLength = srunLength;
        if (backupLength < 3L) {
            backupLength = 3L;
        }
        if (srunLength <= 1) {
            backup = 0;
            backupCode |= 0x10000L;
        } else if (srunLength == 2) {
            backup = 0;
            backupCode |= ((long)index + 1L) % 2L << 16;
        } else if (machineLength == 1) {
            int sublen = srunLength - 1;
            if (sublen > 7) {
                sublen = 7;
            }
            backup = RandomUtil.nextInt((int)sublen);
            backupCode |= ((long)(index + backup) + 1L) % backupLength << 16;
        } else {
            int backupMachine;
            Machine machine;
            ArrayList<ClusterServer> serverList;
            ClusterServer primaryServer = srunList[index];
            int machineIndex = primaryServer.getMachine().getIndex();
            int sublen = machineLength - 1;
            if (sublen > 7) {
                sublen = 7;
            }
            ClusterServer server = (serverList = (machine = machineList.get(backupMachine = (machineIndex + RandomUtil.nextInt((int)sublen) + 1) % machineLength)).getServerList()).size() > 1 ? serverList.get(RandomUtil.nextInt((int)serverList.size())) : serverList.get(0);
            backup = (server.getIndex() - index + srunLength) % srunLength - 1;
            backupCode |= ((long)(index + backup) + 1L) % backupLength << 16;
        }
        if (srunLength <= 2) {
            backupCode |= 0x200000000L;
        } else {
            int third;
            int sublen = srunLength - 2;
            if (sublen > 6) {
                sublen = 6;
            }
            if (backup <= (third = RandomUtil.nextInt((int)sublen))) {
                ++third;
            }
            backupCode |= (long)(index + third + 1) % backupLength << 32;
        }
        return backupCode;
    }

    public void generateBackupCode(StringBuilder cb, long backupCode) {
        this.addDigit(cb, (int)(backupCode & 0xFFFFL));
        this.addDigit(cb, (int)(backupCode >> 16 & 0xFFFFL));
        this.addDigit(cb, (int)(backupCode >> 32 & 0xFFFFL));
    }

    public ClusterServer getPrimary(String id, int offset) {
        ClusterServer[] srunList = this.getServerList();
        int srunLength = srunList.length;
        int index = 0;
        if (srunLength < 64) {
            index = Cluster.decode(id.charAt(offset + 0));
        } else {
            int d1 = Cluster.decode(id.charAt(offset + 0));
            int d2 = Cluster.decode(id.charAt(offset + 1));
            index = d1 * 64 + d2;
        }
        if (index < srunLength) {
            return srunList[index];
        }
        return null;
    }

    public ClusterServer getSecondary(String id, int offset) {
        ClusterServer[] srunList = this.getServerList();
        int srunLength = srunList.length;
        int index = 0;
        if (srunLength < 64) {
            index = Cluster.decode(id.charAt(offset + 1));
        } else {
            int d1 = Cluster.decode(id.charAt(offset + 2));
            int d2 = Cluster.decode(id.charAt(offset + 3));
            index = d1 * 64 + d2;
        }
        if (index < srunLength) {
            return srunList[index];
        }
        return null;
    }

    public ClusterServer getTertiary(String id, int offset) {
        ClusterServer[] srunList = this.getServerList();
        int srunLength = srunList.length;
        int index = 0;
        if (srunLength < 64) {
            index = Cluster.decode(id.charAt(offset + 2));
        } else {
            int d1 = Cluster.decode(id.charAt(offset + 4));
            int d2 = Cluster.decode(id.charAt(offset + 5));
            index = d1 * 64 + d2;
        }
        if (index < srunLength) {
            return srunList[index];
        }
        return null;
    }

    private void addDigit(StringBuilder cb, int digit) {
        ClusterServer[] srunList = this.getServerList();
        int srunLength = srunList.length;
        if (srunLength < 64) {
            cb.append(Cluster.convert(digit));
        } else {
            cb.append(Cluster.convert(digit / 64));
            cb.append(Cluster.convert(digit));
        }
    }

    public void classLoaderInit(DynamicClassLoader loader) {
    }

    public void classLoaderDestroy(DynamicClassLoader loader) {
    }

    public void startPersistentStore() {
        try {
            if (this._clusterStore != null) {
                this._clusterStore.start();
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    @Override
    public void environmentBind(EnvironmentClassLoader loader) {
    }

    @Override
    public void environmentStart(EnvironmentClassLoader loader) {
    }

    @Override
    public void environmentStop(EnvironmentClassLoader loader) {
        try {
            this.close();
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Cluster cluster = this;
        synchronized (cluster) {
            if (this._isClosed) {
                return;
            }
            this._isClosed = true;
        }
        for (int i = 0; i < this._serverList.size(); ++i) {
            ClusterServer server = this._serverList.get(i);
            try {
                if (server == null) continue;
                server.close();
                continue;
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
    }

    public String toString() {
        return "Cluster[" + this._id + "]";
    }

    private static char convert(long code) {
        if ((code &= 0x3FL) < 26L) {
            return (char)(97L + code);
        }
        if (code < 52L) {
            return (char)(65L + code - 26L);
        }
        if (code < 62L) {
            return (char)(48L + code - 52L);
        }
        if (code == 62L) {
            return '_';
        }
        return '-';
    }

    public static int decode(int code) {
        return DECODE[code & 0x7F];
    }

    static {
        for (int i = 0; i < 64; ++i) {
            Cluster.DECODE[Cluster.convert((long)((long)i))] = i;
        }
    }

    public class ServerVar {
        private final ClusterServer _server;

        public ServerVar(ClusterServer server) {
            this._server = server;
        }

        public String getId() {
            return this._server.getId();
        }

        private int getPort(Port port) {
            if (port == null) {
                return 0;
            }
            return port.getPort();
        }

        private String getAddress(Port port) {
            if (port == null) {
                return null;
            }
            String address = port.getAddress();
            if (address == null || address.length() == 0) {
                address = "INADDR_ANY";
            }
            return address;
        }

        private Port getFirstPort(String protocol, boolean isSSL) {
            if (this._server.getPorts() == null) {
                return null;
            }
            for (Port port : this._server.getPorts()) {
                if (!protocol.equals(port.getProtocolName()) || port.isSSL() != isSSL) continue;
                return port;
            }
            return null;
        }

        public String getAddress() {
            return this.getAddress(this._server.getClusterPort());
        }

        public int getPort() {
            return this.getPort(this._server.getClusterPort());
        }

        public String getHttpAddress() {
            return this.getAddress(this.getFirstPort("http", false));
        }

        public int getHttpPort() {
            return this.getPort(this.getFirstPort("http", false));
        }

        public String getHttpsAddress() {
            return this.getAddress(this.getFirstPort("http", true));
        }

        public int getHttpsPort() {
            return this.getPort(this.getFirstPort("http", true));
        }

        public Path getRoot() {
            Resin resin = Resin.getLocal();
            return resin == null ? Vfs.getPwd() : resin.getRootDirectory();
        }
    }

    public class Var {
        public String getId() {
            return Cluster.this._id;
        }

        public Path getRoot() {
            return Cluster.this.getRootDirectory();
        }

        public Path getRootDir() {
            return this.getRoot();
        }

        public Path getRootDirectory() {
            return this.getRoot();
        }
    }
}

