/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.cluster;

import com.caucho.management.server.AbstractManagedObject;
import com.caucho.management.server.ClusterMXBean;
import com.caucho.management.server.HostMXBean;
import com.caucho.management.server.PersistentStoreMXBean;
import com.caucho.management.server.PortMXBean;
import com.caucho.management.server.ResinMXBean;
import com.caucho.management.server.ServerConnectorMXBean;
import com.caucho.server.cluster.Cluster;
import com.caucho.server.cluster.ClusterServer;

public class ClusterAdmin
extends AbstractManagedObject
implements ClusterMXBean {
    private final Cluster _cluster;

    public ClusterAdmin(Cluster cluster) {
        this._cluster = cluster;
    }

    public String getName() {
        return this._cluster.getId();
    }

    public PortMXBean getPort() {
        ClusterServer clusterServer = this._cluster.getSelfServer();
        if (clusterServer == null) {
            return null;
        }
        return clusterServer.getClusterPort().getAdmin();
    }

    public ResinMXBean getResin() {
        return this._cluster.getResin().getAdmin();
    }

    public PersistentStoreMXBean getPersistentStore() {
        return null;
    }

    public HostMXBean[] getHosts() {
        return new HostMXBean[0];
    }

    public ServerConnectorMXBean[] getServers() {
        ClusterServer selfServer = this._cluster.getSelfServer();
        ClusterServer[] serverList = this._cluster.getServerList();
        int len = serverList.length;
        if (selfServer != null) {
            --len;
        }
        ServerConnectorMXBean[] serverMBeans = new ServerConnectorMXBean[len];
        int j = 0;
        for (int i = 0; i < serverList.length; ++i) {
            ClusterServer server = serverList[i];
            if (server == selfServer) continue;
            serverMBeans[j++] = server.getServerConnector().getAdmin();
        }
        return serverMBeans;
    }

    public String toString() {
        return "ClusterAdmin[" + this.getObjectName() + "]";
    }
}

