/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.cluster;

import com.caucho.loader.EnvironmentLocal;
import com.caucho.log.Log;
import com.caucho.server.cluster.Cluster;
import com.caucho.server.cluster.ServerConnector;
import com.caucho.util.L10N;
import java.util.ArrayList;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusterGroup {
    private static final L10N L = new L10N(ClusterGroup.class);
    private static final Logger log = Log.open(ClusterGroup.class);
    protected static final EnvironmentLocal<ClusterGroup> _clusterGroupLocal = new EnvironmentLocal();
    private final ArrayList<Cluster> _clusterList = new ArrayList();

    private ClusterGroup() {
    }

    public static ClusterGroup getClusterGroup() {
        return _clusterGroupLocal.get();
    }

    public static ClusterGroup createClusterGroup() {
        ClusterGroup group = _clusterGroupLocal.getLevel();
        if (group == null) {
            group = new ClusterGroup();
            _clusterGroupLocal.set(group);
        }
        return group;
    }

    public void addCluster(Cluster cluster) {
        if (!this._clusterList.contains(cluster)) {
            this._clusterList.add(cluster);
        }
    }

    public ArrayList<Cluster> getClusterList() {
        return this._clusterList;
    }

    public Cluster findCluster(String id) {
        for (int i = this._clusterList.size() - 1; i >= 0; --i) {
            Cluster cluster = this._clusterList.get(i);
            if (!cluster.getId().equals(id)) continue;
            return cluster;
        }
        return null;
    }

    public ServerConnector findClient(String host, int port) {
        for (int i = this._clusterList.size() - 1; i >= 0; --i) {
            Cluster cluster = this._clusterList.get(i);
            ServerConnector serverConnector = cluster.findConnector(host, port);
            if (serverConnector == null) continue;
            return serverConnector;
        }
        return null;
    }
}

