/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.cluster;

import com.caucho.log.Log;
import com.caucho.server.cluster.ObjectManager;
import com.caucho.server.cluster.Store;
import com.caucho.server.cluster.StoreManager;
import com.caucho.util.Alarm;
import com.caucho.vfs.Crc64Stream;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.TempStream;
import com.caucho.vfs.VfsStream;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ClusterObject {
    private static final Logger log = Log.open(ClusterObject.class);
    private final StoreManager _storeManager;
    private final String _storeId;
    private final String _objectId;
    private final String _uniqueId;
    private WeakReference<Store> _storeRef;
    private boolean _isPrimary;
    private long _maxIdleTime;
    private long _expireInterval = -1L;
    private long _accessTime;
    private long _crc = -1L;
    private boolean _isSerializable = true;
    private boolean _isValid = true;
    private boolean _isChanged = false;
    private boolean _isDead = false;

    ClusterObject(StoreManager storeManager, Store store, String objectId) {
        this._storeManager = storeManager;
        this._storeRef = new WeakReference<Store>(store);
        this._maxIdleTime = store.getMaxIdleTime();
        this._storeId = store.getId();
        this._objectId = objectId;
        this._uniqueId = this._storeId + ';' + objectId;
        this._isPrimary = this.isPrimary(this._objectId);
        this._expireInterval = this.getMaxIdleTime() + this.getAccessWindow();
    }

    ClusterObject(StoreManager storeManager, String storeId, String objectId) {
        this._storeManager = storeManager;
        this._maxIdleTime = this._storeManager.getMaxIdleTime();
        this._storeId = storeId;
        this._objectId = objectId;
        this._uniqueId = this._storeId + ';' + objectId;
        this._isPrimary = this.isPrimary(this._objectId);
        this._expireInterval = this.getMaxIdleTime() + this.getAccessWindow();
    }

    private boolean isPrimary(String id) {
        Store store = this.getStore();
        if (store != null && store.isAlwaysLoad()) {
            return false;
        }
        if (store == null && this._storeManager.isAlwaysLoad()) {
            return false;
        }
        return this._storeManager.isPrimary(id);
    }

    public Store getStore() {
        Store store;
        WeakReference<Store> storeRef = this._storeRef;
        if (storeRef != null && (store = (Store)storeRef.get()) != null) {
            return store;
        }
        store = this._storeManager.getStore(this._storeId);
        if (store != null) {
            this._storeRef = new WeakReference<Store>(store);
        }
        return store;
    }

    public ObjectManager getObjectManager() {
        Store store = this.getStore();
        if (store != null) {
            return store.getObjectManager();
        }
        return null;
    }

    public StoreManager getStoreManager() {
        return this._storeManager;
    }

    public String getStoreId() {
        return this._storeId;
    }

    public String getObjectId() {
        return this._objectId;
    }

    public String getUniqueId() {
        return this._uniqueId;
    }

    public long getMaxIdleTime() {
        return this._maxIdleTime;
    }

    public void setMaxIdleTime(long maxIdleTime) {
        this._maxIdleTime = maxIdleTime;
    }

    public long getAccessWindow() {
        long window = this._maxIdleTime / 4L;
        if (window < 60000L) {
            return 60000L;
        }
        return window;
    }

    public void setPrimary(boolean primary) {
        this._isPrimary = primary;
    }

    long getCRC() {
        return this._crc;
    }

    void setCRC(long crc) {
        this._crc = crc;
    }

    boolean isValid() {
        return this._isValid;
    }

    void setValid(boolean isValid) {
        this._isValid = isValid;
    }

    public void setValid() {
        this._isValid = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean load(Object obj) {
        block8: {
            if (!this._isSerializable) {
                return true;
            }
            if (this._isDead) {
                return false;
            }
            if (this._isPrimary && this._isValid) {
                return true;
            }
            if (!this._storeManager.load(this, obj)) break block8;
            this._isValid = true;
            boolean bl = true;
            Object var5_5 = null;
            this._isChanged = false;
            return bl;
        }
        try {
            this._crc = -1L;
            boolean bl = false;
            Object var5_6 = null;
            this._isChanged = false;
            return bl;
        }
        catch (Exception e) {
            try {
                log.log(Level.WARNING, e.toString(), e);
                this._crc = -1L;
                boolean bl = false;
                Object var5_7 = null;
                this._isChanged = false;
                return bl;
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                this._isChanged = false;
                throw throwable;
            }
        }
    }

    boolean load(InputStream is, Object obj) throws IOException {
        VfsStream streamImpl = new VfsStream(is, null);
        Crc64Stream crcStream = new Crc64Stream((StreamImpl)streamImpl);
        ReadStream crcIs = new ReadStream((StreamImpl)crcStream);
        this.getObjectManager().load((InputStream)crcIs, obj);
        this._isValid = true;
        this._crc = crcStream.getCRC();
        crcIs.close();
        return true;
    }

    public void update() {
        this._isValid = false;
    }

    public void change() {
        this._isChanged = true;
    }

    public void access() {
        long now = Alarm.getCurrentTime();
        if (this.getAccessWindow() <= now - this._accessTime) {
            try {
                this._storeManager.accessImpl(this.getObjectId(), this.getUniqueId());
            }
            catch (Exception e) {
                log.log(Level.WARNING, e.toString(), e);
            }
            this._accessTime = now;
        }
    }

    public void setAccessTime(long accessTime) {
        this._accessTime = accessTime;
    }

    public long getExpireInterval() {
        return this._expireInterval;
    }

    public void setExpireInterval(long expireInterval) {
        try {
            this._expireInterval = expireInterval;
            this._storeManager.setExpireInterval(this.getUniqueId(), expireInterval);
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void store(Object obj) throws IOException {
        TempStream tempStream;
        block12: {
            block11: {
                if (!this._isSerializable) {
                    return;
                }
                boolean isValid = this._isValid;
                if (!this._isPrimary) {
                    this._isValid = false;
                }
                if (!this._isChanged && !this.getStore().isAlwaysSave()) {
                    return;
                }
                this._isChanged = false;
                tempStream = new TempStream();
                try {
                    try {
                        Crc64Stream crcStream = new Crc64Stream((StreamImpl)tempStream);
                        WriteStream os = new WriteStream((StreamImpl)crcStream);
                        this.getObjectManager().store((OutputStream)os, obj);
                        os.close();
                        os = null;
                        long crc = crcStream.getCRC();
                        if (crc == this._crc) {
                            Object var9_9 = null;
                            break block11;
                        }
                        this._crc = crc;
                        this._storeManager.store(this, tempStream, crc);
                        if (this._isPrimary) {
                            this._isValid = true;
                        }
                        this._accessTime = Alarm.getCurrentTime();
                        break block12;
                    }
                    catch (NotSerializableException e) {
                        log.warning(e.toString());
                        this._isSerializable = false;
                        Object var9_11 = null;
                        tempStream.destroy();
                        return;
                    }
                    catch (Exception e) {
                        log.log(Level.WARNING, e.toString(), e);
                        this._isValid = false;
                        Object var9_12 = null;
                        tempStream.destroy();
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var9_13 = null;
                    tempStream.destroy();
                    throw throwable;
                }
            }
            tempStream.destroy();
            return;
        }
        Object var9_10 = null;
        tempStream.destroy();
    }

    public void write(InputStream is) throws IOException {
    }

    public ReadStream openRead() throws IOException {
        return null;
    }

    public void remove() {
        try {
            if (this._isDead) {
                return;
            }
            this._isDead = true;
            this._storeManager.remove(this);
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    public void removeImpl() {
    }

    static class DistributedObjectInputStream
    extends ObjectInputStream {
        DistributedObjectInputStream(InputStream is) throws IOException {
            super(is);
        }

        protected Class resolveClass(ObjectStreamClass v) throws IOException, ClassNotFoundException {
            String name = v.getName();
            Thread thread = Thread.currentThread();
            ClassLoader loader = thread.getContextClassLoader();
            return Class.forName(name, false, loader);
        }
    }
}

