/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.cluster;

import com.caucho.server.cluster.ClusterServer;
import com.caucho.server.hmux.HmuxProtocol;
import com.caucho.server.port.Port;
import com.caucho.util.L10N;
import javax.annotation.PostConstruct;

public class ClusterPort
extends Port {
    private static final L10N L = new L10N(ClusterPort.class);
    private ClusterServer _server;
    private int _clientWeight = 100;

    public ClusterPort(ClusterServer server) {
        this._server = server;
        try {
            this.setAddress("127.0.0.1");
            this.setPort(6800);
            this.setProtocol(new HmuxProtocol());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public ClusterServer getClusterServer() {
        return this._server;
    }

    public int getIndex() {
        return this._server.getIndex();
    }

    public void setClientWeight(int weight) {
        this._clientWeight = weight;
    }

    public int getClientWeight() {
        return this._clientWeight;
    }

    @PostConstruct
    public void init() {
    }

    public String toString() {
        if (this.getAddress() != null) {
            return "ClusterPort[address=" + this.getAddress() + ",port=" + this.getPort() + "]";
        }
        return "ClusterPort[address=*,port=" + this.getPort() + "]";
    }
}

