/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.cluster;

import com.caucho.config.ConfigException;
import com.caucho.config.program.ConfigProgram;
import com.caucho.config.program.ContainerProgram;
import com.caucho.config.types.Period;
import com.caucho.lifecycle.StartLifecycleException;
import com.caucho.log.Log;
import com.caucho.server.cluster.Cluster;
import com.caucho.server.cluster.ClusterPort;
import com.caucho.server.cluster.Machine;
import com.caucho.server.cluster.Server;
import com.caucho.server.cluster.ServerConnector;
import com.caucho.server.http.HttpProtocol;
import com.caucho.server.port.Port;
import com.caucho.server.port.ProtocolPort;
import com.caucho.util.L10N;
import com.caucho.vfs.QServerSocket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusterServer {
    private static final Logger log = Log.open(ClusterServer.class);
    private static final L10N L = new L10N(ClusterServer.class);
    private static final long DEFAULT = -889275714L;
    private Cluster _cluster;
    private Machine _machine;
    private String _id = "";
    private int _index;
    private ClusterPort _clusterPort;
    private ServerConnector _serverConnector;
    private long _socketTimeout = 65000L;
    private long _keepaliveTimeout = 15000L;
    private long _loadBalanceIdleTime = -889275714L;
    private long _loadBalanceRecoverTime = 15000L;
    private long _loadBalanceSocketTimeout = -889275714L;
    private long _loadBalanceWarmupTime = 60000L;
    private long _loadBalanceConnectTimeout = 5000L;
    private int _loadBalanceWeight = 100;
    private ContainerProgram _serverProgram = new ContainerProgram();
    private ArrayList<Port> _ports = new ArrayList();

    public ClusterServer(Cluster cluster) {
        this(new Machine(cluster));
    }

    public ClusterServer(Machine machine) {
        this._machine = machine;
        this._cluster = machine.getCluster();
        this._clusterPort = new ClusterPort(this);
        this._ports.add(this._clusterPort);
        this._serverConnector = new ServerConnector(this);
    }

    public ClusterServer(Cluster cluster, boolean test) {
        this._cluster = cluster;
        this._clusterPort = new ClusterPort(this);
        this._serverConnector = new ServerConnector(this);
    }

    public String getId() {
        return this._id;
    }

    public void setId(String id) {
        this._id = id;
    }

    public Cluster getCluster() {
        return this._cluster;
    }

    public Machine getMachine() {
        return this._machine;
    }

    void setIndex(int index) {
        this._index = index;
    }

    public int getIndex() {
        return this._index;
    }

    public void setKeepaliveTimeout(Period timeout) {
        this._keepaliveTimeout = timeout.getPeriod();
    }

    public long getKeepaliveTimeout() {
        return this._keepaliveTimeout;
    }

    public void setAddress(String address) throws UnknownHostException {
        this._clusterPort.setAddress(address);
    }

    public void setBackup(boolean isBackup) {
        if (isBackup) {
            this.setLoadBalanceWeight(1);
        }
    }

    public void setLoadBalanceConnectTimeout(Period period) {
        this._loadBalanceConnectTimeout = period.getPeriod();
    }

    public long getLoadBalanceConnectTimeout() {
        return this._loadBalanceConnectTimeout;
    }

    public void setLoadBalanceSocketTimeout(Period period) {
        this._loadBalanceSocketTimeout = period.getPeriod();
    }

    public long getLoadBalanceSocketTimeout() {
        if (this._loadBalanceSocketTimeout != -889275714L) {
            return this._loadBalanceSocketTimeout;
        }
        return this._socketTimeout + 600000L;
    }

    public void setLoadBalanceIdleTime(Period period) {
        this._loadBalanceIdleTime = period.getPeriod();
    }

    public long getLoadBalanceIdleTime() {
        if (this._loadBalanceIdleTime != -889275714L) {
            return this._loadBalanceIdleTime;
        }
        if (this._keepaliveTimeout < 10000L) {
            return this._keepaliveTimeout - 2000L;
        }
        return this._keepaliveTimeout - 5000L;
    }

    public void setLoadBalanceRecoverTime(Period period) {
        this._loadBalanceRecoverTime = period.getPeriod();
    }

    public long getLoadBalanceRecoverTime() {
        return this._loadBalanceRecoverTime;
    }

    public void setSocketTimeout(Period period) {
        this._socketTimeout = period.getPeriod();
    }

    public long getSocketTimeout() {
        return this._socketTimeout;
    }

    public void setLoadBalanceWarmupTime(Period period) {
        this._loadBalanceWarmupTime = period.getPeriod();
    }

    public long getLoadBalanceWarmupTime() {
        return this._loadBalanceWarmupTime;
    }

    public void setLoadBalanceWeight(int weight) {
        this._loadBalanceWeight = weight;
    }

    public int getLoadBalanceWeight() {
        return this._loadBalanceWeight;
    }

    public void addJavaExe(String args) {
    }

    public void addJvmArg(String args) {
    }

    public void addJvmClasspath(String args) {
    }

    public void addWatchdogArg(String args) {
    }

    public void addWatchdogJvmArg(String args) {
    }

    public void addWatchdogPassword(String args) {
    }

    public void addWatchdogPort(int port) {
    }

    public void addWatchdogAddress(String addr) {
    }

    public void setPort(int port) {
        this._clusterPort.setPort(port);
    }

    public int getPort() {
        return this._clusterPort.getPort();
    }

    public Port createHttp() throws ConfigException {
        Port port = new Port(this);
        HttpProtocol protocol = new HttpProtocol();
        protocol.setParent(port);
        port.setProtocol(protocol);
        this.addProtocolPort(port);
        return port;
    }

    public Port createProtocol() throws ConfigException {
        ProtocolPort port = new ProtocolPort(this);
        this._ports.add(port);
        return port;
    }

    void addProtocolPort(Port port) {
        this._ports.add(port);
    }

    public void bind(String address, int port, QServerSocket ss) throws Exception {
        if ("null".equals(address)) {
            address = null;
        }
        for (int i = 0; i < this._ports.size(); ++i) {
            Port serverPort = this._ports.get(i);
            if (port != serverPort.getPort() || address == null != (serverPort.getAddress() == null) || address != null && !address.equals(serverPort.getAddress())) continue;
            serverPort.bind(ss);
            return;
        }
        throw new IllegalStateException(L.l("No matching port for {0}:{1}", (Object)address, port));
    }

    public void setUserName(String userName) {
    }

    public void setGroupName(String groupName) {
    }

    public ArrayList<Port> getPorts() {
        return this._ports;
    }

    public ClusterPort createClusterPort() {
        return this._clusterPort;
    }

    public ClusterPort getClusterPort() {
        return this._clusterPort;
    }

    public boolean isSSL() {
        return this.getClusterPort().isSSL();
    }

    public ServerConnector getServerConnector() {
        if (this._cluster.getSelfServer() != this) {
            return this._serverConnector;
        }
        return null;
    }

    public void addBuilderProgram(ConfigProgram program) {
        this._serverProgram.addProgram(program);
    }

    public ConfigProgram getServerProgram() {
        return this._serverProgram;
    }

    public void init() throws Exception {
        this._clusterPort.init();
        if (this._cluster != null) {
            this._serverConnector.init();
            this._serverConnector.register();
        }
    }

    public Server startServer() throws StartLifecycleException {
        return this._cluster.startServer(this);
    }

    public long generateBackupCode() {
        return this._cluster.generateBackupCode(this._index);
    }

    public void generateBackupCode(StringBuilder cb) {
        this._cluster.generateBackupCode(cb, this.generateBackupCode());
    }

    public void close() {
        if (this._serverConnector != null) {
            this._serverConnector.close();
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[id=" + this.getId() + "]";
    }
}

