/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.cluster;

import com.caucho.log.Log;
import com.caucho.server.cluster.ServerConnector;
import com.caucho.util.Alarm;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.WriteStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ClusterStream {
    protected static final Logger log = Log.open(ClusterStream.class);
    private ServerConnector _srun;
    private ReadStream _is;
    private WriteStream _os;
    private long _freeTime;
    private String _debugId;

    ClusterStream(int count, ServerConnector client, ReadStream is, WriteStream os) {
        this._srun = client;
        this._is = is;
        this._os = os;
        this._debugId = "[" + client.getDebugId() + ":" + count + "]";
    }

    public ServerConnector getServer() {
        return this._srun;
    }

    public ReadStream getReadStream() {
        this._freeTime = 0L;
        return this._is;
    }

    public WriteStream getWriteStream() {
        this._freeTime = 0L;
        return this._os;
    }

    public long getFreeTime() {
        return this._freeTime;
    }

    public void setFreeTime(long freeTime) {
        this._freeTime = freeTime;
    }

    public boolean isLongIdle() {
        return this._srun.getLoadBalanceIdleTime() < Alarm.getCurrentTime() - this._freeTime + 2000L;
    }

    public String getDebugId() {
        return this._debugId;
    }

    public void clearRecycle() {
        this._srun.clearRecycle();
    }

    public void free() {
        if (this._is != null && this._freeTime <= 0L) {
            this._freeTime = this._is.getReadTime();
        }
        this._srun.free(this);
    }

    public void close() {
        if (this._is != null) {
            this._srun.close(this);
        }
        this.closeImpl();
    }

    void closeImpl() {
        ReadStream is = this._is;
        this._is = null;
        WriteStream os = this._os;
        this._os = null;
        try {
            if (is != null) {
                is.close();
            }
        }
        catch (Throwable e) {
            log.log(Level.FINER, e.toString(), e);
        }
        try {
            if (os != null) {
                os.close();
            }
        }
        catch (Throwable e) {
            log.log(Level.FINER, e.toString(), e);
        }
    }

    public String toString() {
        return "ClusterStream[" + this._debugId + "]";
    }
}

