/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.cluster;

import com.caucho.config.ConfigException;
import com.caucho.db.jdbc.DataSourceImpl;
import com.caucho.server.cluster.ClusterObject;
import com.caucho.util.Alarm;
import com.caucho.util.FreeList;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.DataSource;

public class FileBacking {
    private static final L10N L = new L10N(FileBacking.class);
    private static final Logger log = Logger.getLogger(FileBacking.class.getName());
    private FreeList<ClusterConnection> _freeConn = new FreeList(32);
    private String _name;
    private Path _path;
    private DataSource _dataSource;
    private String _tableName;
    private String _loadQuery;
    private String _updateQuery;
    private String _accessQuery;
    private String _setExpiresQuery;
    private String _insertQuery;
    private String _invalidateQuery;
    private String _timeoutQuery;
    private String _dumpQuery;
    private String _countQuery;

    public FileBacking() {
    }

    public FileBacking(String name) {
        this._name = name;
    }

    public Path getPath() {
        return this._path;
    }

    public void setPath(Path path) {
        this._path = path;
    }

    public void setTableName(String table) {
        this._tableName = table;
    }

    public boolean init(int clusterLength) throws Exception {
        if (this._path == null) {
            throw new ConfigException(L.l("file-backing needs path."));
        }
        if (this._tableName == null) {
            throw new ConfigException(L.l("file-backing needs tableName."));
        }
        int length = clusterLength;
        if (length <= 0) {
            length = 1;
        }
        this._loadQuery = "SELECT access_time,data FROM " + this._tableName + " WHERE id=? AND is_valid=1";
        this._insertQuery = "INSERT into " + this._tableName + " (id,is_valid,data,mod_time,access_time,expire_interval,server1,server2,server3) " + "VALUES(?,1,?,?,?,?,?,?,?)";
        this._updateQuery = "UPDATE " + this._tableName + " SET data=?, mod_time=?, access_time=?,is_valid=1 WHERE id=?";
        this._accessQuery = "UPDATE " + this._tableName + " SET access_time=? WHERE id=?";
        this._setExpiresQuery = "UPDATE " + this._tableName + " SET expire_interval=? WHERE id=?";
        this._invalidateQuery = "UPDATE " + this._tableName + " SET is_valid=0 WHERE id=?";
        this._timeoutQuery = "DELETE FROM " + this._tableName + " WHERE access_time + 5 * expire_interval / 4 < ?";
        this._dumpQuery = "SELECT id, is_valid, expire_interval, data FROM " + this._tableName + " WHERE ? <= mod_time AND " + "   (?=server1 OR ?=server2 OR ?=server3)";
        this._countQuery = "SELECT count(*) FROM " + this._tableName;
        try {
            this._path.mkdirs();
        }
        catch (IOException e) {
            // empty catch block
        }
        DataSourceImpl dataSource = new DataSourceImpl();
        dataSource.setPath(this._path);
        dataSource.setRemoveOnError(true);
        dataSource.init();
        this._dataSource = dataSource;
        this.initDatabase();
        return true;
    }

    public DataSource getDataSource() {
        return this._dataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initDatabase() throws Exception {
        Connection conn = this._dataSource.getConnection();
        try {
            Statement stmt = conn.createStatement();
            boolean hasDatabase = false;
            try {
                String sql = "SELECT expire_interval,is_valid FROM " + this._tableName + " WHERE 1=0";
                ResultSet rs = stmt.executeQuery(sql);
                rs.next();
                rs.close();
            }
            catch (Exception e) {
                log.log(Level.FINEST, e.toString(), e);
                log.finer(this + " " + e.toString());
                try {
                    stmt.executeQuery("DROP TABLE " + this._tableName);
                }
                catch (Exception e2) {
                    log.log(Level.FINEST, e2.toString(), e2);
                }
                String sql = "CREATE TABLE " + this._tableName + " (\n" + "  id VARBINARY(64) PRIMARY KEY,\n" + "  is_valid BIT,\n" + "  data BLOB,\n" + "  expire_interval INTEGER,\n" + "  access_time INTEGER,\n" + "  mod_time INTEGER,\n" + "  mod_count BIGINT,\n" + "  server1 INTEGER,\n" + "  server2 INTEGER,\n" + "  server3 INTEGER)";
                log.fine(sql);
                stmt.executeUpdate(sql);
                Object var7_10 = null;
                conn.close();
                return;
            }
            Object var7_9 = null;
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            conn.close();
            throw throwable;
        }
        conn.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long start() throws Exception {
        long delta = -Alarm.getCurrentTime();
        Connection conn = null;
        try {
            conn = this._dataSource.getConnection();
            Statement stmt = conn.createStatement();
            String sql = "SELECT MAX(access_time) FROM " + this._tableName;
            ResultSet rs = stmt.executeQuery(sql);
            if (rs.next()) {
                delta = (long)rs.getInt(1) * 60000L - Alarm.getCurrentTime();
            }
            Object var8_6 = null;
            if (conn == null) return delta;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            if (conn == null) throw throwable;
            conn.close();
            throw throwable;
        }
        conn.close();
        return delta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void clearOldObjects(long maxIdleTime) throws SQLException {
        Connection conn = null;
        try {
            if (maxIdleTime > 0L) {
                conn = this._dataSource.getConnection();
                PreparedStatement pstmt = conn.prepareStatement(this._timeoutQuery);
                long now = Alarm.getCurrentTime();
                int nowMinute = (int)(now / 60000L);
                pstmt.setInt(1, nowMinute);
                int count = pstmt.executeUpdate();
                if (count > 0) {
                    log.fine(this + " purged " + count + " old sessions");
                }
                pstmt.close();
            }
            Object var10_7 = null;
            if (conn == null) return;
        }
        catch (Throwable throwable) {
            Object var10_8 = null;
            if (conn == null) throw throwable;
            conn.close();
            throw throwable;
        }
        conn.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadSelf(ClusterObject clusterObj, Object obj) throws Exception {
        String uniqueId = clusterObj.getUniqueId();
        ClusterConnection conn = this.getConnection();
        try {
            PreparedStatement stmt = conn.prepareLoad();
            stmt.setString(1, uniqueId);
            ResultSet rs = stmt.executeQuery();
            boolean validLoad = false;
            if (rs.next()) {
                long accessTime = (long)rs.getInt(1) * 60000L;
                InputStream is = rs.getBinaryStream(2);
                if (log.isLoggable(Level.FINE)) {
                    log.fine(this + " load " + uniqueId);
                }
                if (validLoad = clusterObj.load(is, obj)) {
                    clusterObj.setAccessTime(accessTime);
                }
                is.close();
            } else if (log.isLoggable(Level.FINE)) {
                log.fine(this + " load: no local object loaded for " + uniqueId);
            }
            rs.close();
            boolean bl = validLoad;
            Object var12_11 = null;
            conn.close();
            return bl;
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            conn.close();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAccess(String uniqueId) throws Exception {
        ClusterConnection conn = this.getConnection();
        try {
            PreparedStatement stmt = conn.prepareAccess();
            long now = Alarm.getCurrentTime();
            int nowMinutes = (int)(now / 60000L);
            stmt.setInt(1, nowMinutes);
            stmt.setString(2, uniqueId);
            int count = stmt.executeUpdate();
            if (count > 0) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine(this + " access " + uniqueId);
                }
                Object var9_7 = null;
                conn.close();
                return;
            }
            Object var9_8 = null;
            conn.close();
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            conn.close();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExpireInterval(String uniqueId, long expireInterval) throws Exception {
        ClusterConnection conn = this.getConnection();
        try {
            PreparedStatement stmt = conn.prepareSetExpireInterval();
            int expireMinutes = (int)(expireInterval / 60000L);
            stmt.setInt(1, expireMinutes);
            stmt.setString(2, uniqueId);
            int count = stmt.executeUpdate();
            if (count > 0) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine(this + " set expire interval: " + uniqueId + " " + expireInterval);
                }
                Object var9_7 = null;
                conn.close();
                return;
            }
            Object var9_8 = null;
            conn.close();
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            conn.close();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String uniqueId) throws Exception {
        ClusterConnection conn = this.getConnection();
        try {
            PreparedStatement pstmt = conn.prepareInvalidate();
            pstmt.setString(1, uniqueId);
            int count = pstmt.executeUpdate();
            if (log.isLoggable(Level.FINE)) {
                log.fine(this + " remove " + uniqueId);
            }
            Object var6_5 = null;
            conn.close();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            conn.close();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public long read(String uniqueId, WriteStream os) throws IOException {
        block14: {
            Connection conn;
            block13: {
                conn = null;
                conn = this._dataSource.getConnection();
                PreparedStatement pstmt = conn.prepareStatement(this._loadQuery);
                pstmt.setString(1, uniqueId);
                ResultSet rs = pstmt.executeQuery();
                if (!rs.next()) break block13;
                long accessTime = (long)rs.getInt(1) * 60000L;
                InputStream is = rs.getBinaryStream(2);
                os.writeStream(is);
                is.close();
                long l = accessTime;
                Object var12_10 = null;
                try {
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (SQLException e2) {
                    // empty catch block
                }
                return l;
            }
            Object var12_11 = null;
            try {
                if (conn != null) {
                    conn.close();
                }
                break block14;
            }
            catch (SQLException e2) {}
            break block14;
            {
                catch (SQLException e) {
                    log.log(Level.FINE, e.toString(), e);
                    Object var12_12 = null;
                    try {
                        if (conn != null) {
                            conn.close();
                        }
                        break block14;
                    }
                    catch (SQLException e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var12_13 = null;
                try {
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (SQLException e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeSelf(String uniqueId, ReadStream is, int length, long expireInterval, int primary, int secondary, int tertiary) {
        ClusterConnection conn = null;
        try {
            try {
                conn = this.getConnection();
                if (this.storeSelfUpdate(conn, uniqueId, is, length) || this.storeSelfInsert(conn, uniqueId, is, length, expireInterval, primary, secondary, tertiary)) {
                    // empty if block
                }
            }
            catch (SQLException e) {
                log.log(Level.FINE, e.toString(), e);
                Object var12_10 = null;
                if (conn != null) {
                    conn.close();
                }
            }
            Object var12_9 = null;
            if (conn != null) {
                conn.close();
            }
        }
        catch (Throwable throwable) {
            Object var12_11 = null;
            if (conn != null) {
                conn.close();
            }
            throw throwable;
        }
    }

    private boolean storeSelfUpdate(ClusterConnection conn, String uniqueId, ReadStream is, int length) {
        try {
            PreparedStatement stmt = conn.prepareUpdate();
            stmt.setBinaryStream(1, (InputStream)is, length);
            long now = Alarm.getCurrentTime();
            int nowMinutes = (int)(now / 60000L);
            stmt.setInt(2, nowMinutes);
            stmt.setInt(3, nowMinutes);
            stmt.setString(4, uniqueId);
            int count = stmt.executeUpdate();
            if (count > 0) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine(this + " update " + uniqueId + " length:" + length);
                }
                return true;
            }
        }
        catch (SQLException e) {
            log.log(Level.WARNING, e.toString(), e);
        }
        return false;
    }

    private boolean storeSelfInsert(ClusterConnection conn, String uniqueId, ReadStream is, int length, long expireInterval, int primary, int secondary, int tertiary) {
        try {
            PreparedStatement stmt = conn.prepareInsert();
            stmt.setString(1, uniqueId);
            stmt.setBinaryStream(2, (InputStream)is, length);
            int nowMinutes = (int)(Alarm.getCurrentTime() / 60000L);
            stmt.setInt(3, nowMinutes);
            stmt.setInt(4, nowMinutes);
            stmt.setInt(5, (int)(expireInterval / 60000L));
            stmt.setInt(6, primary);
            stmt.setInt(7, secondary);
            stmt.setInt(8, tertiary);
            stmt.executeUpdate();
            if (log.isLoggable(Level.FINE)) {
                log.fine(this + " insert " + uniqueId + " length:" + length);
            }
            return true;
        }
        catch (SQLException e) {
            System.out.println(e);
            log.log(Level.FINE, e.toString(), e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getObjectCount() throws SQLException {
        ClusterConnection conn;
        block5: {
            conn = this.getConnection();
            PreparedStatement stmt = conn.prepareCount();
            ResultSet rs = stmt.executeQuery();
            if (rs == null || !rs.next()) break block5;
            long value = rs.getLong(1);
            rs.close();
            long l = value;
            Object var9_8 = null;
            conn.close();
            return l;
        }
        try {
            long l = -1L;
            Object var9_9 = null;
            conn.close();
            return l;
        }
        catch (SQLException e) {
            try {
                log.log(Level.FINE, e.toString(), e);
                Object var9_10 = null;
                conn.close();
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                conn.close();
                throw throwable;
            }
        }
        return -1L;
    }

    public void destroy() {
        this._dataSource = null;
        this._freeConn = null;
    }

    private ClusterConnection getConnection() throws SQLException {
        ClusterConnection cConn = (ClusterConnection)this._freeConn.allocate();
        if (cConn == null) {
            Connection conn = this._dataSource.getConnection();
            cConn = new ClusterConnection(conn);
        }
        return cConn;
    }

    public String serverNameToTableName(String serverName) {
        if (serverName == null) {
            return "srun";
        }
        StringBuilder cb = new StringBuilder();
        cb.append("srun_");
        for (int i = 0; i < serverName.length(); ++i) {
            char ch = serverName.charAt(i);
            if ('a' <= ch && ch <= 'z') {
                cb.append(ch);
                continue;
            }
            if ('A' <= ch && ch <= 'Z') {
                cb.append(ch);
                continue;
            }
            if ('0' <= ch && ch <= '9') {
                cb.append(ch);
                continue;
            }
            if (ch == '_') {
                cb.append(ch);
                continue;
            }
            cb.append('_');
        }
        return cb.toString();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._tableName + "]";
    }

    class ClusterConnection {
        private Connection _conn;
        private PreparedStatement _loadStatement;
        private PreparedStatement _updateStatement;
        private PreparedStatement _insertStatement;
        private PreparedStatement _accessStatement;
        private PreparedStatement _setExpiresStatement;
        private PreparedStatement _invalidateStatement;
        private PreparedStatement _timeoutStatement;
        private PreparedStatement _countStatement;

        ClusterConnection(Connection conn) {
            this._conn = conn;
        }

        PreparedStatement prepareLoad() throws SQLException {
            if (this._loadStatement == null) {
                this._loadStatement = this._conn.prepareStatement(FileBacking.this._loadQuery);
            }
            return this._loadStatement;
        }

        PreparedStatement prepareUpdate() throws SQLException {
            if (this._updateStatement == null) {
                this._updateStatement = this._conn.prepareStatement(FileBacking.this._updateQuery);
            }
            return this._updateStatement;
        }

        PreparedStatement prepareInsert() throws SQLException {
            if (this._insertStatement == null) {
                this._insertStatement = this._conn.prepareStatement(FileBacking.this._insertQuery);
            }
            return this._insertStatement;
        }

        PreparedStatement prepareAccess() throws SQLException {
            if (this._accessStatement == null) {
                this._accessStatement = this._conn.prepareStatement(FileBacking.this._accessQuery);
            }
            return this._accessStatement;
        }

        PreparedStatement prepareSetExpireInterval() throws SQLException {
            if (this._setExpiresStatement == null) {
                this._setExpiresStatement = this._conn.prepareStatement(FileBacking.this._setExpiresQuery);
            }
            return this._setExpiresStatement;
        }

        PreparedStatement prepareInvalidate() throws SQLException {
            if (this._invalidateStatement == null) {
                this._invalidateStatement = this._conn.prepareStatement(FileBacking.this._invalidateQuery);
            }
            return this._invalidateStatement;
        }

        PreparedStatement prepareCount() throws SQLException {
            if (this._countStatement == null) {
                this._countStatement = this._conn.prepareStatement(FileBacking.this._countQuery);
            }
            return this._countStatement;
        }

        void close() {
            if (FileBacking.this._freeConn != null) {
                FileBacking.this._freeConn.free((Object)this);
            }
        }
    }
}

