/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.cluster;

import com.caucho.server.cluster.Cluster;
import com.caucho.server.cluster.ClusterObject;
import com.caucho.server.cluster.FileBacking;
import com.caucho.server.cluster.Store;
import com.caucho.server.cluster.StoreManager;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.TempStream;
import com.caucho.vfs.Vfs;
import java.util.logging.Level;
import javax.annotation.PostConstruct;

public class FileStore
extends StoreManager {
    private final FileBacking _backing = new FileBacking();

    public void setPath(Path path) {
        this._backing.setPath(path);
    }

    public void addText(String value) {
        this._backing.setPath(Vfs.lookup(value.trim()));
    }

    public Path getPath() {
        return this._backing.getPath();
    }

    @PostConstruct
    public boolean init() throws Exception {
        if (!super.init()) {
            return false;
        }
        String serverId = Cluster.getServerId();
        String tableName = this._backing.serverNameToTableName(serverId);
        this._backing.setTableName(tableName);
        this._backing.init(1);
        return true;
    }

    public boolean start() throws Exception {
        if (!super.start()) {
            return false;
        }
        this._backing.start();
        return true;
    }

    public void clearOldObjects() {
        try {
            this._backing.clearOldObjects(this.getMaxIdleTime());
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    protected boolean isPrimary(String id) {
        return true;
    }

    ClusterObject create(Store store, String id) {
        return new ClusterObject((StoreManager)this, store, id);
    }

    public boolean load(ClusterObject clusterObj, Object obj) throws Exception {
        return this._backing.loadSelf(clusterObj, obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(ClusterObject obj, TempStream tempStream, long crc) throws Exception {
        if (crc == 0L) {
            return;
        }
        int length = tempStream.getLength();
        ReadStream is = tempStream.openReadAndSaveBuffer();
        try {
            this._backing.storeSelf(obj.getUniqueId(), is, length, obj.getExpireInterval(), 0, 0, 0);
            if (log.isLoggable(Level.FINE)) {
                log.fine("file store: " + obj.getUniqueId() + " length=" + length);
            }
            Object var8_6 = null;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            is.close();
            throw throwable;
        }
        is.close();
    }

    public void accessImpl(String objectId, String uniqueId) throws Exception {
        this._backing.updateAccess(uniqueId);
    }

    public void setExpireInterval(String uniqueId, long expires) throws Exception {
        this._backing.setExpireInterval(uniqueId, expires);
    }

    public void remove(ClusterObject obj) throws Exception {
        this.removeClusterObject(obj.getStoreId(), obj.getObjectId());
        this._backing.remove(obj.getUniqueId());
    }
}

