/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.cluster;

import com.caucho.Version;
import com.caucho.config.ConfigException;
import com.caucho.config.SchemaBean;
import com.caucho.config.types.Bytes;
import com.caucho.config.types.Period;
import com.caucho.lifecycle.Lifecycle;
import com.caucho.loader.ClassLoaderListener;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.loader.Environment;
import com.caucho.loader.EnvironmentBean;
import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.loader.EnvironmentLocal;
import com.caucho.make.AlwaysModified;
import com.caucho.management.server.CacheItem;
import com.caucho.management.server.ServerMXBean;
import com.caucho.security.PermissionManager;
import com.caucho.server.admin.Management;
import com.caucho.server.cache.AbstractCache;
import com.caucho.server.cluster.Cluster;
import com.caucho.server.cluster.ClusterServer;
import com.caucho.server.cluster.ServerAdmin;
import com.caucho.server.dispatch.ErrorFilterChain;
import com.caucho.server.dispatch.ExceptionFilterChain;
import com.caucho.server.dispatch.Invocation;
import com.caucho.server.dispatch.InvocationMatcher;
import com.caucho.server.e_app.EarConfig;
import com.caucho.server.host.Host;
import com.caucho.server.host.HostConfig;
import com.caucho.server.host.HostContainer;
import com.caucho.server.host.HostController;
import com.caucho.server.host.HostExpandDeployGenerator;
import com.caucho.server.log.AccessLog;
import com.caucho.server.port.AbstractSelectManager;
import com.caucho.server.port.Port;
import com.caucho.server.port.ProtocolDispatchServer;
import com.caucho.server.resin.Resin;
import com.caucho.server.rewrite.RewriteDispatch;
import com.caucho.server.webapp.ErrorPage;
import com.caucho.server.webapp.WebApp;
import com.caucho.server.webapp.WebAppConfig;
import com.caucho.util.Alarm;
import com.caucho.util.AlarmListener;
import com.caucho.util.L10N;
import com.caucho.util.ThreadPool;
import com.caucho.vfs.Dependency;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import javax.resource.spi.ResourceAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Server
extends ProtocolDispatchServer
implements EnvironmentBean,
SchemaBean,
AlarmListener,
ClassLoaderListener {
    private static final L10N L = new L10N(Server.class);
    private static final Logger log = Logger.getLogger(Server.class.getName());
    private static final long ALARM_INTERVAL = 60000L;
    private static final EnvironmentLocal<String> _serverIdLocal = new EnvironmentLocal("caucho.server-id");
    private final ClusterServer _clusterServer;
    private final Resin _resin;
    private EnvironmentClassLoader _classLoader;
    private Throwable _configException;
    private HostContainer _hostContainer;
    private String _serverHeader = "Resin/" + Version.VERSION;
    private String _url = "";
    private int _urlLengthMax = 8192;
    private int _srunCount;
    private AccessLog _accessLog;
    private long _waitForActiveTime = 10000L;
    private int _acceptListenBacklog = 100;
    private int _acceptThreadMin = 5;
    private int _acceptThreadMax = 10;
    private int _connectionMax = 0x100000;
    private int _keepaliveMax = -1;
    private long _keepaliveConnectionTimeMax = 600000L;
    private boolean _keepaliveSelectEnable = true;
    private int _keepaliveSelectMax = -1;
    private long _keepaliveSelectThreadTimeout = 1000L;
    private Management _management;
    private long _suspendTimeMax = 600000L;
    private long _memoryFreeMin = 0x100000L;
    private long _shutdownWaitMax = 60000L;
    private int _threadMax = 4096;
    private int _threadExecutorTaskMax = -1;
    private int _threadIdleMin = 5;
    private int _threadIdleMax = 10;
    private String _connectionErrorPage;
    private ServerAdmin _admin;
    private Alarm _alarm;
    private AbstractCache _cache;
    private boolean _isBindPortsAtEnd = true;
    private volatile boolean _isStartedPorts;
    private long _startTime;
    private final Lifecycle _lifecycle;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Server(ClusterServer clusterServer) {
        if (clusterServer == null) {
            throw new NullPointerException();
        }
        this._clusterServer = clusterServer;
        this._resin = this._clusterServer.getCluster().getResin();
        try {
            try {
                Thread thread = Thread.currentThread();
                ClassLoader loader = clusterServer.getCluster().getClassLoader();
                this._classLoader = (EnvironmentClassLoader)loader;
                Environment.addClassLoaderListener(this, this._classLoader);
                PermissionManager permissionManager = new PermissionManager();
                PermissionManager.setPermissionManager(permissionManager);
                ClassLoader oldLoader = thread.getContextClassLoader();
                try {
                    thread.setContextClassLoader(this._classLoader);
                    _serverIdLocal.set(this._clusterServer.getId());
                    this._hostContainer = new HostContainer();
                    this._hostContainer.setClassLoader(this._classLoader);
                    this._hostContainer.setDispatchServer(this);
                    this._admin = new ServerAdmin(this);
                    this._alarm = new Alarm((AlarmListener)this);
                    this._clusterServer.getServerProgram().configure(this);
                    Object var7_7 = null;
                    thread.setContextClassLoader(oldLoader);
                }
                catch (Throwable throwable) {
                    Object var7_8 = null;
                    thread.setContextClassLoader(oldLoader);
                    throw throwable;
                }
                Object var9_10 = null;
                this._lifecycle = new Lifecycle(log, this.toString(), Level.INFO);
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString(), e);
                this._configException = e;
                Object var9_11 = null;
                this._lifecycle = new Lifecycle(log, this.toString(), Level.INFO);
            }
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            this._lifecycle = new Lifecycle(log, this.toString(), Level.INFO);
            throw throwable;
        }
    }

    @Override
    public ClassLoader getClassLoader() {
        return this._classLoader;
    }

    public Throwable getConfigException() {
        return this._configException;
    }

    public void setConfigException(Throwable exn) {
        this._configException = exn;
    }

    public void setAcceptListenBacklog(int backlog) {
        this._acceptListenBacklog = backlog;
    }

    public int getAcceptListenBacklog() {
        return this._acceptListenBacklog;
    }

    public void setAcceptThreadMin(int minSpare) throws ConfigException {
        if (minSpare < 1) {
            throw new ConfigException(L.l("accept-thread-max must be at least 1."));
        }
        this._acceptThreadMin = minSpare;
    }

    public int getAcceptThreadMin() {
        return this._acceptThreadMin;
    }

    public void setAcceptThreadMax(int maxSpare) throws ConfigException {
        if (maxSpare < 1) {
            throw new ConfigException(L.l("accept-thread-max must be at least 1."));
        }
        this._acceptThreadMax = maxSpare;
    }

    public int getAcceptThreadMax() {
        return this._acceptThreadMax;
    }

    public void setConnectionMax(int max) {
        this._connectionMax = max;
    }

    public int getConnectionMax() {
        return this._connectionMax;
    }

    public void addJavaExe(String args) {
    }

    public void addJvmArg(String args) {
    }

    public void addJvmClasspath(String args) {
    }

    public void addWatchdogArg(String args) {
    }

    public void addWatchdogJvmArg(String args) {
    }

    public void addWatchdogPassword(String args) {
    }

    public void addWatchdogPort(int port) {
    }

    public void addWatchdogAddress(String addr) {
    }

    public void setMemoryFreeMin(Bytes min) {
        this._memoryFreeMin = min.getBytes();
    }

    public long getMemoryFreeMin() {
        return this._memoryFreeMin;
    }

    public void setKeepaliveMax(int max) {
        this._keepaliveMax = max;
    }

    @Override
    public int getKeepaliveMax() {
        return this._keepaliveMax;
    }

    public void setKeepaliveTimeout(Period period) {
        this._clusterServer.setKeepaliveTimeout(period);
    }

    public long getKeepaliveTimeout() {
        return this._clusterServer.getKeepaliveTimeout();
    }

    public void setKeepaliveConnectionTimeMax(Period period) {
        this._keepaliveConnectionTimeMax = period.getPeriod();
    }

    public long getKeepaliveConnectionTimeMax() {
        return this._keepaliveConnectionTimeMax;
    }

    public void setKeepaliveSelectEnable(boolean enable) {
        this._keepaliveSelectEnable = enable;
    }

    public void setKeepaliveSelectMax(int max) {
        this._keepaliveSelectMax = max;
    }

    public boolean isKeepaliveSelectEnable() {
        return this._keepaliveSelectEnable;
    }

    public void setKeepaliveSelectThreadTimeout(Period period) {
        this._keepaliveSelectThreadTimeout = period.getPeriod();
    }

    public long getKeepaliveSelectThreadTimeout() {
        return this._keepaliveSelectThreadTimeout;
    }

    public Management createManagement() {
        if (this._management == null && this._resin != null) {
            this._management = this._resin.createManagement();
            this._management.setCluster(this.getCluster());
        }
        return this._management;
    }

    public void setRedeployMode(String redeployMode) {
    }

    public void setShutdownWaitMax(Period waitTime) {
        this._shutdownWaitMax = waitTime.getPeriod();
    }

    public void setSuspendTimeMax(Period period) {
        this._suspendTimeMax = period.getPeriod();
    }

    public long getSuspendTimeMax() {
        return this._suspendTimeMax;
    }

    public long getShutdownWaitMax() {
        return this._shutdownWaitMax;
    }

    public void setSocketTimeout(Period period) {
        this._clusterServer.setSocketTimeout(period);
    }

    public long getSocketTimeout() {
        return this._clusterServer.getSocketTimeout();
    }

    public void setThreadMax(int max) {
        if (max < 0) {
            throw new ConfigException(L.l("<thread-max> ({0}) must be greater than zero.", (long)max));
        }
        this._threadMax = max;
    }

    public void setThreadExecutorTaskMax(int max) {
        this._threadExecutorTaskMax = max;
    }

    public void setThreadIdleMin(int min) {
        this._threadIdleMin = min;
    }

    public void setThreadIdleMax(int max) {
        this._threadIdleMax = max;
    }

    public void setConnectionErrorPage(String errorPage) {
        this._connectionErrorPage = errorPage;
    }

    public String getConnectionErrorPage() {
        return this._connectionErrorPage;
    }

    public boolean isDeployError() {
        return this._configException != null;
    }

    @Override
    public String getSchema() {
        return "com/caucho/server/resin/cluster.rnc";
    }

    @Override
    public String getServerId() {
        return this._clusterServer.getId();
    }

    public void setRootDirectory(Path path) {
        this._hostContainer.setRootDirectory(path);
        Vfs.setPwd(path, this._classLoader);
    }

    public Path getRootDirectory() {
        return this._hostContainer.getRootDirectory();
    }

    public void setRootDir(Path path) {
        this.setRootDirectory(path);
    }

    public void setServerHeader(String server) {
        this._serverHeader = server;
    }

    public String getServerHeader() {
        return this._serverHeader;
    }

    public void setUrlLengthMax(int max) {
        this._urlLengthMax = max;
    }

    public int getUrlLengthMax() {
        return this._urlLengthMax;
    }

    public void addWebAppDefault(WebAppConfig init) {
        this._hostContainer.addWebAppDefault(init);
    }

    public void addEarDefault(EarConfig config) {
        this._hostContainer.addEarDefault(config);
    }

    public void addHostDefault(HostConfig init) {
        this._hostContainer.addHostDefault(init);
    }

    public HostExpandDeployGenerator createHostDeploy() {
        return this._hostContainer.createHostDeploy();
    }

    public void addHostDeploy(HostExpandDeployGenerator deploy) {
        this._hostContainer.addHostDeploy(deploy);
    }

    public void addHost(HostConfig host) throws Exception {
        this._hostContainer.addHost(host);
    }

    public Cluster getCluster() {
        return this._clusterServer.getCluster();
    }

    public RewriteDispatch createRewriteDispatch() {
        return this._hostContainer.createRewriteDispatch();
    }

    public AbstractCache createCache() throws ConfigException {
        try {
            Class<?> cl = Class.forName("com.caucho.server.cache.Cache");
            this._cache = (AbstractCache)cl.newInstance();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        if (this._cache == null) {
            throw new ConfigException(L.l("<cache> requires Resin Professional.  Please see http://www.caucho.com for Resin Professional information and licensing."));
        }
        return this._cache;
    }

    public void setAccessLog(AccessLog log) {
        this._accessLog = log;
        Environment.setAttribute("caucho.server.access-log", log);
    }

    public long getDependencyCheckInterval() {
        return Environment.getDependencyCheckInterval(this.getClassLoader());
    }

    public void setSessionCookie(String cookie) {
        this.getInvocationDecoder().setSessionCookie(cookie);
    }

    public String getSessionCookie() {
        return this.getInvocationDecoder().getSessionCookie();
    }

    public void setSSLSessionCookie(String cookie) {
        this.getInvocationDecoder().setSSLSessionCookie(cookie);
    }

    public String getSSLSessionCookie() {
        return this.getInvocationDecoder().getSSLSessionCookie();
    }

    public void setSessionURLPrefix(String urlPrefix) {
        this.getInvocationDecoder().setSessionURLPrefix(urlPrefix);
    }

    public String getSessionURLPrefix() {
        return this.getInvocationDecoder().getSessionURLPrefix();
    }

    public void setAlternateSessionURLPrefix(String urlPrefix) throws ConfigException {
        this.getInvocationDecoder().setAlternateSessionURLPrefix(urlPrefix);
    }

    public String getAlternateSessionURLPrefix() {
        return this.getInvocationDecoder().getAlternateSessionURLPrefix();
    }

    public void setURLCharacterEncoding(String encoding) throws ConfigException {
        this.getInvocationDecoder().setEncoding(encoding);
    }

    @Deprecated
    public ResourceAdapter createPing() throws ConfigException {
        return this.createManagement().createPing();
    }

    @Deprecated
    public void addPing(ResourceAdapter ping) throws ConfigException {
        this.createManagement().addPing(ping);
    }

    @Override
    public boolean isSelectManagerEnabled() {
        return this.getSelectManager() != null;
    }

    public void addSelectManager(SelectManagerCompat selectManager) {
    }

    public int getFreeKeepaliveSelect() {
        AbstractSelectManager selectManager = this.getSelectManager();
        if (selectManager != null) {
            return selectManager.getFreeKeepalive();
        }
        return 0x3FFFFFFF;
    }

    public void addErrorPage(ErrorPage errorPage) {
        this.getErrorWebApp().addErrorPage(errorPage);
    }

    public int getServerIndex() {
        return this._clusterServer.getIndex();
    }

    public long getStartTime() {
        return this._startTime;
    }

    public String getState() {
        return this._lifecycle.getStateName();
    }

    public int getKeepaliveSelectCount() {
        AbstractSelectManager selectManager = this.getSelectManager();
        if (selectManager != null) {
            return selectManager.getSelectCount();
        }
        return -1;
    }

    public ArrayList<CacheItem> getCacheStatistics() {
        ArrayList<Invocation> invocationList = this.getInvocations();
        if (invocationList == null) {
            return null;
        }
        HashMap<String, CacheItem> itemMap = new HashMap<String, CacheItem>();
        for (int i = 0; i < invocationList.size(); ++i) {
            CacheItem item;
            Invocation inv = invocationList.get(i);
            String uri = inv.getURI();
            int p = uri.indexOf(63);
            if (p >= 0) {
                uri = uri.substring(0, p);
            }
            if ((item = (CacheItem)itemMap.get(uri)) != null) continue;
            item = new CacheItem();
            item.setUrl(uri);
            itemMap.put(uri, item);
        }
        return null;
    }

    @Override
    public Invocation buildInvocation(Invocation invocation) throws Throwable {
        if (this._configException != null) {
            invocation.setFilterChain(new ExceptionFilterChain(this._configException));
            invocation.setWebApp(this.getErrorWebApp());
            invocation.setDependency((Dependency)AlwaysModified.create());
            return invocation;
        }
        if (this._lifecycle.waitForActive(this._waitForActiveTime)) {
            return this._hostContainer.buildInvocation(invocation);
        }
        int code = 503;
        invocation.setFilterChain(new ErrorFilterChain(code));
        invocation.setWebApp(this.getErrorWebApp());
        invocation.setDependency((Dependency)AlwaysModified.create());
        return invocation;
    }

    public String getServletPattern(String hostName, int port, String url) {
        try {
            Host host = this._hostContainer.getHost(hostName, port);
            if (host == null) {
                return null;
            }
            WebApp app = host.findWebAppByURI(url);
            if (app == null) {
                return null;
            }
            String pattern = app.getServletPattern(url);
            return pattern;
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.toString(), e);
            return null;
        }
    }

    public ServerMXBean getAdmin() {
        return this._admin;
    }

    public WebApp getDefaultWebApp() {
        WebApp webApp = this.getWebApp("", 80, "");
        if (webApp != null) {
            return webApp;
        }
        return this.getErrorWebApp();
    }

    public WebApp getWebApp(String hostName, int port, String url) {
        try {
            HostContainer hostContainer = this._hostContainer;
            if (hostContainer == null) {
                return null;
            }
            Host host = hostContainer.getHost(hostName, port);
            if (host == null) {
                return null;
            }
            return host.findWebAppByURI(url);
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.toString(), e);
            return null;
        }
    }

    public WebApp getErrorWebApp() {
        HostContainer hostContainer = this._hostContainer;
        if (hostContainer != null) {
            return hostContainer.getErrorWebApp();
        }
        return null;
    }

    public Collection<HostController> getHostControllers() {
        HostContainer hostContainer = this._hostContainer;
        if (hostContainer == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(hostContainer.getHostList());
    }

    public Host getHost(String hostName, int port) {
        try {
            return this._hostContainer.getHost(hostName, port);
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.toString(), e);
            return null;
        }
    }

    public void setBindPortsAfterStart(boolean bindAtEnd) {
        this._isBindPortsAtEnd = bindAtEnd;
    }

    public boolean isBindPortsAfterStart() {
        return this._isBindPortsAtEnd;
    }

    public Collection<Port> getPorts() {
        return Collections.unmodifiableList(this._clusterServer.getPorts());
    }

    @Override
    public void classLoaderInit(DynamicClassLoader loader) {
    }

    @Override
    public void classLoaderDestroy(DynamicClassLoader loader) {
    }

    @Override
    @PostConstruct
    public void init() {
        this._classLoader.init();
        super.init();
        if (this._resin != null && this._resin.getManagementPath() != null) {
            this.createManagement().setManagementPath(this._resin.getManagementPath());
        }
        if (this._resin != null) {
            this.createManagement().setCluster(this.getCluster());
            this.createManagement().setServer(this);
            this.createManagement().init();
        }
        if (this._threadMax < this._threadIdleMax) {
            throw new ConfigException(L.l("<thread-idle-max> ({0}) must be less than <thread-max> ({1})", this._threadIdleMax, this._threadMax));
        }
        if (this._threadIdleMax < this._threadIdleMin) {
            throw new ConfigException(L.l("<thread-idle-min> ({0}) must be less than <thread-idle-max> ({1})", this._threadIdleMin, this._threadIdleMax));
        }
        if (this._threadMax < this._threadExecutorTaskMax) {
            throw new ConfigException(L.l("<thread-executor-task-max> ({0}) must be less than <thread-max> ({1})", this._threadExecutorTaskMax, this._threadMax));
        }
        ThreadPool threadPool = ThreadPool.getThreadPool();
        threadPool.setThreadMax(this._threadMax);
        threadPool.setThreadIdleMax(this._threadIdleMax);
        threadPool.setThreadIdleMin(this._threadIdleMin);
        threadPool.setExecutorTaskMax(this._threadExecutorTaskMax);
        if (this._keepaliveSelectEnable) {
            try {
                Class<?> cl = Class.forName("com.caucho.server.port.JniSelectManager");
                Method method = cl.getMethod("create", new Class[0]);
                this.initSelectManager((AbstractSelectManager)method.invoke(null, null));
            }
            catch (ClassNotFoundException e) {
                log.warning(L.l("'select-manager' requires Resin Professional.  See http://www.caucho.com for information and licensing."));
            }
            catch (Throwable e) {
                log.warning(L.l("Cannot enable select-manager {0}", (Object)e.toString()));
                log.log(Level.FINER, e.toString());
            }
            if (this.getSelectManager() != null && this._keepaliveSelectMax > 0) {
                this.getSelectManager().setSelectMax(this._keepaliveSelectMax);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void start() {
        ClassLoader oldLoader;
        Thread thread;
        block15: {
            this.init();
            thread = Thread.currentThread();
            oldLoader = thread.getContextClassLoader();
            try {
                block14: {
                    try {
                        thread.setContextClassLoader(this._classLoader);
                        if (!this._lifecycle.toStarting()) {
                            Object var5_3 = null;
                            break block14;
                        }
                        this._startTime = Alarm.getCurrentTime();
                        if (!Alarm.isTest()) {
                            log.info("");
                            log.info(System.getProperty("os.name") + " " + System.getProperty("os.version") + " " + System.getProperty("os.arch"));
                            log.info(System.getProperty("java.runtime.name") + " " + System.getProperty("java.runtime.version") + ", " + System.getProperty("file.encoding") + ", " + System.getProperty("user.language"));
                            log.info(System.getProperty("java.vm.name") + " " + System.getProperty("java.vm.version") + ", " + System.getProperty("sun.arch.data.model") + ", " + System.getProperty("java.vm.info") + ", " + System.getProperty("java.vm.vendor"));
                            log.info("user.name: " + System.getProperty("user.name"));
                            Resin resin = Resin.getLocal();
                            if (resin != null) {
                                log.info("resin.home = " + resin.getResinHome().getNativePath());
                                log.info("resin.root = " + resin.getRootDirectory().getNativePath());
                                log.info("resin.conf = " + resin.getResinConf());
                            } else {
                                log.info("resin.home = " + System.getProperty("resin.home"));
                            }
                            log.info("");
                        }
                        this._lifecycle.toStarting();
                        if (this._resin != null && this._resin.getManagement() != null) {
                            this._resin.getManagement().start(this);
                        }
                        AbstractSelectManager selectManager = this.getSelectManager();
                        if (!this._keepaliveSelectEnable || selectManager == null || !selectManager.start()) {
                            this.initSelectManager(null);
                        }
                        if (!this._isBindPortsAtEnd) {
                            this.bindPorts();
                            this.startPorts();
                        }
                        this._classLoader.start();
                        this._hostContainer.start();
                        this.getCluster().startPersistentStore();
                        if (this._isBindPortsAtEnd) {
                            this.bindPorts();
                            this.startPorts();
                        }
                        this._alarm.queue(60000L);
                        this._lifecycle.toActive();
                        break block15;
                    }
                    catch (RuntimeException e) {
                        log.log(Level.WARNING, e.toString(), e);
                        this._lifecycle.toError();
                        throw e;
                    }
                    catch (Exception e) {
                        log.log(Level.WARNING, e.toString(), e);
                        this._lifecycle.toError();
                        throw new RuntimeException(e);
                    }
                }
                thread.setContextClassLoader(oldLoader);
                return;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                thread.setContextClassLoader(oldLoader);
                throw throwable;
            }
        }
        Object var5_4 = null;
        thread.setContextClassLoader(oldLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bindPorts() throws Exception {
        Server server = this;
        synchronized (server) {
            if (this._isStartedPorts) {
                return;
            }
            this._isStartedPorts = true;
        }
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this._classLoader);
            ArrayList<Port> ports = this._clusterServer.getPorts();
            for (int i = 0; i < ports.size(); ++i) {
                Port port = ports.get(i);
                port.setServer(this);
                port.bind();
            }
            Object var7_7 = null;
            thread.setContextClassLoader(oldLoader);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            thread.setContextClassLoader(oldLoader);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startPorts() throws Exception {
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this._classLoader);
            ArrayList<Port> ports = this._clusterServer.getPorts();
            for (int i = 0; i < ports.size(); ++i) {
                Port port = ports.get(i);
                port.start();
            }
            Object var7_6 = null;
            thread.setContextClassLoader(oldLoader);
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            thread.setContextClassLoader(oldLoader);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handleAlarm(Alarm alarm) {
        block8: {
            block7: {
                if (!this._lifecycle.isActive()) {
                    return;
                }
                try {
                    long now = Alarm.getCurrentTime();
                    if (this.isModified()) {
                        log.warning("Resin restarting due to configuration change");
                        this._clusterServer.getCluster().getResin().destroy();
                        Object var8_3 = null;
                        break block7;
                    }
                    try {
                        ArrayList<Port> ports = this._clusterServer.getPorts();
                        for (int i = 0; i < ports.size(); ++i) {
                            Port port = ports.get(i);
                            if (!port.isClosed()) continue;
                            log.severe("Resin restarting due to closed port: " + port);
                        }
                        break block8;
                    }
                    catch (Throwable e) {
                        log.log(Level.WARNING, e.toString(), e);
                        Object var8_4 = null;
                        alarm.queue(60000L);
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var8_6 = null;
                    alarm.queue(60000L);
                    throw throwable;
                }
            }
            alarm.queue(60000L);
            return;
        }
        Object var8_5 = null;
        alarm.queue(60000L);
    }

    @Override
    public boolean isModified() {
        boolean isModified = this._classLoader.isModified();
        if (isModified) {
            log.fine("server is modified");
        }
        return isModified;
    }

    public boolean isModifiedNow() {
        boolean isModified = this._classLoader.isModifiedNow();
        if (isModified) {
            log.fine("server is modified");
        }
        return isModified;
    }

    public boolean isStopping() {
        return this._lifecycle.isStopping();
    }

    public boolean isStopped() {
        return this._lifecycle.isStopped();
    }

    @Override
    public boolean isDestroyed() {
        return this._lifecycle.isDestroyed();
    }

    public boolean isDestroying() {
        return this._lifecycle.isDestroying();
    }

    @Override
    public boolean isActive() {
        return this._lifecycle.isActive();
    }

    public void clearCacheByPattern(String hostPattern, String uriPattern) {
        final Matcher hostMatcher = hostPattern != null ? Pattern.compile(hostPattern).matcher("") : null;
        final Matcher uriMatcher = uriPattern != null ? Pattern.compile(uriPattern).matcher("") : null;
        InvocationMatcher matcher = new InvocationMatcher(){

            public boolean isMatch(Invocation invocation) {
                if (hostMatcher != null) {
                    hostMatcher.reset(invocation.getHost());
                    if (!hostMatcher.find()) {
                        return false;
                    }
                }
                if (uriMatcher != null) {
                    uriMatcher.reset(invocation.getURI());
                    if (!uriMatcher.find()) {
                        return false;
                    }
                }
                return true;
            }
        };
        this.invalidateMatchingInvocations(matcher);
    }

    @Override
    public void clearCache() {
        if (this.isStopping()) {
            return;
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("ServletServer clearCache");
        }
        super.clearCache();
        if (this._cache != null) {
            this._cache.clear();
        }
    }

    public long getProxyCacheHitCount() {
        if (this._cache != null) {
            return this._cache.getHitCount();
        }
        return 0L;
    }

    public long getProxyCacheMissCount() {
        if (this._cache != null) {
            return this._cache.getMissCount();
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this._classLoader);
            if (!this._lifecycle.toStopping()) {
                Object var9_3 = null;
                thread.setContextClassLoader(oldLoader);
                return;
            }
            super.stop();
            Alarm alarm = this._alarm;
            this._alarm = null;
            if (alarm != null) {
                alarm.dequeue();
            }
            if (this.getSelectManager() != null) {
                this.getSelectManager().stop();
            }
            ArrayList<Port> ports = this._clusterServer.getPorts();
            for (int i = 0; i < ports.size(); ++i) {
                Port port = ports.get(i);
                try {
                    port.close();
                    continue;
                }
                catch (Throwable e) {
                    log.log(Level.WARNING, e.toString(), e);
                }
            }
            try {
                ThreadPool.getThreadPool().interrupt();
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString(), e);
            }
            try {
                Thread.yield();
            }
            catch (Throwable e) {
                // empty catch block
            }
            try {
                if (this._hostContainer != null) {
                    this._hostContainer.stop();
                }
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString(), e);
            }
            try {
                this._classLoader.stop();
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString(), e);
            }
            this._lifecycle.toStop();
        }
        catch (Throwable throwable) {
            Object var9_5 = null;
            thread.setContextClassLoader(oldLoader);
            throw throwable;
        }
        Object var9_4 = null;
        thread.setContextClassLoader(oldLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        this.stop();
        if (!this._lifecycle.toDestroy()) {
            return;
        }
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this._classLoader);
            try {
                Management management = this._management;
                this._management = null;
                if (management != null) {
                    management.destroy();
                }
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString(), e);
            }
            try {
                this._hostContainer.destroy();
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString(), e);
            }
            super.destroy();
            log.fine(this + " destroyed");
            this._classLoader.destroy();
            this._hostContainer = null;
            this._accessLog = null;
            this._cache = null;
            Object var5_6 = null;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            DynamicClassLoader.setOldLoader(thread, oldLoader);
            Resin resin = this._resin;
            if (resin != null) {
                resin.destroy();
            }
            throw throwable;
        }
        DynamicClassLoader.setOldLoader(thread, oldLoader);
        Resin resin = this._resin;
        if (resin != null) {
            resin.destroy();
        }
    }

    public String toString() {
        return "Server[id=" + this.getServerId() + ",cluster=" + this._clusterServer.getCluster().getId() + "]";
    }

    public static class SelectManagerCompat {
        private boolean _isEnable = true;

        public void setEnable(boolean isEnable) {
            this._isEnable = isEnable;
        }

        public boolean isEnable() {
            return this._isEnable;
        }
    }
}

