/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.cluster;

import com.caucho.management.server.AbstractEmitterObject;
import com.caucho.management.server.ClusterMXBean;
import com.caucho.management.server.PortMXBean;
import com.caucho.management.server.ServerMXBean;
import com.caucho.management.server.ThreadPoolMXBean;
import com.caucho.server.cluster.Server;
import com.caucho.server.port.Port;
import com.caucho.server.util.CauchoSystem;
import com.caucho.util.Alarm;
import java.util.Collection;
import java.util.Date;

public class ServerAdmin
extends AbstractEmitterObject
implements ServerMXBean {
    private Server _server;

    ServerAdmin(Server server) {
        this._server = server;
        this.registerSelf();
    }

    public String getName() {
        return null;
    }

    public String getType() {
        return "Server";
    }

    public String getId() {
        return this._server.getServerId();
    }

    public ClusterMXBean getCluster() {
        return this._server.getCluster().getAdmin();
    }

    public PortMXBean[] getPorts() {
        Collection<Port> portList = this._server.getPorts();
        PortMXBean[] ports = new PortMXBean[portList.size()];
        int i = 0;
        for (Port port : portList) {
            ports[i++] = port.getAdmin();
        }
        return ports;
    }

    public ThreadPoolMXBean getThreadPool() {
        return this._server.getCluster().getResin().getThreadPoolAdmin();
    }

    public PortMXBean getClusterPort() {
        return null;
    }

    public boolean isDetailedStatistics() {
        return false;
    }

    public boolean isSelectManagerEnabled() {
        return this._server.isSelectManagerEnabled();
    }

    public long getShutdownWaitMax() {
        return this._server.getShutdownWaitMax();
    }

    public String getState() {
        return this._server.getState();
    }

    public Date getCurrentTime() {
        return new Date(Alarm.getExactTime());
    }

    public Date getStartTime() {
        return new Date(this._server.getStartTime());
    }

    public int getThreadActiveCount() {
        int activeThreadCount = -1;
        for (Port port : this._server.getPorts()) {
            if (port.getActiveThreadCount() < 0) continue;
            if (activeThreadCount == -1) {
                activeThreadCount = 0;
            }
            activeThreadCount += port.getActiveThreadCount();
        }
        return activeThreadCount;
    }

    public int getThreadKeepaliveCount() {
        int keepaliveThreadCount = -1;
        for (Port port : this._server.getPorts()) {
            if (port.getKeepaliveConnectionCount() < 0) continue;
            if (keepaliveThreadCount == -1) {
                keepaliveThreadCount = 0;
            }
            keepaliveThreadCount += port.getKeepaliveConnectionCount();
        }
        return keepaliveThreadCount;
    }

    public int getSelectKeepaliveCount() {
        return this._server.getKeepaliveSelectCount();
    }

    public long getRequestCountTotal() {
        long lifetimeRequestCount = 0L;
        for (Port port : this._server.getPorts()) {
            lifetimeRequestCount += port.getLifetimeRequestCount();
        }
        return lifetimeRequestCount;
    }

    public long getKeepaliveCountTotal() {
        return -1L;
    }

    public long getClientDisconnectCountTotal() {
        long lifetimeClientDisconnectCount = 0L;
        for (Port port : this._server.getPorts()) {
            lifetimeClientDisconnectCount += port.getLifetimeClientDisconnectCount();
        }
        return lifetimeClientDisconnectCount;
    }

    public long getRequestTimeTotal() {
        return -1L;
    }

    public long getRequestReadBytesTotal() {
        return -1L;
    }

    public long getRequestWriteBytesTotal() {
        return -1L;
    }

    public long getInvocationCacheHitCountTotal() {
        return this._server.getInvocationCacheHitCount();
    }

    public long getInvocationCacheMissCountTotal() {
        return this._server.getInvocationCacheMissCount();
    }

    public long getRuntimeMemory() {
        if (Alarm.isTest()) {
            return 666L;
        }
        return Runtime.getRuntime().totalMemory();
    }

    public long getRuntimeMemoryFree() {
        if (Alarm.isTest()) {
            return 666L;
        }
        return Runtime.getRuntime().freeMemory();
    }

    public double getCpuLoadAvg() {
        try {
            if (Alarm.isTest()) {
                return 0.0;
            }
            return CauchoSystem.getLoadAvg();
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    public void restart() {
        this._server.destroy();
    }
}

