/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.cluster;

import com.caucho.management.server.ServerConnectorMXBean;
import com.caucho.server.cluster.Cluster;
import com.caucho.server.cluster.ClusterPort;
import com.caucho.server.cluster.ClusterServer;
import com.caucho.server.cluster.ClusterStream;
import com.caucho.server.cluster.ServerConnectorAdmin;
import com.caucho.server.resin.Resin;
import com.caucho.util.Alarm;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.ReadWritePair;
import com.caucho.vfs.Vfs;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.ObjectName;

public class ServerConnector {
    private static final Logger log = Logger.getLogger(ServerConnector.class.getName());
    private static final L10N L = new L10N(ServerConnector.class);
    private static final int ST_NEW = 0;
    private static final int ST_STANDBY = 1;
    private static final int ST_SESSION_ONLY = 2;
    private static final int ST_STARTING = 3;
    private static final int ST_WARMUP = 4;
    private static final int ST_BUSY = 5;
    private static final int ST_FAIL = 6;
    private static final int ST_ACTIVE = 7;
    private static final int ST_CLOSED = 8;
    private static final int WARMUP_MAX = 16;
    private static final int WARMUP_MIN = -16;
    private static final int[] WARMUP_CONNECTION_MAX = new int[]{1, 1, 1, 1, 2, 2, 2, 2, 4, 4, 8, 8, 16, 32, 64, 128};
    private ClusterServer _server;
    private ClusterPort _port;
    private ObjectName _objectName;
    private Cluster _cluster;
    private Path _tcpPath;
    private ServerConnectorAdmin _admin;
    private String _debugId;
    private int _maxConnections = 0x3FFFFFFF;
    private ClusterStream[] _idle = new ClusterStream[64];
    private volatile int _idleHead;
    private volatile int _idleTail;
    private int _idleSize = 16;
    private int _streamCount;
    private long _warmupTime;
    private long _warmupChunkTime;
    private long _failRecoverTime;
    private long _failChunkTime;
    private volatile int _state = 0;
    private volatile int _activeCount;
    private volatile int _startingCount;
    private volatile int _loadBalanceAllocateCount;
    private volatile int _warmupState;
    private volatile long _lastFailConnectTime;
    private volatile long _dynamicFailRecoverTime = 1000L;
    private volatile long _lastFailTime;
    private volatile long _lastBusyTime;
    private volatile long _failTime;
    private volatile long _firstSuccessTime;
    private volatile long _lastSuccessTime;
    private volatile long _prevSuccessTime;
    private volatile double _latencyFactor;
    private volatile long _keepaliveCountTotal;
    private volatile long _connectCountTotal;
    private volatile long _failCountTotal;
    private volatile long _busyCountTotal;
    private volatile double _cpuLoadAvg;
    private volatile long _cpuSetTime;

    public ServerConnector(ClusterServer server) {
        this._server = server;
        this._cluster = this._server.getCluster();
        this._port = server.getClusterPort();
    }

    public Cluster getCluster() {
        return this._cluster;
    }

    public ObjectName getObjectName() {
        return this._objectName;
    }

    public ServerConnectorMXBean getAdmin() {
        return this._admin;
    }

    public ClusterPort getClusterPort() {
        return this._port;
    }

    public String getId() {
        return this._server.getId();
    }

    public int getIndex() {
        return this._server.getIndex();
    }

    public String getAddress() {
        return this._port.getAddress();
    }

    public int getPort() {
        return this._port.getPort();
    }

    public long getLoadBalanceWarmupTime() {
        return this._server.getLoadBalanceWarmupTime();
    }

    public long getLoadBalanceConnectTimeout() {
        return this._server.getLoadBalanceConnectTimeout();
    }

    public long getLoadBalanceSocketTimeout() {
        return this._server.getLoadBalanceSocketTimeout();
    }

    public long getLoadBalanceIdleTime() {
        return this._server.getLoadBalanceIdleTime();
    }

    public long getLoadBalanceRecoverTime() {
        return this._server.getLoadBalanceRecoverTime();
    }

    public int getLoadBalanceWeight() {
        return this._server.getLoadBalanceWeight();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws Exception {
        this._warmupTime = this._server.getLoadBalanceWarmupTime();
        this._warmupChunkTime = this._warmupTime / 16L;
        if (this._warmupChunkTime <= 0L) {
            this._warmupChunkTime = 1L;
        }
        this._failRecoverTime = this._server.getLoadBalanceRecoverTime();
        this._failChunkTime = this._failRecoverTime / 16L;
        if (this._failChunkTime <= 0L) {
            this._failChunkTime = 1L;
        }
        this._state = 3;
        String address = this.getAddress();
        if (address == null) {
            address = "localhost";
        }
        HashMap<String, Object> attr = new HashMap<String, Object>();
        attr.put("connect-timeout", new Long(this.getLoadBalanceConnectTimeout()));
        this._tcpPath = this._port.isSSL() ? Vfs.lookup("tcps://" + address + ":" + this.getPort(), attr) : Vfs.lookup("tcp://" + address + ":" + this.getPort(), attr);
        this._admin = new ServerConnectorAdmin(this);
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            block8: {
                try {
                    String name;
                    Resin resin = Resin.getLocal();
                    if (resin != null) {
                        thread.setContextClassLoader(resin.getClassLoader());
                    }
                    if ((name = this.getId()) != null) break block8;
                    name = "";
                }
                catch (Exception e) {
                    log.log(Level.FINER, e.toString(), e);
                    Object var8_9 = null;
                    thread.setContextClassLoader(oldLoader);
                }
            }
            Object var8_8 = null;
            thread.setContextClassLoader(oldLoader);
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            thread.setContextClassLoader(oldLoader);
            throw throwable;
        }
    }

    public void register() {
        this._admin.register();
    }

    public int getActiveCount() {
        return this._activeCount;
    }

    public int getIdleCount() {
        return (this._idleHead - this._idleTail + this._idle.length) % this._idle.length;
    }

    public int getLoadBalanceAllocateCount() {
        return this._loadBalanceAllocateCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void allocateLoadBalance() {
        ServerConnector serverConnector = this;
        synchronized (serverConnector) {
            ++this._loadBalanceAllocateCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void freeLoadBalance() {
        ServerConnector serverConnector = this;
        synchronized (serverConnector) {
            --this._loadBalanceAllocateCount;
        }
    }

    public long getConnectCountTotal() {
        return this._connectCountTotal;
    }

    public long getKeepaliveCountTotal() {
        return this._keepaliveCountTotal;
    }

    public long getFailCountTotal() {
        return this._failCountTotal;
    }

    public Date getLastFailTime() {
        return new Date(this._lastFailTime);
    }

    public Date getLastFailConnectTime() {
        return new Date(this._lastFailConnectTime);
    }

    public long getLastSuccessTime() {
        return this._lastSuccessTime;
    }

    public double getLatencyFactor() {
        return this._latencyFactor;
    }

    public long getBusyCountTotal() {
        return this._busyCountTotal;
    }

    public Date getLastBusyTime() {
        return new Date(this._lastBusyTime);
    }

    public void setCpuLoadAvg(double load) {
        this._cpuSetTime = Alarm.getCurrentTime();
        this._cpuLoadAvg = load;
    }

    public double getCpuLoadAvg() {
        double avg = this._cpuLoadAvg;
        long time = this._cpuSetTime;
        long now = Alarm.getCurrentTime();
        if (now - time < 10000L) {
            return avg;
        }
        return avg * 10000.0 / (double)(now - time);
    }

    public String getDebugId() {
        if (this._debugId == null) {
            String targetId;
            String selfId = null;
            Cluster localCluster = Cluster.getLocal();
            if (localCluster != null) {
                selfId = localCluster.getId();
            }
            if (selfId == null || selfId.equals("")) {
                selfId = "default";
            }
            if ((targetId = this._server.getId()) == null || targetId.equals("")) {
                targetId = String.valueOf(this._server.getIndex());
            }
            this._debugId = selfId + "->" + targetId;
        }
        return this._debugId;
    }

    public final boolean isActive() {
        switch (this._state) {
            case 7: {
                return true;
            }
            case 1: 
            case 8: {
                return false;
            }
            case 6: {
                return this._failTime + this._failRecoverTime <= Alarm.getCurrentTime();
            }
        }
        return false;
    }

    public boolean isDead() {
        return !this.isActive();
    }

    public void enable() {
        this.start();
    }

    public void disable() {
        this.stop();
    }

    public String getState() {
        this.updateWarmup();
        switch (this._state) {
            case 0: {
                return "init";
            }
            case 1: {
                return "standby";
            }
            case 2: {
                return "session-only";
            }
            case 3: {
                return "starting";
            }
            case 4: {
                return "warmup";
            }
            case 5: {
                return "busy";
            }
            case 6: {
                return "fail";
            }
            case 7: {
                return "active";
            }
            case 8: {
                return "closed";
            }
        }
        return "unknown(" + this._state + ")";
    }

    public boolean canOpenSoftOrRecycle() {
        return this.getIdleCount() > 0 || this.canOpenSoft();
    }

    public boolean canOpenSoft() {
        int state = this._state;
        if (state == 7) {
            return true;
        }
        if (3 <= state && state < 7) {
            long now = Alarm.getCurrentTime();
            if (now < this._lastFailConnectTime + this._dynamicFailRecoverTime) {
                return false;
            }
            int warmupState = this._warmupState;
            if (warmupState < 0) {
                return this._failTime - (long)warmupState * this._failChunkTime < now;
            }
            if (16 <= warmupState) {
                return true;
            }
            int connectionMax = WARMUP_CONNECTION_MAX[warmupState];
            int activeCount = this._activeCount + this._startingCount;
            int idleCount = this.getIdleCount();
            int totalCount = activeCount + idleCount;
            return totalCount < connectionMax;
        }
        return false;
    }

    public boolean isEnabled() {
        int state = this._state;
        return 3 <= state && state <= 7;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void toActive() {
        ServerConnector serverConnector = this;
        synchronized (serverConnector) {
            if (this._state < 8) {
                this._state = 7;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toBusy() {
        this._lastBusyTime = Alarm.getCurrentTime();
        this._firstSuccessTime = 0L;
        ServerConnector serverConnector = this;
        synchronized (serverConnector) {
            ++this._busyCountTotal;
            if (this._state < 8) {
                this._state = 5;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toFail() {
        this._lastFailTime = this._failTime = Alarm.getCurrentTime();
        this._firstSuccessTime = 0L;
        ServerConnector serverConnector = this;
        synchronized (serverConnector) {
            ++this._failCountTotal;
            if (this._state < 8) {
                this._state = 6;
            }
        }
        this.clearRecycle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void failSocket() {
        ServerConnector serverConnector = this;
        synchronized (serverConnector) {
            ++this._failCountTotal;
            long now = Alarm.getCurrentTime();
            this._firstSuccessTime = 0L;
            if (now - this._failTime >= 100L) {
                --this._warmupState;
                this._lastFailTime = this._failTime = now;
            }
            if (this._warmupState < -16) {
                this._warmupState = -16;
            }
            if (this._state < 8) {
                this._state = 6;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void failConnect() {
        ServerConnector serverConnector = this;
        synchronized (serverConnector) {
            long now;
            ++this._failCountTotal;
            this._firstSuccessTime = 0L;
            --this._warmupState;
            this._lastFailTime = this._failTime = (now = Alarm.getCurrentTime());
            this._lastFailConnectTime = now;
            this._dynamicFailRecoverTime *= 2L;
            if (this._failRecoverTime < this._dynamicFailRecoverTime) {
                this._dynamicFailRecoverTime = this._failRecoverTime;
            }
            if (this._warmupState < -16) {
                this._warmupState = -16;
            }
            if (this._state < 8) {
                this._state = 6;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void busy() {
        ServerConnector serverConnector = this;
        synchronized (serverConnector) {
            this._lastBusyTime = Alarm.getCurrentTime();
            this._firstSuccessTime = 0L;
            --this._warmupState;
            if (this._warmupState < 0) {
                this._warmupState = 0;
            }
            ++this._busyCountTotal;
            if (this._state < 8) {
                this._state = 5;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        ServerConnector serverConnector = this;
        synchronized (serverConnector) {
            if (this._state != 7 && this._state < 8) {
                this._state = 3;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        ServerConnector serverConnector = this;
        synchronized (serverConnector) {
            if (this._state < 8) {
                this._state = 1;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableSessionOnly() {
        ServerConnector serverConnector = this;
        synchronized (serverConnector) {
            if (this._state < 8 && this._state != 1) {
                this._state = 2;
            }
        }
    }

    public ClusterStream openSoft() {
        int state = this._state;
        if (3 > state || state > 7) {
            return null;
        }
        ClusterStream stream = this.openRecycle();
        if (stream != null) {
            return stream;
        }
        if (this.canOpenSoft()) {
            return this.connect();
        }
        return null;
    }

    public ClusterStream openIfLive() {
        if (this._state == 8) {
            return null;
        }
        ClusterStream stream = this.openRecycle();
        if (stream != null) {
            return stream;
        }
        long now = Alarm.getCurrentTime();
        if (now < this._failTime + this._failRecoverTime) {
            return null;
        }
        return this.connect();
    }

    public ClusterStream openForSession() {
        int state = this._state;
        if (2 > state || state >= 8) {
            return null;
        }
        ClusterStream stream = this.openRecycle();
        if (stream != null) {
            return stream;
        }
        long now = Alarm.getCurrentTime();
        if (now < this._failTime + this._failRecoverTime) {
            return null;
        }
        if (now < this._lastBusyTime + this._failRecoverTime) {
            return null;
        }
        return this.connect();
    }

    public ClusterStream open() {
        int state = this._state;
        if (3 > state || state >= 8) {
            return null;
        }
        ClusterStream stream = this.openRecycle();
        if (stream != null) {
            return stream;
        }
        return this.connect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClusterStream openRecycle() {
        long now = Alarm.getCurrentTime();
        ClusterStream stream = null;
        ServerConnector serverConnector = this;
        synchronized (serverConnector) {
            if (this._idleHead != this._idleTail) {
                stream = this._idle[this._idleHead];
                long freeTime = stream.getFreeTime();
                this._idle[this._idleHead] = null;
                this._idleHead = (this._idleHead + this._idle.length - 1) % this._idle.length;
                if (now < freeTime + this._server.getLoadBalanceIdleTime()) {
                    ++this._activeCount;
                    ++this._keepaliveCountTotal;
                    return stream;
                }
            }
        }
        if (stream != null) {
            stream.closeImpl();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClusterStream connect() {
        ServerConnector serverConnector;
        ClusterStream clusterStream;
        ServerConnector serverConnector2 = this;
        synchronized (serverConnector2) {
            if (this._maxConnections <= this._activeCount + this._startingCount) {
                return null;
            }
            ++this._startingCount;
        }
        try {
            ReadWritePair pair = this.openTCPPair();
            ReadStream rs = pair.getReadStream();
            rs.setAttribute("timeout", (Object)new Integer((int)this.getLoadBalanceSocketTimeout()));
            ServerConnector serverConnector3 = this;
            synchronized (serverConnector3) {
                ++this._activeCount;
                ++this._connectCountTotal;
            }
            ClusterStream stream = new ClusterStream(this._streamCount++, this, rs, pair.getWriteStream());
            if (log.isLoggable(Level.FINER)) {
                log.finer("connect " + stream);
            }
            if (this._firstSuccessTime <= 0L) {
                if (3 <= this._state && this._state < 7) {
                    this._state = this._warmupTime > 0L ? 4 : 7;
                    this._firstSuccessTime = Alarm.getCurrentTime();
                }
                if (this._warmupState < 0) {
                    this._warmupState = 0;
                }
            }
            clusterStream = stream;
            Object var6_9 = null;
            serverConnector = this;
        }
        catch (IOException e) {
            ServerConnector serverConnector4;
            ClusterStream clusterStream2;
            try {
                log.log(Level.FINER, e.toString(), e);
                this.failConnect();
                clusterStream2 = null;
                Object var6_10 = null;
                serverConnector4 = this;
            }
            catch (Throwable throwable) {
                Object var6_11 = null;
                ServerConnector serverConnector5 = this;
                synchronized (serverConnector5) {
                    --this._startingCount;
                }
                throw throwable;
            }
            synchronized (serverConnector4) {
                --this._startingCount;
            }
            return clusterStream2;
        }
        synchronized (serverConnector) {
            --this._startingCount;
        }
        return clusterStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wake() {
        ServerConnector serverConnector = this;
        synchronized (serverConnector) {
            if (this._state == 6) {
                this._state = 3;
            }
            this._failTime = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void free(ClusterStream stream) {
        ServerConnector serverConnector = this;
        synchronized (serverConnector) {
            --this._activeCount;
            int size = (this._idleHead - this._idleTail + this._idle.length) % this._idle.length;
            if (this._state != 8 && size < this._idleSize) {
                this._idleHead = (this._idleHead + 1) % this._idle.length;
                this._idle[this._idleHead] = stream;
                stream = null;
            }
            long now = Alarm.getCurrentTime();
            long prevSuccessTime = this._prevSuccessTime;
            if (prevSuccessTime > 0L) {
                this._latencyFactor = 0.95 * this._latencyFactor + 0.05 * (double)(now - prevSuccessTime);
            }
            this._prevSuccessTime = this._activeCount > 0 ? now : 0L;
            this._lastSuccessTime = now;
        }
        this.updateWarmup();
        long now = Alarm.getCurrentTime();
        long maxIdleTime = this._server.getLoadBalanceIdleTime();
        ClusterStream oldStream = null;
        do {
            oldStream = null;
            ServerConnector serverConnector2 = this;
            synchronized (serverConnector2) {
                if (this._idleHead != this._idleTail) {
                    int nextTail = (this._idleTail + 1) % this._idle.length;
                    oldStream = this._idle[nextTail];
                    if (oldStream != null && oldStream.getFreeTime() + maxIdleTime < now) {
                        this._idle[nextTail] = null;
                        this._idleTail = nextTail;
                    } else {
                        oldStream = null;
                    }
                }
            }
            if (oldStream == null) continue;
            oldStream.closeImpl();
        } while (oldStream != null);
        if (stream != null) {
            stream.closeImpl();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateWarmup() {
        ServerConnector serverConnector = this;
        synchronized (serverConnector) {
            if (!this.isEnabled()) {
                return;
            }
            long now = Alarm.getCurrentTime();
            int warmupState = this._warmupState;
            if (warmupState >= 0 && this._firstSuccessTime > 0L) {
                warmupState = (int)((now - this._firstSuccessTime) / this._warmupChunkTime);
                this._dynamicFailRecoverTime = 1000L;
                if (16 <= warmupState) {
                    warmupState = 16;
                    this.toActive();
                }
            }
            this._warmupState = warmupState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close(ClusterStream stream) {
        if (log.isLoggable(Level.FINER)) {
            log.finer("close " + stream);
        }
        ServerConnector serverConnector = this;
        synchronized (serverConnector) {
            --this._activeCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearRecycle() {
        ArrayList<ClusterStream> recycleList = null;
        ServerConnector serverConnector = this;
        synchronized (serverConnector) {
            this._idleTail = 0;
            this._idleHead = 0;
            for (int i = 0; i < this._idle.length; ++i) {
                ClusterStream stream = this._idle[i];
                this._idle[i] = null;
                if (stream == null) continue;
                if (recycleList == null) {
                    recycleList = new ArrayList<ClusterStream>();
                }
                recycleList.add(stream);
            }
        }
        if (recycleList != null) {
            for (ClusterStream stream : recycleList) {
                stream.closeImpl();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        ServerConnector serverConnector = this;
        synchronized (serverConnector) {
            if (this._state == 8) {
                return;
            }
            this._state = 8;
        }
        serverConnector = this;
        synchronized (serverConnector) {
            this._idleTail = 0;
            this._idleHead = 0;
        }
        for (int i = 0; i < this._idle.length; ++i) {
            ClusterStream stream;
            ServerConnector serverConnector2 = this;
            synchronized (serverConnector2) {
                stream = this._idle[i];
                this._idle[i] = null;
            }
            if (stream == null) continue;
            stream.closeImpl();
        }
    }

    ReadWritePair openTCPPair() throws IOException {
        return this._tcpPath.openReadWrite();
    }

    public boolean canConnect() {
        try {
            this.wake();
            ClusterStream stream = this.open();
            if (stream != null) {
                stream.free();
                return true;
            }
            return false;
        }
        catch (Exception e) {
            log.log(Level.FINER, e.toString(), e);
            return false;
        }
    }

    public String toString() {
        return "ServerConnector[id=" + this.getId() + " index=" + this._port.getIndex() + " address=" + this._port.getAddress() + ":" + this._port.getPort() + " cluster=" + this._cluster.getId() + "]";
    }
}

