/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.cluster;

import com.caucho.management.server.AbstractManagedObject;
import com.caucho.management.server.ClusterMXBean;
import com.caucho.management.server.ServerConnectorMXBean;
import com.caucho.server.cluster.ServerConnector;
import java.util.Date;

public class ServerConnectorAdmin
extends AbstractManagedObject
implements ServerConnectorMXBean {
    private final ServerConnector _client;

    public ServerConnectorAdmin(ServerConnector client) {
        this._client = client;
    }

    public String getName() {
        return this._client.getId();
    }

    public String getType() {
        return "ServerConnector";
    }

    public ClusterMXBean getCluster() {
        return this._client.getCluster().getAdmin();
    }

    public int getClusterIndex() {
        return this._client.getIndex();
    }

    public String getAddress() {
        return this._client.getAddress();
    }

    public int getPort() {
        return this._client.getPort();
    }

    public long getRecoverTime() {
        return this._client.getLoadBalanceRecoverTime();
    }

    public long getIdleTime() {
        return this._client.getLoadBalanceIdleTime();
    }

    public long getConnectTimeout() {
        return this._client.getLoadBalanceConnectTimeout();
    }

    public long getSocketTimeout() {
        return this._client.getLoadBalanceSocketTimeout();
    }

    public long getWarmupTime() {
        return this._client.getLoadBalanceWarmupTime();
    }

    public int getWeight() {
        return this._client.getLoadBalanceWeight();
    }

    public String getState() {
        return this._client.getState();
    }

    public int getConnectionActiveCount() {
        return this._client.getActiveCount();
    }

    public int getConnectionIdleCount() {
        return this._client.getIdleCount();
    }

    public long getConnectionNewCountTotal() {
        return this._client.getConnectCountTotal();
    }

    public long getConnectionFailCountTotal() {
        return this._client.getFailCountTotal();
    }

    public Date getLastFailTime() {
        return this._client.getLastFailTime();
    }

    public Date getLastSuccessTime() {
        return new Date(this._client.getLastSuccessTime());
    }

    public double getLatencyFactor() {
        return this._client.getLatencyFactor();
    }

    public long getConnectionBusyCountTotal() {
        return this._client.getBusyCountTotal();
    }

    public Date getLastBusyTime() {
        return this._client.getLastBusyTime();
    }

    public long getConnectionKeepaliveCountTotal() {
        return this._client.getKeepaliveCountTotal();
    }

    public double getServerCpuLoadAvg() {
        return this._client.getCpuLoadAvg();
    }

    public void start() {
        this._client.start();
    }

    public void stop() {
        this._client.stop();
    }

    public void enableSessionOnly() {
        this._client.enableSessionOnly();
    }

    public boolean ping() {
        return this._client.canConnect();
    }

    protected void register() {
        this.registerSelf();
    }

    public String toString() {
        return "ClusterClientAdmin[" + this.getObjectName() + "]";
    }
}

