/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.cluster;

import com.caucho.log.Log;
import com.caucho.server.cluster.ClusterObject;
import com.caucho.server.cluster.ObjectManager;
import com.caucho.server.cluster.StoreManager;
import com.caucho.util.L10N;
import java.util.logging.Logger;

public class Store {
    protected static final Logger log = Log.open(Store.class);
    static final L10N L = new L10N(Store.class);
    private StoreManager _storeManager;
    private ObjectManager _objectManager;
    private String _storeId;
    private long _maxIdleTime;
    private boolean _isAlwaysLoad;
    private boolean _isAlwaysSave;

    Store(String storeId, StoreManager storeManager) {
        this._storeId = Store.mangleId(storeId);
        this._storeManager = storeManager;
        this._maxIdleTime = storeManager.getMaxIdleTime();
        this._isAlwaysLoad = this._storeManager.isAlwaysLoad();
        this._isAlwaysSave = this._storeManager.isAlwaysSave();
    }

    public String getId() {
        return this._storeId;
    }

    public long getMaxIdleTime() {
        return this._maxIdleTime;
    }

    public void setMaxIdleTime(long maxIdleTime) {
        this._maxIdleTime = maxIdleTime;
        this._storeManager.updateIdleCheckInterval(maxIdleTime);
    }

    public long getAccessWindowTime() {
        long window = this._maxIdleTime / 4L;
        if (window < 60000L) {
            return 60000L;
        }
        return window;
    }

    public boolean isAlwaysLoad() {
        return this._isAlwaysLoad;
    }

    public void setAlwaysLoad(boolean isAlwaysLoad) {
        this._isAlwaysLoad = isAlwaysLoad;
    }

    public void setAlwaysSave(boolean isAlwaysSave) {
        this._isAlwaysSave = isAlwaysSave;
    }

    public boolean isAlwaysSave() {
        return this._isAlwaysSave;
    }

    public ObjectManager getObjectManager() {
        return this._objectManager;
    }

    public void setObjectManager(ObjectManager obj) {
        this._objectManager = obj;
    }

    public StoreManager getStoreManager() {
        return this._storeManager;
    }

    public ClusterObject createClusterObject(String objectId) {
        return this._storeManager.createClusterObject(this, objectId);
    }

    public void access(String objectId) throws Exception {
        this._storeManager.access(this, objectId);
    }

    public void remove(String objectId) throws Exception {
        this._storeManager.remove(this, objectId);
    }

    void notifyRemove(String objectId) throws Exception {
        if (this._objectManager != null) {
            this._objectManager.notifyRemove(objectId);
        }
    }

    private static String mangleId(String id) {
        StringBuilder cb = new StringBuilder();
        for (int i = 0; i < id.length(); ++i) {
            char ch = id.charAt(i);
            if (ch == '/') {
                cb.append("__");
                continue;
            }
            if (ch == ':') {
                cb.append("_0");
                continue;
            }
            if (ch == '_') {
                cb.append("_1");
                continue;
            }
            cb.append(ch);
        }
        return cb.toString();
    }
}

