/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.cluster;

import com.caucho.config.types.Period;
import com.caucho.lifecycle.Lifecycle;
import com.caucho.loader.ClassLoaderListener;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.loader.Environment;
import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.loader.EnvironmentListener;
import com.caucho.management.server.PersistentStoreMXBean;
import com.caucho.server.cluster.Cluster;
import com.caucho.server.cluster.ClusterObject;
import com.caucho.server.cluster.ClusterServer;
import com.caucho.server.cluster.ClusterStream;
import com.caucho.server.cluster.ObjectManager;
import com.caucho.server.cluster.ServerConnector;
import com.caucho.server.cluster.Store;
import com.caucho.util.Alarm;
import com.caucho.util.AlarmListener;
import com.caucho.util.L10N;
import com.caucho.util.LruCache;
import com.caucho.vfs.TempStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;

public abstract class StoreManager
implements AlarmListener,
EnvironmentListener,
ClassLoaderListener {
    protected static final Logger log = Logger.getLogger(StoreManager.class.getName());
    static final L10N L = new L10N(StoreManager.class);
    private static int[] DECODE = new int[128];
    private Cluster _cluster;
    private String _serverId;
    protected int _selfIndex;
    private ServerConnector[] _serverList;
    private Alarm _alarm;
    protected long _maxIdleTime = 10800000L;
    protected long _idleCheckInterval = 300000L;
    protected boolean _isAlwaysLoad;
    protected boolean _isAlwaysSave;
    protected HashMap<String, Store> _storeMap;
    protected LruCache<String, ClusterObject> _clusterObjects;
    private final Lifecycle _lifecycle = new Lifecycle(log, this.toString());
    protected volatile long _loadCount;
    protected volatile long _loadFailCount;
    protected volatile long _saveCount;
    protected volatile long _saveFailCount;

    protected StoreManager() {
        this._clusterObjects = new LruCache(4096);
        this._clusterObjects.setEnableListeners(false);
        this._storeMap = new HashMap();
        this._alarm = new Alarm((AlarmListener)this);
        Environment.addClassLoaderListener(this);
    }

    public void setCluster(Cluster cluster) {
        this._cluster = cluster;
    }

    public Cluster getCluster() {
        return this._cluster;
    }

    public PersistentStoreMXBean getAdmin() {
        return null;
    }

    public void setAlwaysLoad(boolean alwaysLoad) {
        this._isAlwaysLoad = alwaysLoad;
    }

    public boolean isAlwaysLoad() {
        return this._isAlwaysLoad;
    }

    public void setAlwaysSave(boolean alwaysSave) {
        this._isAlwaysSave = alwaysSave;
    }

    public boolean isAlwaysSave() {
        return this._isAlwaysSave;
    }

    public long getMaxIdleTime() {
        return this._maxIdleTime;
    }

    public void setMaxIdleTime(Period maxIdleTime) {
        this._maxIdleTime = maxIdleTime.getPeriod();
    }

    public void updateIdleCheckInterval(long idleCheckInterval) {
        if (this._idleCheckInterval > 0L && idleCheckInterval > 0L && idleCheckInterval < this._idleCheckInterval) {
            this._idleCheckInterval = idleCheckInterval;
            this._alarm.queue(idleCheckInterval);
        }
        if (this._idleCheckInterval >= 0L && this._idleCheckInterval < 1000L) {
            this._idleCheckInterval = 1000L;
        }
    }

    public long getIdleCheckTime() {
        if (this._idleCheckInterval > 0L) {
            return this._idleCheckInterval;
        }
        return this._maxIdleTime;
    }

    public long getAccessWindowTime() {
        long window = this._maxIdleTime / 4L;
        if (window < 60000L) {
            return 60000L;
        }
        return window;
    }

    public long getObjectCount() {
        return -1L;
    }

    public long getLoadCount() {
        return this._loadCount;
    }

    public long getLoadFailCount() {
        return this._loadFailCount;
    }

    public long getSaveCount() {
        return this._saveCount;
    }

    public long getSaveFailCount() {
        return this._saveFailCount;
    }

    public Store createStore(String storeId, ObjectManager objectManager) {
        Store store = this.getStore(storeId);
        store.setObjectManager(objectManager);
        return store;
    }

    public Store removeStore(String storeId) {
        Store store = this.getStore(storeId);
        store.setObjectManager(null);
        return store;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Store getStore(String storeId) {
        HashMap<String, Store> hashMap = this._storeMap;
        synchronized (hashMap) {
            Store store = this._storeMap.get(storeId);
            if (store == null) {
                store = new Store(storeId, this);
                this._storeMap.put(storeId, store);
            }
            return store;
        }
    }

    @PostConstruct
    public boolean init() throws Exception {
        if (!this._lifecycle.toInit()) {
            return false;
        }
        this._lifecycle.setName(this.toString());
        if (this._cluster == null) {
            this._cluster = Cluster.getLocal();
        }
        if (this._cluster != null) {
            this._serverId = Cluster.getServerId();
            ClusterServer selfServer = this._cluster.getSelfServer();
            if (selfServer != null) {
                this._selfIndex = selfServer.getIndex();
            } else if (this._cluster.getServerList().length > 1) {
                log.warning(L.l("cluster-store for '{0}' needs an <srun> configuration for it.", (Object)this._serverId));
            }
            ClusterServer[] serverList = this._cluster.getServerList();
            this._serverList = new ServerConnector[serverList.length];
            for (int i = 0; i < serverList.length; ++i) {
                this._serverList[i] = serverList[i].getServerConnector();
            }
        }
        Environment.addEnvironmentListener(this);
        return true;
    }

    public boolean start() throws Exception {
        if (!this._lifecycle.toActive()) {
            return false;
        }
        if (this._serverList != null) {
            ServerConnector[] serverList = this._serverList;
            for (int i = 0; i < serverList.length; ++i) {
                ServerConnector server = serverList[i];
                if (server == null) continue;
                try {
                    ClusterStream s = server.open();
                    s.close();
                    continue;
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }
        }
        this.handleAlarm(this._alarm);
        return true;
    }

    public void clearOldObjects() throws Exception {
    }

    protected boolean isPrimary(String id) {
        return this.getPrimaryIndex(id, 0) == this.getSelfIndex();
    }

    public int getPrimaryIndex(String id, int offset) {
        return 0;
    }

    public int getSecondaryIndex(String id, int offset) {
        return 0;
    }

    public int getTertiaryIndex(String id, int offset) {
        return 0;
    }

    protected abstract boolean load(ClusterObject var1, Object var2) throws Exception;

    public void access(String uniqueId) throws Exception {
        ClusterObject obj = this.getClusterObject(uniqueId);
        if (obj != null) {
            obj.access();
        } else {
            this.accessImpl(obj.getObjectId(), uniqueId);
        }
    }

    public void access(Store store, String id) throws Exception {
        this.getClusterObject(store, id).access();
    }

    public abstract void accessImpl(String var1, String var2) throws Exception;

    public void setExpireInterval(String uniqueId, long expires) throws Exception {
    }

    public void update(String storeId, String objectId) throws Exception {
        ClusterObject obj = this.getClusterObject(storeId, objectId);
        if (obj != null) {
            obj.update();
        }
    }

    public void updateOwner(String objectId, String uniqueId) throws Exception {
    }

    public void store(Store store, String id, Object obj) throws IOException {
        ClusterObject clusterObj = this.getClusterObject(store, id);
        if (clusterObj == null) {
            if (store.getObjectManager().isEmpty(obj)) {
                return;
            }
            clusterObj = this.createClusterObject(store, id);
        }
        clusterObj.store(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ClusterObject createClusterObject(Store store, String id) {
        try {
            String uniqueId = store.getId() + ';' + id;
            StoreManager storeManager = this;
            synchronized (storeManager) {
                ClusterObject clusterObj = (ClusterObject)this._clusterObjects.get((Object)uniqueId);
                if (clusterObj == null) {
                    clusterObj = this.create(store, id);
                    this._clusterObjects.put((Object)clusterObj.getUniqueId(), (Object)clusterObj);
                }
                return clusterObj;
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
            return null;
        }
    }

    ClusterObject getClusterObject(Store store, String id) {
        return this.getClusterObject(this.makeUniqueId(store, id));
    }

    ClusterObject getClusterObject(String storeId, String id) {
        return this.getClusterObject(this.makeUniqueId(storeId, id));
    }

    ClusterObject getClusterObject(String uniqueId) {
        return (ClusterObject)this._clusterObjects.get((Object)uniqueId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ClusterObject removeClusterObject(String storeId, String id) {
        StoreManager storeManager = this;
        synchronized (storeManager) {
            return (ClusterObject)this._clusterObjects.remove((Object)this.makeUniqueId(storeId, id));
        }
    }

    ClusterObject create(Store store, String id) {
        return new ClusterObject(this, store, id);
    }

    protected abstract void store(ClusterObject var1, TempStream var2, long var3) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handleAlarm(Alarm alarm) {
        if (!this._lifecycle.isActive()) {
            return;
        }
        try {
            try {
                this.clearOldObjects();
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString(), e);
                Object var4_3 = null;
                this._alarm.queue(this.getIdleCheckTime());
                return;
            }
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this._alarm.queue(this.getIdleCheckTime());
            throw throwable;
        }
        this._alarm.queue(this.getIdleCheckTime());
    }

    public void remove(ClusterObject obj) throws Exception {
    }

    public void remove(Store store, String objectId) throws Exception {
    }

    private String makeUniqueId(Store store, String objectId) {
        return store.getId() + ';' + objectId;
    }

    private String makeUniqueId(String storeId, String objectId) {
        return storeId + ';' + objectId;
    }

    protected int getSelfIndex() {
        return this._selfIndex;
    }

    protected ServerConnector[] getServerList() {
        return this._serverList;
    }

    protected ServerConnector getOwningServer(String objectId) {
        if (this._cluster == null) {
            return null;
        }
        char ch = objectId.charAt(0);
        ServerConnector[] serverList = this._serverList;
        if (serverList.length > 0) {
            int srunIndex = StoreManager.decode(ch) % serverList.length;
            return serverList[srunIndex];
        }
        return null;
    }

    public void environmentBind(EnvironmentClassLoader loader) {
    }

    public void environmentStart(EnvironmentClassLoader loader) {
        try {
            this.start();
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    public void environmentStop(EnvironmentClassLoader loader) {
    }

    public void classLoaderInit(DynamicClassLoader loader) {
    }

    public void classLoaderDestroy(DynamicClassLoader loader) {
        this.destroy();
    }

    public void destroy() {
        if (!this._lifecycle.toDestroy()) {
            return;
        }
        this._alarm.dequeue();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._serverId + "]";
    }

    static int decode(int code) {
        return DECODE[code & 0x7F];
    }

    private static char convert(long code) {
        if ((code &= 0x3FL) < 26L) {
            return (char)(97L + code);
        }
        if (code < 52L) {
            return (char)(65L + code - 26L);
        }
        if (code < 62L) {
            return (char)(48L + code - 52L);
        }
        if (code == 62L) {
            return '_';
        }
        return '-';
    }

    static {
        for (int i = 0; i < 64; ++i) {
            StoreManager.DECODE[StoreManager.convert((long)((long)i))] = i;
        }
    }

    static class ObjectKey {
        private String _storeId;
        private String _objectId;

        ObjectKey() {
        }

        ObjectKey(String storeId, String objectId) {
            this.init(storeId, objectId);
        }

        void init(String storeId, String objectId) {
            this._storeId = storeId;
            this._objectId = objectId;
        }

        public int hashCode() {
            return this._storeId.hashCode() * 65521 + this._objectId.hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ObjectKey)) {
                return false;
            }
            ObjectKey key = (ObjectKey)o;
            return this._objectId.equals(key._objectId) && this._storeId.equals(key._storeId);
        }
    }
}

