/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.connection;

import com.caucho.i18n.CharacterEncoding;
import com.caucho.security.SecurityContext;
import com.caucho.security.SecurityContextProvider;
import com.caucho.server.connection.AbstractHttpResponse;
import com.caucho.server.connection.CauchoRequest;
import com.caucho.server.connection.CauchoResponse;
import com.caucho.server.connection.Connection;
import com.caucho.server.connection.ConnectionController;
import com.caucho.server.connection.Form;
import com.caucho.server.connection.MultipartForm;
import com.caucho.server.connection.ScopeRemoveListener;
import com.caucho.server.connection.ServletInputStreamImpl;
import com.caucho.server.dispatch.DispatchServer;
import com.caucho.server.dispatch.Invocation;
import com.caucho.server.port.TcpConnection;
import com.caucho.server.security.AbstractLogin;
import com.caucho.server.session.SessionImpl;
import com.caucho.server.session.SessionManager;
import com.caucho.server.webapp.WebApp;
import com.caucho.util.Alarm;
import com.caucho.util.CaseInsensitiveIntMap;
import com.caucho.util.CharBuffer;
import com.caucho.util.CharSegment;
import com.caucho.util.HashMapImpl;
import com.caucho.util.L10N;
import com.caucho.util.NullEnumeration;
import com.caucho.util.QDate;
import com.caucho.util.StringCharCursor;
import com.caucho.vfs.BufferedReaderAdapter;
import com.caucho.vfs.Encoding;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.nio.charset.UnsupportedCharsetException;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestAttributeEvent;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractHttpRequest
implements CauchoRequest,
SecurityContextProvider {
    protected static final Logger log;
    static final L10N L;
    protected static final CaseInsensitiveIntMap _headerCodes;
    public static final String REQUEST_URI = "javax.servlet.include.request_uri";
    public static final String CONTEXT_PATH = "javax.servlet.include.context_path";
    public static final String SERVLET_PATH = "javax.servlet.include.servlet_path";
    public static final String PATH_INFO = "javax.servlet.include.path_info";
    public static final String QUERY_STRING = "javax.servlet.include.query_string";
    public static final String STATUS_CODE = "javax.servlet.error.status_code";
    public static final String EXCEPTION_TYPE = "javax.servlet.error.exception_type";
    public static final String MESSAGE = "javax.servlet.error.message";
    public static final String EXCEPTION = "javax.servlet.error.exception";
    public static final String ERROR_URI = "javax.servlet.error.request_uri";
    public static final String SERVLET_NAME = "javax.servlet.error.servlet_name";
    public static final String JSP_EXCEPTION = "javax.servlet.jsp.jspException";
    public static final String SHUTDOWN = "com.caucho.shutdown";
    private static final String CHAR_ENCODING = "resin.form.character.encoding";
    private static final String FORM_LOCALE = "resin.form.local";
    private static final String CAUCHO_CHAR_ENCODING = "caucho.form.character.encoding";
    private static final char[] CONNECTION;
    private static final char[] COOKIE;
    private static final char[] EXPECT;
    private static final char[] HOST;
    private static final char[] CONTINUE_100;
    private static final char[] CLOSE;
    private static final boolean[] TOKEN;
    private static final boolean[] VALUE;
    private static final ServletRequestAttributeListener[] NULL_LISTENERS;
    private static final Cookie[] NULL_COOKIES;
    protected final DispatchServer _server;
    protected final Connection _conn;
    protected final TcpConnection _tcpConn;
    protected AbstractHttpResponse _response;
    protected Invocation _invocation;
    private String _runAs;
    private boolean _keepalive;
    protected CharSegment _hostHeader;
    protected boolean _expect100Continue;
    private Cookie[] _cookiesIn;
    private ArrayList<Cookie> _cookies = new ArrayList();
    private boolean _varyCookies;
    private String _varyCookie;
    private boolean _hasCookie;
    private boolean _isSessionIdFromCookie;
    protected int _sessionGroup;
    private boolean _sessionIsLoaded;
    private SessionImpl _session;
    protected final ReadStream _rawRead;
    protected final ReadStream _readStream;
    protected boolean _hasReadStream;
    private final ServletInputStreamImpl _is = new ServletInputStreamImpl();
    private String _readEncoding;
    private final BufferedReaderAdapter _bufferedReader;
    private boolean _hasReader;
    private boolean _hasInputStream;
    private SecurityContextProvider _oldProvider;
    private final Form _formParser = new Form();
    private final HashMapImpl<String, String[]> _form = new HashMapImpl();
    private HashMapImpl<String, String[]> _filledForm;
    private final HashMapImpl<String, Object> _attributes = new HashMapImpl();
    private ArrayList<Locale> _locales = new ArrayList();
    private long _startTime;
    private ArrayList<Path> _closeOnExit = new ArrayList();
    protected final QDate _calendar = new QDate();
    private final CharBuffer _cbName = new CharBuffer();
    private final CharBuffer _cbValue = new CharBuffer();
    protected final CharBuffer _cb = new CharBuffer();
    private final byte[] _address = new byte[256];
    private final byte[] _logBuffer = new byte[8192];
    private ServletRequestAttributeListener[] _attributeListeners;

    protected AbstractHttpRequest(DispatchServer server, Connection conn) {
        this._server = server;
        this._conn = conn;
        this._rawRead = conn != null ? conn.getReadStream() : null;
        this._tcpConn = conn instanceof TcpConnection ? (TcpConnection)conn : null;
        this._readStream = new ReadStream();
        this._readStream.setReuseBuffer(true);
        this._bufferedReader = new BufferedReaderAdapter(this._readStream);
    }

    public void init() {
    }

    public final Connection getConnection() {
        return this._conn;
    }

    public final DispatchServer getDispatchServer() {
        return this._server;
    }

    protected void start() throws IOException {
        this.resume();
        this._invocation = null;
        this._varyCookies = false;
        this._varyCookie = null;
        this._hasCookie = false;
        this._hostHeader = null;
        this._expect100Continue = false;
        this._cookiesIn = null;
        this._cookies.clear();
        this._sessionGroup = -1;
        this._session = null;
        this._sessionIsLoaded = false;
        this._hasReadStream = false;
        this._hasReader = false;
        this._hasInputStream = false;
        this._filledForm = null;
        this._locales.clear();
        this._readEncoding = null;
        this._keepalive = true;
        this._isSessionIdFromCookie = false;
        this._runAs = null;
        this._attributeListeners = NULL_LISTENERS;
        if (this._attributes.size() > 0) {
            this._attributes.clear();
        }
    }

    protected void startInvocation() throws IOException {
        this._oldProvider = SecurityContext.setProvider(this);
    }

    protected void finishInvocation() throws IOException {
        SecurityContextProvider oldProvider = this._oldProvider;
        this._oldProvider = null;
        SecurityContext.setProvider(oldProvider);
    }

    protected void resume() throws IOException {
        this._startTime = Alarm.getCurrentTime();
        if (this._tcpConn != null) {
            this._tcpConn.beginActive();
        }
    }

    public boolean isIgnoreClientDisconnect() {
        Invocation invocation = this._invocation;
        if (invocation == null) {
            return true;
        }
        WebApp webApp = invocation.getWebApp();
        if (webApp != null) {
            return webApp.isIgnoreClientDisconnect();
        }
        return true;
    }

    public CauchoResponse getResponse() {
        return this._response;
    }

    public String getServerName() {
        int p;
        CharSequence rawHost;
        String host = this._conn.getVirtualHost();
        if (host == null && (rawHost = this.getHost()) != null) {
            if (rawHost instanceof CharSegment) {
                CharSegment cb = (CharSegment)rawHost;
                char[] buffer = cb.getBuffer();
                int offset = cb.getOffset();
                int length = cb.getLength();
                for (int i = length - 1; i >= 0; --i) {
                    char ch = buffer[i + offset];
                    if ('A' > ch || ch > 'Z') continue;
                    buffer[i + offset] = (char)(ch + 97 - 65);
                }
                host = new String(buffer, offset, length);
            } else {
                return ((Object)rawHost).toString().toLowerCase();
            }
        }
        if (host == null) {
            InetAddress addr = this._conn.getLocalAddress();
            return addr.getHostName();
        }
        int p1 = host.lastIndexOf(47);
        if (p1 < 0) {
            p1 = 0;
        }
        if ((p = host.lastIndexOf(58)) >= 0 && p1 < p) {
            return host.substring(p1, p);
        }
        return host;
    }

    protected CharSequence getHost() {
        return null;
    }

    public int getServerPort() {
        CharSequence rawHost;
        String host = this._conn.getVirtualHost();
        if (host == null && (rawHost = this.getHost()) != null) {
            int length = rawHost.length();
            for (int i = length - 1; i >= 0; --i) {
                if (rawHost.charAt(i) != ':') continue;
                int port = 0;
                ++i;
                while (i < length) {
                    char ch = rawHost.charAt(i);
                    if ('0' <= ch && ch <= '9') {
                        port = 10 * port + ch - 48;
                    }
                    ++i;
                }
                return port;
            }
            return this.isSecure() ? 443 : 80;
        }
        if (host == null) {
            return this._conn.getLocalPort();
        }
        int p1 = host.lastIndexOf(58);
        if (p1 < 0) {
            return this.isSecure() ? 443 : 80;
        }
        int length = host.length();
        int port = 0;
        for (int i = p1 + 1; i < length; ++i) {
            char ch = host.charAt(i);
            if ('0' > ch || ch > '9') continue;
            port = 10 * port + ch - 48;
        }
        return port;
    }

    public int getLocalPort() {
        return this._conn.getLocalPort();
    }

    public String getLocalAddr() {
        return this._conn.getLocalAddress().getHostAddress();
    }

    public String getLocalName() {
        return this._conn.getLocalAddress().getHostAddress();
    }

    public String getRemoteAddr() {
        return this._conn.getRemoteHost();
    }

    public int printRemoteAddr(byte[] buffer, int offset) throws IOException {
        int len = this._conn.getRemoteAddress(buffer, offset, buffer.length - offset);
        return offset + len;
    }

    public String getRemoteHost() {
        return this._conn.getRemoteHost();
    }

    public int getRemotePort() {
        return this._conn.getRemotePort();
    }

    public String getScheme() {
        return this.isSecure() ? "https" : "http";
    }

    public abstract String getProtocol();

    public abstract String getMethod();

    public String getRequestURI() {
        if (this._invocation != null) {
            return this._invocation.getRawURI();
        }
        return "";
    }

    @Override
    public String getPageURI() {
        return this._invocation.getRawURI();
    }

    public abstract byte[] getUriBuffer();

    public abstract int getUriLength();

    public String getContextPath() {
        return this._invocation.getContextPath();
    }

    @Override
    public String getPageContextPath() {
        return this.getContextPath();
    }

    public String getServletPath() {
        return this._invocation.getServletPath();
    }

    @Override
    public String getPageServletPath() {
        return this._invocation.getServletPath();
    }

    public String getPathInfo() {
        return this._invocation.getPathInfo();
    }

    @Override
    public String getPagePathInfo() {
        return this._invocation.getPathInfo();
    }

    public StringBuffer getRequestURL() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getScheme());
        sb.append("://");
        sb.append(this.getServerName());
        int port = this.getServerPort();
        if (port > 0 && port != 80 && port != 443) {
            sb.append(":");
            sb.append(port);
        }
        sb.append(this.getRequestURI());
        return sb;
    }

    public String getRealPath(String path) {
        int p;
        if (path == null) {
            return null;
        }
        if (path.length() > 0 && path.charAt(0) == '/') {
            return this._invocation.getWebApp().getRealPath(path);
        }
        String uri = this.getPageURI();
        String context = this.getPageContextPath();
        if (context != null) {
            uri = uri.substring(context.length());
        }
        if ((p = uri.lastIndexOf(47)) >= 0) {
            path = uri.substring(0, p + 1) + path;
        }
        return this._invocation.getWebApp().getRealPath(path);
    }

    public String getPathTranslated() {
        String pathInfo = this.getPathInfo();
        if (pathInfo == null) {
            return null;
        }
        return this.getRealPath(pathInfo);
    }

    public String getQueryString() {
        if (this._invocation != null) {
            return this._invocation.getQueryString();
        }
        return null;
    }

    @Override
    public String getPageQueryString() {
        return this.getQueryString();
    }

    public abstract String getHeader(String var1);

    public int getHeaderSize() {
        return -1;
    }

    public CharSegment getHeaderKey(int index) {
        throw new UnsupportedOperationException();
    }

    public CharSegment getHeaderValue(int index) {
        throw new UnsupportedOperationException();
    }

    public CharSegment getHeaderBuffer(String name) {
        String value = this.getHeader(name);
        if (value != null) {
            return new CharBuffer(value);
        }
        return null;
    }

    public abstract Enumeration getHeaderNames();

    @Override
    public void setHeader(String key, String value) {
    }

    protected boolean addHeaderInt(char[] keyBuf, int keyOff, int keyLen, CharSegment value) {
        if (keyLen < 4) {
            return true;
        }
        char key1 = keyBuf[keyOff];
        switch (key1) {
            case 'C': 
            case 'c': {
                if (keyLen == CONNECTION.length && this.match(keyBuf, keyOff, keyLen, CONNECTION)) {
                    if (this.match(value.getBuffer(), value.getOffset(), value.length(), CLOSE)) {
                        this.connectionClose();
                    }
                } else if (keyLen == COOKIE.length && this.match(keyBuf, keyOff, keyLen, COOKIE)) {
                    this.fillCookie(this._cookies, value);
                }
                return true;
            }
            case 'E': 
            case 'e': {
                if (this.match(keyBuf, keyOff, keyLen, EXPECT) && this.match(value.getBuffer(), value.getOffset(), value.length(), CONTINUE_100)) {
                    this._expect100Continue = true;
                    return false;
                }
                return true;
            }
            case 'H': 
            case 'h': {
                if (this.match(keyBuf, keyOff, keyLen, HOST)) {
                    this._hostHeader = value;
                }
                return true;
            }
        }
        return true;
    }

    protected void connectionClose() {
        this.killKeepalive();
    }

    private boolean match(char[] a, int aOff, int aLength, char[] b) {
        int bLength = b.length;
        if (aLength != bLength) {
            return false;
        }
        for (int i = aLength - 1; i >= 0; --i) {
            char chA = a[aOff + i];
            char chB = b[i];
            if (chA == chB || chA + 97 - 65 == chB) continue;
            return false;
        }
        return true;
    }

    public Enumeration getHeaders(String name) {
        String value = this.getHeader(name);
        if (value == null) {
            return NullEnumeration.create();
        }
        ArrayList<String> list = new ArrayList<String>();
        list.add(value);
        return Collections.enumeration(list);
    }

    public void getHeaderBuffers(String name, ArrayList<CharSegment> resultList) {
        String value = this.getHeader(name);
        if (value != null) {
            resultList.add((CharSegment)new CharBuffer(value));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getIntHeader(String key) {
        CharSegment value = this.getHeaderBuffer(key);
        if (value == null) {
            return -1;
        }
        int len = value.length();
        if (len == 0) {
            throw new NumberFormatException(value.toString());
        }
        int iValue = 0;
        int i = 0;
        char ch = value.charAt(i);
        int sign = 1;
        if (ch == '+') {
            if (i + 1 >= len) throw new NumberFormatException(value.toString());
            ch = value.charAt(++i);
        } else if (ch == '-') {
            sign = -1;
            if (i + 1 >= len) throw new NumberFormatException(value.toString());
            ch = value.charAt(++i);
        }
        while (i < len && (ch = value.charAt(i)) >= '0' && ch <= '9') {
            iValue = 10 * iValue + ch - 48;
            ++i;
        }
        if (i >= len) return sign * iValue;
        throw new NumberFormatException(value.toString());
    }

    public long getDateHeader(String key) {
        String value = this.getHeader(key);
        if (value == null) {
            return -1L;
        }
        long date = -1L;
        try {
            date = this._calendar.parseDate(value);
            if (date == Long.MAX_VALUE) {
                throw new IllegalArgumentException("getDateHeader(" + value + ")");
            }
            return date;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public int getContentLength() {
        char ch;
        int i;
        CharSegment cl = this.getHeaderBuffer("Content-Length");
        if (cl == null) {
            return -1;
        }
        int value = 0;
        int length = cl.length();
        for (i = 0; i < length && (ch = cl.charAt(i)) >= '0' && ch <= '9'; ++i) {
            value = 10 * value + ch - 48;
        }
        return i == 0 ? -1 : value;
    }

    public long getLongContentLength() {
        char ch;
        int i;
        CharSegment cl = this.getHeaderBuffer("Content-Length");
        if (cl == null) {
            return -1L;
        }
        long value = 0L;
        int length = cl.length();
        for (i = 0; i < length && (ch = cl.charAt(i)) >= '0' && ch <= '9'; ++i) {
            value = 10L * value + (long)ch - 48L;
        }
        return i == 0 ? -1L : value;
    }

    public String getContentType() {
        return this.getHeader("Content-Type");
    }

    public CharSegment getContentTypeBuffer() {
        return this.getHeaderBuffer("Content-Type");
    }

    public String getCharacterEncoding() {
        int tail;
        if (this._readEncoding != null) {
            return this._readEncoding;
        }
        CharSegment value = this.getHeaderBuffer("Content-Type");
        if (value == null) {
            return null;
        }
        int i = value.indexOf("charset");
        if (i < 0) {
            return null;
        }
        int len = value.length();
        i += 7;
        while (i < len && Character.isWhitespace(value.charAt(i))) {
            ++i;
        }
        if (i >= len || value.charAt(i) != '=') {
            return null;
        }
        ++i;
        while (i < len && Character.isWhitespace(value.charAt(i))) {
            ++i;
        }
        if (i >= len) {
            return null;
        }
        char end = value.charAt(i);
        if (end == '\"') {
            int tail2;
            for (tail2 = ++i; tail2 < len && value.charAt(tail2) != end; ++tail2) {
            }
            this._readEncoding = Encoding.getMimeName((String)value.substring(i, tail2));
            return this._readEncoding;
        }
        for (tail = i; tail < len && !Character.isWhitespace(value.charAt(tail)) && value.charAt(tail) != ';'; ++tail) {
        }
        this._readEncoding = Encoding.getMimeName((String)value.substring(i, tail));
        return this._readEncoding;
    }

    public void setCharacterEncoding(String encoding) throws UnsupportedEncodingException {
        this._readEncoding = encoding;
        try {
            this.getStream(true).setEncoding(this._readEncoding);
        }
        catch (UnsupportedEncodingException e) {
            throw e;
        }
        catch (UnsupportedCharsetException e) {
            throw new UnsupportedEncodingException(e.getMessage());
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
        }
    }

    public Cookie[] getCookies() {
        this.setVaryCookie(null);
        if (this._cookiesIn == null) {
            this.fillCookies();
        }
        if (this._cookiesIn != null && this._cookiesIn.length > 0) {
            this.setHasCookie();
        }
        if (this._cookiesIn == null || this._cookiesIn.length == 0) {
            return null;
        }
        return this._cookiesIn;
    }

    @Override
    public Cookie getCookie(String name) {
        this.setVaryCookie(name);
        return this.findCookie(name);
    }

    private Cookie findCookie(String name) {
        if (this._cookiesIn == null) {
            this.fillCookies();
        }
        if (this._cookiesIn == null) {
            return null;
        }
        for (Cookie cookie : this._cookiesIn) {
            if (!cookie.getName().equals(name)) continue;
            this.setHasCookie();
            return cookie;
        }
        return null;
    }

    private void fillCookies() {
        int size = this._cookies.size();
        if (size > 0) {
            this._cookiesIn = new Cookie[this._cookies.size()];
            this._cookies.toArray(this._cookiesIn);
        } else {
            this._cookiesIn = NULL_COOKIES;
        }
    }

    private void fillCookie(ArrayList cookies, CharSegment rawCookie) {
        char[] buf = rawCookie.getBuffer();
        int j = rawCookie.getOffset();
        int end = j + rawCookie.length();
        int version = 0;
        Cookie cookie = null;
        while (j < end) {
            char ch = '\u0000';
            CharBuffer cbName = this._cbName;
            CharBuffer cbValue = this._cbValue;
            cbName.clear();
            cbValue.clear();
            while (j < end && ((ch = buf[j]) == ' ' || ch == ';' || ch == ',')) {
                ++j;
            }
            if (end <= j) break;
            boolean isSpecial = false;
            if (buf[j] == '$') {
                isSpecial = true;
                ++j;
            }
            while (j < end && (ch = buf[j]) < '\u0080' && TOKEN[ch]) {
                cbName.append(ch);
                ++j;
            }
            while (j < end && (ch = buf[j]) == ' ') {
                ++j;
            }
            if (end <= j) break;
            if (ch == ';' || ch == ',') {
                try {
                    cookie = new Cookie(cbName.toString(), "");
                    cookie.setVersion(version);
                    this._cookies.add(cookie);
                }
                catch (Exception e) {
                    log.log(Level.FINE, e.toString(), e);
                }
                continue;
            }
            if (ch != '=') {
                while (j < end && (ch = buf[j]) != ';') {
                    ++j;
                }
                continue;
            }
            ++j;
            while (j < end && (ch = buf[j]) == ' ') {
                ++j;
            }
            if (ch == '\"') {
                ++j;
                while (j < end && (ch = buf[j]) != '\"') {
                    cbValue.append(ch);
                    ++j;
                }
                ++j;
            } else {
                while (j < end && (ch = buf[j]) < '\u0080' && VALUE[ch]) {
                    cbValue.append(ch);
                    ++j;
                }
            }
            if (!isSpecial) {
                if (cbName.length() == 0) {
                    log.warning("bad cookie: " + rawCookie);
                    continue;
                }
                cookie = new Cookie(cbName.toString(), cbValue.toString());
                cookie.setVersion(version);
                this._cookies.add(cookie);
                continue;
            }
            if (cookie == null) {
                if (!cbName.matchesIgnoreCase("Version")) continue;
                version = cbValue.charAt(0) - 48;
                continue;
            }
            if (cbName.matchesIgnoreCase("Version")) {
                cookie.setVersion(cbValue.charAt(0) - 48);
                continue;
            }
            if (cbName.matchesIgnoreCase("Domain")) {
                cookie.setDomain(cbValue.toString());
                continue;
            }
            if (!cbName.matchesIgnoreCase("Path")) continue;
            cookie.setPath(cbValue.toString());
        }
    }

    @Override
    public void setVaryCookie(String cookie) {
        if (!this._varyCookies) {
            this._varyCookie = cookie;
        } else if (this._varyCookie != null && !this._varyCookie.equals(cookie)) {
            this._varyCookie = null;
        }
        this._varyCookies = true;
    }

    @Override
    public boolean getVaryCookies() {
        return this._varyCookies;
    }

    @Override
    public String getVaryCookie() {
        return this._varyCookie;
    }

    @Override
    public void setHasCookie() {
        this._hasCookie = true;
    }

    @Override
    public boolean getHasCookie() {
        if (this._hasCookie) {
            return true;
        }
        if (this._invocation != null) {
            return this._invocation.getSessionId() != null;
        }
        return false;
    }

    @Override
    public HttpSession getMemorySession() {
        if (this._session != null && this._session.isValid()) {
            return this._session;
        }
        return null;
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public HttpSession getSession(boolean create) {
        if (this._session != null) {
            if (this._session.isValid()) {
                return this._session;
            }
        } else if (!create && this._sessionIsLoaded) {
            return null;
        }
        this._sessionIsLoaded = true;
        boolean hasOldSession = this._session != null;
        this._session = this.createSession(create, hasOldSession);
        return this._session;
    }

    public HttpSession getLoadedSession() {
        if (this._session != null && this._session.isValid()) {
            return this._session;
        }
        return null;
    }

    public boolean isRequestedSessionIdValid() {
        String id = this.getRequestedSessionId();
        if (id == null) {
            return false;
        }
        SessionImpl session = (SessionImpl)this.getSession(false);
        return session != null && session.isValid() && session.getId().equals(id);
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this.findSessionIdFromCookie() != null;
    }

    public boolean isRequestedSessionIdFromURL() {
        return this.findSessionIdFromUrl() != null;
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this.isRequestedSessionIdFromURL();
    }

    public String getRequestedSessionIdNoVary() {
        boolean varyCookies = this._varyCookies;
        String varyCookie = this._varyCookie;
        boolean hasCookie = this._hasCookie;
        boolean privateCache = this._response.getPrivateCache();
        String id = this.getRequestedSessionId();
        this._varyCookies = varyCookies;
        this._varyCookie = varyCookie;
        this._hasCookie = hasCookie;
        this._response.setPrivateOrResinCache(privateCache);
        return id;
    }

    public String getRequestedSessionId() {
        String id;
        SessionManager manager = this.getSessionManager();
        Object cookieName = null;
        if (manager != null && manager.enableSessionCookies()) {
            this.setVaryCookie(this.getSessionCookie(manager));
            id = this.findSessionIdFromCookie();
            if (id != null) {
                this._isSessionIdFromCookie = true;
                this.setHasCookie();
                return id;
            }
        }
        if ((id = this.findSessionIdFromUrl()) != null) {
            return id;
        }
        if (manager != null && manager.enableSessionCookies()) {
            return null;
        }
        return this.findSessionIdFromConnection();
    }

    public String findSessionIdFromConnection() {
        return null;
    }

    private String findSessionIdFromCookie() {
        SessionManager manager = this.getSessionManager();
        if (manager == null || !manager.enableSessionCookies()) {
            return null;
        }
        Cookie cookie = this.findCookie(this.getSessionCookie(manager));
        if (cookie != null) {
            this._isSessionIdFromCookie = true;
            return cookie.getValue();
        }
        return null;
    }

    private String findSessionIdFromUrl() {
        String id;
        String string = id = this._invocation != null ? this._invocation.getSessionId() : null;
        if (id != null) {
            this.setHasCookie();
        }
        return id;
    }

    public int getSessionGroup() {
        return this._sessionGroup;
    }

    private SessionImpl createSession(boolean create, boolean hasOldSession) {
        SessionImpl session;
        SessionManager manager = this.getSessionManager();
        if (manager == null) {
            return null;
        }
        String id = this.getRequestedSessionId();
        long now = Alarm.getCurrentTime();
        if (id != null && id.length() > 6) {
            session = manager.getSession(id, now, create, this._isSessionIdFromCookie);
            if (session != null && session.isValid()) {
                if (session != null) {
                    this.setVaryCookie(this.getSessionCookie(manager));
                    this.setHasCookie();
                }
                if (!session.getId().equals(id) && manager.enableSessionCookies()) {
                    this.getResponse().setSessionId(session.getId());
                }
                return session;
            }
        } else {
            id = null;
        }
        if (!create) {
            return null;
        }
        session = manager.createSession(id, now, this, this._isSessionIdFromCookie);
        if (session != null) {
            this.setHasCookie();
        }
        if (session.getId().equals(id)) {
            return session;
        }
        if (manager.enableSessionCookies()) {
            this.getResponse().setSessionId(session.getId());
        }
        return session;
    }

    protected final SessionManager getSessionManager() {
        WebApp webApp = this.getWebApp();
        if (webApp != null) {
            return webApp.getSessionManager();
        }
        return null;
    }

    protected final String getSessionCookie(SessionManager manager) {
        if (this.isSecure()) {
            return manager.getSSLCookieName();
        }
        return manager.getCookieName();
    }

    public String getAuthType() {
        Object login = this.getAttribute("com.caucho.servlet.login.name");
        if (login instanceof X509Certificate) {
            return "CLIENT_CERT";
        }
        WebApp app = this.getWebApp();
        if (app != null && app.getLogin() != null && this.getUserPrincipal() != null) {
            return app.getLogin().getAuthType();
        }
        return null;
    }

    public String getRemoteUser(boolean create) {
        if (this._session == null) {
            return null;
        }
        Principal user = this._session.getUser();
        if (user == null) {
            if (!create) {
                return null;
            }
            user = this.getUserPrincipal();
        }
        if (user != null) {
            return user.getName();
        }
        return null;
    }

    @Override
    public boolean authenticate() throws ServletException, IOException {
        Principal user = null;
        if (this._session == null) {
            this.getSession(false);
        }
        if (this._session != null && (user = this._session.getUser()) != null) {
            return true;
        }
        WebApp app = this.getWebApp();
        if (app == null) {
            this._response.sendError(403);
            return false;
        }
        AbstractLogin login = app.getLogin();
        if (login != null) {
            user = login.authenticate(this, this.getResponse(), app);
            if (user == null) {
                return false;
            }
            if (this._session == null) {
                this.getSession(true);
            }
            this._session.setUser(user);
        }
        if (user != null) {
            return true;
        }
        this._response.sendError(403);
        return false;
    }

    public String getRemoteUser() {
        Principal principal = this.getUserPrincipal();
        if (principal != null) {
            return principal.getName();
        }
        return null;
    }

    @Override
    public Principal getUserPrincipal() {
        try {
            Principal user = (Principal)this.getAttribute("com.caucho.servlet.login.name");
            if (user != null) {
                return user;
            }
            if (this._session == null) {
                this.getSession(false);
            }
            if (this._session != null && (user = this._session.getUser()) != null) {
                return user;
            }
            WebApp app = this.getWebApp();
            if (app == null) {
                return null;
            }
            AbstractLogin login = app.getLogin();
            if (login != null && (user = login.getUserPrincipal(this, this.getResponse(), app)) != null) {
                this.getSession(true);
                this._session.setUser(user);
                this._response.setPrivateCache(true);
            }
            return user;
        }
        catch (ServletException e) {
            log.log(Level.WARNING, e.toString(), e);
            return null;
        }
    }

    @Override
    public void logout() {
        if (this._session != null) {
            this._session.logout();
        }
    }

    public void logoutUserPrincipal() {
        if (this._session != null) {
            this._session.logout();
        }
    }

    @Override
    public String runAs(String role) {
        String oldRunAs = this._runAs;
        this._runAs = role;
        return oldRunAs;
    }

    @Override
    public boolean isUserInRole(String role) {
        AbstractLogin login;
        String linkRole;
        HashMap<String, String> roleMap = this._invocation.getSecurityRoleMap();
        if (roleMap != null && (linkRole = roleMap.get(role)) != null) {
            role = linkRole;
        }
        if (this._runAs != null) {
            return this._runAs.equals(role);
        }
        WebApp app = this.getWebApp();
        AbstractLogin abstractLogin = login = app == null ? null : app.getLogin();
        if (login == null) {
            return false;
        }
        boolean inRole = false;
        Principal user = this.getUserPrincipal();
        try {
            inRole = login.isUserInRole(this, this.getResponse(), app, user, role);
        }
        catch (ServletException e) {
            if (app != null) {
                app.log(String.valueOf((Object)e), e);
            }
            log.log(Level.FINE, e.toString(), e);
        }
        if (log.isLoggable(Level.FINE)) {
            if (user == null) {
                log.fine("no user for isUserInRole");
            } else if (inRole) {
                log.fine(user + " is in role: " + role);
            } else {
                log.fine("failed " + user + " in role: " + role);
            }
        }
        return inRole;
    }

    @Override
    public boolean isTransportSecure() {
        return this._conn.isSecure();
    }

    @Override
    public ReadStream getStream() throws IOException {
        return this.getStream(true);
    }

    public ReadStream getStream(boolean isReader) throws IOException {
        if (!this._hasReadStream) {
            this._hasReadStream = true;
            this.initStream(this._readStream, this._rawRead);
            if (isReader) {
                String charEncoding = this.getCharacterEncoding();
                String javaEncoding = Encoding.getJavaName((String)charEncoding);
                this._readStream.setEncoding(javaEncoding);
            }
            if (this._expect100Continue) {
                this._expect100Continue = false;
                this._response.writeContinue();
            }
        }
        return this._readStream;
    }

    public byte[] getRawReadBuffer() {
        return this._rawRead.getBuffer();
    }

    protected void skip() throws IOException {
        if (!this._hasReadStream) {
            if (!this.initStream(this._readStream, this._rawRead)) {
                return;
            }
            this._hasReadStream = true;
        }
        while (this._readStream.skip(8192L) > 0L) {
        }
    }

    protected abstract boolean initStream(ReadStream var1, ReadStream var2) throws IOException;

    public ReadStream getRawInput() {
        throw new UnsupportedOperationException(L.l("raw mode is not supported in this configuration"));
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this._hasReader) {
            throw new IllegalStateException(L.l("getInputStream() can't be called after getReader()"));
        }
        this._hasInputStream = true;
        ReadStream stream = this.getStream(false);
        this._is.init((InputStream)stream);
        return this._is;
    }

    public BufferedReader getReader() throws IOException {
        if (this._hasInputStream) {
            throw new IllegalStateException(L.l("getReader() can't be called after getInputStream()"));
        }
        this._hasReader = true;
        try {
            this._bufferedReader.init(this.getStream(true));
            return this._bufferedReader;
        }
        catch (UnsupportedCharsetException e) {
            throw new UnsupportedEncodingException(e.getMessage());
        }
    }

    public Enumeration<String> getParameterNames() {
        if (this._filledForm == null) {
            this._filledForm = this.parseQuery();
        }
        return Collections.enumeration(this._filledForm.keySet());
    }

    public Map<String, String[]> getParameterMap() {
        if (this._filledForm == null) {
            this._filledForm = this.parseQuery();
        }
        return Collections.unmodifiableMap(this._filledForm);
    }

    public String[] getParameterValues(String name) {
        if (this._filledForm == null) {
            this._filledForm = this.parseQuery();
        }
        return (String[])this._filledForm.get((Object)name);
    }

    public String getParameter(String name) {
        String[] values = this.getParameterValues(name);
        if (values == null || values.length == 0) {
            return null;
        }
        return values[0];
    }

    private HashMapImpl<String, String[]> parseQuery() {
        block23: {
            try {
                Locale locale;
                this._form.clear();
                String query = this.getQueryString();
                CharSegment contentType = this.getContentTypeBuffer();
                if (query == null && contentType == null) {
                    return this._form;
                }
                String charEncoding = this.getCharacterEncoding();
                if (charEncoding == null) {
                    charEncoding = (String)this.getAttribute(CAUCHO_CHAR_ENCODING);
                }
                if (charEncoding == null) {
                    charEncoding = (String)this.getAttribute(CHAR_ENCODING);
                }
                if (charEncoding == null && (locale = (Locale)this.getAttribute(FORM_LOCALE)) != null) {
                    charEncoding = Encoding.getMimeName((Locale)locale);
                }
                if (query != null) {
                    String queryEncoding = charEncoding;
                    if (queryEncoding == null && this._server != null) {
                        queryEncoding = this._server.getURLCharacterEncoding();
                    }
                    if (queryEncoding == null) {
                        queryEncoding = CharacterEncoding.getLocalEncoding();
                    }
                    String javaEncoding = Encoding.getJavaName((String)queryEncoding);
                    this._formParser.parseQueryString(this._form, query, javaEncoding, true);
                }
                if (charEncoding == null) {
                    charEncoding = CharacterEncoding.getLocalEncoding();
                }
                String javaEncoding = Encoding.getJavaName((String)charEncoding);
                if (contentType == null || !"POST".equalsIgnoreCase(this.getMethod())) break block23;
                if (contentType.startsWith("application/x-www-form-urlencoded")) {
                    this._formParser.parsePostData(this._form, (InputStream)this.getInputStream(), javaEncoding);
                    break block23;
                }
                if (!this.getWebApp().doMultipartForm() || !contentType.startsWith("multipart/form-data")) break block23;
                int length = contentType.length();
                int i = contentType.indexOf("boundary=");
                if (i < 0) {
                    return this._form;
                }
                long formUploadMax = this.getWebApp().getFormUploadMax();
                Object uploadMax = this.getAttribute("caucho.multipart.form.upload-max");
                if (uploadMax instanceof Number) {
                    formUploadMax = ((Number)uploadMax).longValue();
                }
                if (formUploadMax >= 0L && formUploadMax < this.getLongContentLength()) {
                    this.setAttribute("caucho.multipart.form.error", L.l("Multipart form upload of '{0}' bytes was too large.", (Object)String.valueOf(this.getLongContentLength())));
                    this.setAttribute("caucho.multipart.form.error.size", new Long(this.getLongContentLength()));
                    return this._form;
                }
                char ch = contentType.charAt(i += "boundary=".length());
                CharBuffer boundary = new CharBuffer();
                if (ch == '\'') {
                    ++i;
                    while (i < length && contentType.charAt(i) != '\'') {
                        boundary.append(contentType.charAt(i));
                        ++i;
                    }
                } else if (ch == '\"') {
                    ++i;
                    while (i < length && contentType.charAt(i) != '\"') {
                        boundary.append(contentType.charAt(i));
                        ++i;
                    }
                } else {
                    while (i < length && (ch = contentType.charAt(i)) != ' ' && ch != ';') {
                        boundary.append(ch);
                        ++i;
                    }
                }
                try {
                    MultipartForm.parsePostData(this._form, this.getStream(false), boundary.toString(), this, javaEncoding, formUploadMax);
                }
                catch (IOException e) {
                    log.log(Level.FINE, e.toString(), e);
                    this.setAttribute("caucho.multipart.form.error", e.getMessage());
                }
            }
            catch (IOException e) {
                log.log(Level.FINE, e.toString(), e);
            }
        }
        return this._form;
    }

    public Enumeration<String> getAttributeNames() {
        return Collections.enumeration(this._attributes.keySet());
    }

    public Object getAttribute(String name) {
        return this._attributes.get((Object)name);
    }

    public void setAttribute(String name, Object value) {
        if (value != null) {
            Object oldValue = this._attributes.put((Object)name, value);
            for (int i = 0; i < this._attributeListeners.length; ++i) {
                ServletRequestAttributeEvent event;
                if (oldValue != null) {
                    event = new ServletRequestAttributeEvent((ServletContext)this.getWebApp(), (ServletRequest)this, name, oldValue);
                    this._attributeListeners[i].attributeReplaced(event);
                    continue;
                }
                event = new ServletRequestAttributeEvent((ServletContext)this.getWebApp(), (ServletRequest)this, name, value);
                this._attributeListeners[i].attributeAdded(event);
            }
        } else {
            this.removeAttribute(name);
        }
    }

    public void removeAttribute(String name) {
        Object oldValue = this._attributes.remove((Object)name);
        for (int i = 0; i < this._attributeListeners.length; ++i) {
            ServletRequestAttributeEvent event = new ServletRequestAttributeEvent((ServletContext)this.getWebApp(), (ServletRequest)this, name, oldValue);
            this._attributeListeners[i].attributeRemoved(event);
        }
        if (oldValue instanceof ScopeRemoveListener) {
            ((ScopeRemoveListener)oldValue).removeEvent(this, name);
        }
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        int p;
        String pathInfo;
        if (path == null || path.length() == 0) {
            return null;
        }
        if (path.charAt(0) == '/') {
            return this.getWebApp().getRequestDispatcher(path);
        }
        CharBuffer cb = new CharBuffer();
        WebApp app = this.getWebApp();
        String servletPath = this.getPageServletPath();
        if (servletPath != null) {
            cb.append(servletPath);
        }
        if ((pathInfo = this.getPagePathInfo()) != null) {
            cb.append(pathInfo);
        }
        if ((p = cb.lastIndexOf('/')) >= 0) {
            cb.setLength(p);
        }
        cb.append('/');
        cb.append(path);
        if (app != null) {
            return app.getRequestDispatcher(cb.toString());
        }
        return app.getRequestDispatcher(cb.toString());
    }

    public Locale getLocale() {
        this.fillLocales();
        return this._locales.get(0);
    }

    public Enumeration<Locale> getLocales() {
        this.fillLocales();
        return Collections.enumeration(this._locales);
    }

    private void fillLocales() {
        if (this._locales.size() > 0) {
            return;
        }
        Enumeration headers = this.getHeaders("Accept-Language");
        if (headers == null) {
            this._locales.add(Locale.getDefault());
            return;
        }
        CharBuffer cb = this._cb;
        block0: while (headers.hasMoreElements()) {
            String header = (String)headers.nextElement();
            StringCharCursor cursor = new StringCharCursor((CharSequence)header);
            while (true) {
                char ch;
                if (cursor.current() == '\uffff') continue block0;
                while (Character.isWhitespace(cursor.current())) {
                    cursor.next();
                }
                cb.clear();
                while ((ch = cursor.current()) >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '0') {
                    cb.append(cursor.current());
                    cursor.next();
                }
                String language = cb.toString();
                String country = "";
                String var = "";
                if (cursor.current() == '_' || cursor.current() == '-') {
                    cb.clear();
                    cursor.next();
                    while ((ch = cursor.current()) >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9') {
                        cb.append(cursor.current());
                        cursor.next();
                    }
                    country = cb.toString();
                }
                if (language.length() > 0) {
                    Locale locale = new Locale(language, country);
                    this._locales.add(locale);
                }
                while (true) {
                    if (cursor.current() == '\uffff' || cursor.current() == ',') break;
                    cursor.next();
                }
                cursor.next();
            }
        }
        if (this._locales.size() == 0) {
            this._locales.add(Locale.getDefault());
        }
    }

    public boolean isSecure() {
        return this._conn.isSecure();
    }

    public final Invocation getInvocation() {
        return this._invocation;
    }

    public final void setInvocation(Invocation invocation) {
        this._invocation = invocation;
        WebApp app = invocation.getWebApp();
        if (app != null) {
            this._attributeListeners = app.getRequestAttributeListeners();
        }
    }

    protected final void setStartTime() {
        this._startTime = Alarm.getExactTime();
    }

    public final long getStartTime() {
        return this._startTime;
    }

    public String getServletName() {
        return this._invocation.getServletName();
    }

    @Override
    public final WebApp getWebApp() {
        if (this._invocation != null) {
            return this._invocation.getWebApp();
        }
        return null;
    }

    public final byte[] getLogBuffer() {
        return this._logBuffer;
    }

    @Override
    public boolean isTop() {
        return false;
    }

    public void addCloseOnExit(Path path) {
        this._closeOnExit.add(path);
    }

    @Override
    public int getRequestDepth(int depth) {
        return depth + 1;
    }

    public int getRequestDepth() {
        return 0;
    }

    public boolean handleResume() throws IOException {
        return false;
    }

    @Override
    public void killKeepalive() {
        this._keepalive = false;
    }

    protected boolean isKeepalive() {
        return this._keepalive;
    }

    @Override
    public boolean allowKeepalive() {
        if (!this._keepalive) {
            return false;
        }
        TcpConnection tcpConn = this._tcpConn;
        if (tcpConn == null) {
            return true;
        }
        if (this._tcpConn.getController() != null) {
            this._keepalive = false;
            return this._keepalive;
        }
        if (!tcpConn.allowKeepalive()) {
            this._keepalive = false;
        }
        return this._keepalive;
    }

    protected void restartServer() throws IOException, ServletException {
        CauchoResponse res = this.getResponse();
        res.sendError(503);
        this._server.update();
    }

    void saveSession() {
        SessionImpl session = this._session;
        if (session != null) {
            session.save();
        }
    }

    public void finishSession() throws IOException {
        SessionImpl session = this._session;
        if (session != null) {
            session.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() throws IOException {
        try {
            SessionImpl session = this._session;
            Connection conn = this.getConnection();
            if (conn.getController() == null) {
                this._invocation = null;
            }
            if (session != null) {
                session.finish();
            }
            this.cleanup();
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            for (int i = this._closeOnExit.size() - 1; i >= 0; --i) {
                Path path = this._closeOnExit.get(i);
                try {
                    path.remove();
                    continue;
                }
                catch (Throwable e) {
                    log.log(Level.FINE, e.toString(), e);
                }
            }
            this._closeOnExit.clear();
            if (this._tcpConn != null) {
                this._tcpConn.endActive();
            }
            throw throwable;
        }
        for (int i = this._closeOnExit.size() - 1; i >= 0; --i) {
            Path path = this._closeOnExit.get(i);
            try {
                path.remove();
                continue;
            }
            catch (Throwable e) {
                log.log(Level.FINE, e.toString(), e);
            }
        }
        this._closeOnExit.clear();
        if (this._tcpConn != null) {
            this._tcpConn.endActive();
        }
    }

    public void cleanup() {
        ConnectionController comet = this.getConnection().getController();
        if (comet == null) {
            this._session = null;
            if (this._attributes.size() > 0) {
                for (Map.Entry entry : this._attributes.entrySet()) {
                    Object value = entry.getValue();
                    if (!(value instanceof ScopeRemoveListener)) continue;
                    ((ScopeRemoveListener)value).removeEvent(this, (String)entry.getKey());
                }
                this._attributes.clear();
            }
            this._cookiesIn = null;
            this._cookies.clear();
        }
        if (this._form != null) {
            this._form.clear();
        }
        this._filledForm = null;
    }

    protected String dbgId() {
        return "Tcp[" + this._conn.getId() + "] ";
    }

    static {
        int i;
        log = Logger.getLogger(AbstractHttpRequest.class.getName());
        L = new L10N(AbstractHttpRequest.class);
        CONNECTION = "connection".toCharArray();
        COOKIE = "cookie".toCharArray();
        EXPECT = "expect".toCharArray();
        HOST = "host".toCharArray();
        CONTINUE_100 = "100-continue".toCharArray();
        CLOSE = "close".toCharArray();
        NULL_LISTENERS = new ServletRequestAttributeListener[0];
        NULL_COOKIES = new Cookie[0];
        _headerCodes = new CaseInsensitiveIntMap();
        TOKEN = new boolean[256];
        VALUE = new boolean[256];
        for (i = 0; i < 256; ++i) {
            AbstractHttpRequest.TOKEN[i] = true;
        }
        for (i = 0; i < 32; ++i) {
            AbstractHttpRequest.TOKEN[i] = false;
        }
        for (i = 127; i < 256; ++i) {
            AbstractHttpRequest.TOKEN[i] = false;
        }
        AbstractHttpRequest.TOKEN[44] = false;
        AbstractHttpRequest.TOKEN[59] = false;
        AbstractHttpRequest.TOKEN[92] = false;
        AbstractHttpRequest.TOKEN[34] = false;
        AbstractHttpRequest.TOKEN[61] = false;
        AbstractHttpRequest.TOKEN[32] = false;
        System.arraycopy(TOKEN, 0, VALUE, 0, TOKEN.length);
        AbstractHttpRequest.VALUE[61] = true;
    }
}

