/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.connection;

import com.caucho.server.connection.BroadcastTask;
import com.caucho.server.connection.ConnectionController;
import com.caucho.util.L10N;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.WriteStream;
import java.net.InetAddress;

public abstract class Connection {
    private static final L10N L = new L10N(Connection.class);
    private final ReadStream _readStream = new ReadStream();
    private final WriteStream _writeStream;
    protected ConnectionController _controller;

    public Connection() {
        this._readStream.setReuseBuffer(true);
        this._writeStream = new WriteStream();
        this._writeStream.setReuseBuffer(true);
    }

    public abstract int getId();

    public final ReadStream getReadStream() {
        return this._readStream;
    }

    public final WriteStream getWriteStream() {
        return this._writeStream;
    }

    public boolean isSecure() {
        return false;
    }

    public String getVirtualHost() {
        return null;
    }

    public abstract InetAddress getLocalAddress();

    public abstract int getLocalPort();

    public abstract InetAddress getRemoteAddress();

    public String getRemoteHost() {
        return this.getRemoteAddress().getHostAddress();
    }

    public int getRemoteAddress(byte[] buffer, int offset, int length) {
        InetAddress remote = this.getRemoteAddress();
        String name = remote.getHostAddress();
        int len = name.length();
        for (int i = 0; i < len; ++i) {
            buffer[offset + i] = (byte)name.charAt(i);
        }
        return len;
    }

    public abstract int getRemotePort();

    public void sendBroadcast(BroadcastTask task) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setController(ConnectionController controller) {
        Connection connection = this;
        synchronized (connection) {
            if (this._controller != null) {
                throw new IllegalStateException(L.l("ConnectionController is already set."));
            }
            this._controller = controller;
        }
    }

    public ConnectionController getController() {
        return this._controller;
    }

    protected boolean wake() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeController(ConnectionController controller) {
        Connection connection = this;
        synchronized (connection) {
            if (this._controller == controller) {
                this._controller = null;
            } else {
                controller = null;
            }
        }
        if (controller != null) {
            this.closeControllerImpl();
        }
    }

    protected void closeControllerImpl() {
    }
}

