/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.connection;

import com.caucho.server.connection.Connection;
import java.util.logging.Logger;

public class ConnectionController {
    private static final Logger log = Logger.getLogger(ConnectionController.class.getName());
    private Connection _conn;
    private boolean _isTimeout;

    protected ConnectionController(Connection conn) {
        this._conn = conn;
        conn.setController(this);
    }

    public Connection getConnection() {
        return this._conn;
    }

    public final boolean wake() {
        Connection conn = this._conn;
        if (conn != null) {
            return conn.wake();
        }
        return false;
    }

    public boolean isDuplex() {
        return false;
    }

    public final void timeout() {
        this._isTimeout = true;
    }

    public final boolean isTimeout() {
        return this._isTimeout;
    }

    public final boolean isActive() {
        return this._conn != null && !this._isTimeout;
    }

    public final boolean isClosed() {
        return this._conn == null;
    }

    public void close() {
        Connection conn = this._conn;
        this._conn = null;
        if (conn != null) {
            conn.closeController(this);
        }
    }
}

