/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.connection;

import com.caucho.server.connection.AbstractHttpRequest;
import com.caucho.server.connection.ConnectionController;
import com.caucho.servlet.comet.CometController;
import com.caucho.util.Alarm;
import java.util.HashMap;
import javax.servlet.ServletRequest;

public class HttpConnectionController
extends ConnectionController
implements CometController {
    private AbstractHttpRequest _request;
    private HashMap<String, Object> _map = new HashMap(8);
    private long _maxIdleTime;

    public HttpConnectionController(ServletRequest request) {
        this(HttpConnectionController.getAbstractHttpRequest(request));
    }

    public HttpConnectionController(AbstractHttpRequest request) {
        super(request.getConnection());
        this._request = request;
    }

    private static AbstractHttpRequest getAbstractHttpRequest(ServletRequest request) {
        return (AbstractHttpRequest)request;
    }

    public void setMaxIdleTime(long idleTime) {
        if (idleTime < 0L || 0x3FFFFFFFFFFFFFFFL < idleTime) {
            this._maxIdleTime = 0x3FFFFFFFFFFFFFFFL;
        }
    }

    public long getMaxIdleTime() {
        return this._maxIdleTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAttribute(String name) {
        if (this._map != null) {
            HashMap<String, Object> hashMap = this._map;
            synchronized (hashMap) {
                return this._map.get(name);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(String name, Object value) {
        if (this._map != null) {
            HashMap<String, Object> hashMap = this._map;
            synchronized (hashMap) {
                this._map.put(name, value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAttribute(String name) {
        if (this._map != null) {
            HashMap<String, Object> hashMap = this._map;
            synchronized (hashMap) {
                this._map.remove(name);
            }
        }
    }

    public void close() {
        this._request = null;
        super.close();
    }

    public String toString() {
        AbstractHttpRequest request = this._request;
        if (request == null || request.getConnection() == null) {
            return "HttpConnectionController[closed]";
        }
        if (Alarm.isTest()) {
            return "HttpConnectionController[]";
        }
        return "HttpConectionController[" + request.getConnection().getId() + "]";
    }
}

