/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.connection;

import com.caucho.log.Log;
import com.caucho.server.connection.AbstractResponseStream;
import com.caucho.util.L10N;
import com.caucho.vfs.AbstractPrintWriter;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ResponseWriter
extends AbstractPrintWriter {
    static final Logger log = Log.open(ResponseWriter.class);
    static final L10N L = new L10N(ResponseWriter.class);
    private AbstractResponseStream _out;
    private boolean _hasError;

    public ResponseWriter() {
    }

    ResponseWriter(AbstractResponseStream out) {
        this._out = out;
    }

    public void init(AbstractResponseStream out) {
        this._out = out;
        this._hasError = false;
    }

    public int getBufferSize() {
        return this._out.getBufferSize();
    }

    public void setBufferSize(int size) {
        this._out.setBufferSize(size);
    }

    public int getRemaining() {
        return this._out.getRemaining();
    }

    public boolean checkError() {
        return this._hasError;
    }

    public void clearBuffer() {
        this._out.clearBuffer();
    }

    public final void write(int ch) {
        try {
            this._out.print(ch);
        }
        catch (IOException e) {
            this._hasError = true;
            log.log(Level.FINE, e.toString(), e);
        }
    }

    public final void write(char[] buf, int offset, int length) {
        try {
            this._out.print(buf, offset, length);
        }
        catch (IOException e) {
            this._hasError = true;
            log.log(Level.FINE, e.toString(), e);
        }
    }

    public final void write(String s, int off, int len) {
        try {
            char[] writeBuffer = this._out.getCharBuffer();
            int size = writeBuffer.length;
            int writeLength = this._out.getCharOffset();
            int end = off + len;
            while (off < end) {
                int sublen = end - off;
                if (size - writeLength < sublen) {
                    if (size == writeLength) {
                        writeBuffer = this._out.nextCharBuffer(writeLength);
                        writeLength = 0;
                        if (size < sublen) {
                            sublen = size;
                        }
                    } else {
                        sublen = size - writeLength;
                    }
                }
                int tail = off + sublen;
                s.getChars(off, tail, writeBuffer, writeLength);
                off = tail;
                writeLength += sublen;
            }
            this._out.setCharOffset(writeLength);
        }
        catch (IOException e) {
            this._hasError = true;
            log.log(Level.FINE, e.toString(), e);
        }
    }

    public void flush() {
        try {
            this._out.flushChar();
        }
        catch (IOException e) {
            this._hasError = true;
            log.log(Level.FINE, e.toString(), e);
        }
    }

    public void flushBuffer() {
        try {
            this._out.flushBuffer();
        }
        catch (IOException e) {
            this._hasError = true;
            log.log(Level.FINE, e.toString(), e);
        }
    }

    public void close() {
        this._hasError = false;
    }
}

