/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.connection;

import com.caucho.server.connection.AbstractHttpRequest;
import com.caucho.server.connection.ConnectionController;
import com.caucho.server.connection.TcpConnectionHandler;
import com.caucho.server.port.TcpConnection;
import com.caucho.util.Alarm;
import com.caucho.util.L10N;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.WriteStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletRequest;

public class TcpConnectionController
extends ConnectionController {
    private static final L10N L = new L10N(TcpConnectionController.class);
    private static final Logger log = Logger.getLogger(TcpConnectionController.class.getName());
    private ClassLoader _loader;
    private AbstractHttpRequest _request;
    private long _maxIdleTime;
    private ReadStream _is;
    private WriteStream _os;
    private TcpConnectionHandler _handler;
    private ReadTask _readTask = new ReadTask();
    private WriteTask _writeTask = new WriteTask();

    public TcpConnectionController(ServletRequest request, TcpConnectionHandler handler) {
        this(TcpConnectionController.getAbstractHttpRequest(request), handler);
    }

    public TcpConnectionController(AbstractHttpRequest request, TcpConnectionHandler handler) {
        super(request.getConnection());
        if (handler == null) {
            throw new NullPointerException(L.l("handler is a required argument"));
        }
        this._handler = handler;
        this._request = request;
        this._loader = Thread.currentThread().getContextClassLoader();
        this._is = this.getConnection().getReadStream();
        this._os = this.getConnection().getWriteStream();
    }

    private static AbstractHttpRequest getAbstractHttpRequest(ServletRequest request) {
        return (AbstractHttpRequest)request;
    }

    public boolean isDuplex() {
        return true;
    }

    public void setMaxIdleTime(long idleTime) {
        if (idleTime < 0L || 0x3FFFFFFFFFFFFFFFL < idleTime) {
            this._maxIdleTime = 0x3FFFFFFFFFFFFFFFL;
        }
    }

    public long getMaxIdleTime() {
        return this._maxIdleTime;
    }

    public Runnable getReadTask() {
        return this._readTask;
    }

    public Runnable getWriteTask() {
        return this._writeTask;
    }

    public TcpConnectionHandler getHandler() {
        return this._handler;
    }

    public void close() {
        this._request = null;
        this._is = null;
        this._os = null;
        this._readTask = null;
        this._writeTask = null;
        this._loader = null;
        super.close();
    }

    public String toString() {
        AbstractHttpRequest request = this._request;
        if (request == null || request.getConnection() == null) {
            return "TcpConnectionController[closed]";
        }
        if (Alarm.isTest()) {
            return "TcpConnectionController[" + this._handler + "]";
        }
        return "TcpConectionController[" + request.getConnection().getId() + "," + this._handler + "]";
    }

    class WriteTask
    implements Runnable {
        WriteTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            Thread thread = Thread.currentThread();
            boolean isValid = false;
            thread.setName("resin-" + TcpConnectionController.this._handler.getClass().getSimpleName() + "-write-" + TcpConnectionController.this.getConnection().getId());
            try {
                try {
                    thread.setContextClassLoader(TcpConnectionController.this._loader);
                    while (TcpConnectionController.this.isActive()) {
                        WriteStream os = TcpConnectionController.this._os;
                        if (!TcpConnectionController.this._handler.serviceWrite(os, TcpConnectionController.this)) {
                            Object var5_5 = null;
                            if (isValid) return;
                            TcpConnectionController.this.close();
                            return;
                        }
                        if (!((TcpConnection)TcpConnectionController.this.getConnection()).suspendWrite()) continue;
                        return;
                    }
                }
                catch (Exception e) {
                    log.log(Level.FINE, e.toString(), e);
                    Object var5_8 = null;
                    if (isValid) return;
                    TcpConnectionController.this.close();
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var5_9 = null;
                if (isValid) throw throwable;
                TcpConnectionController.this.close();
                throw throwable;
            }
            Object var5_7 = null;
            if (isValid) return;
            TcpConnectionController.this.close();
        }
    }

    class ReadTask
    implements Runnable {
        ReadTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            String oldName;
            boolean isValid;
            Thread thread;
            block12: {
                block11: {
                    block10: {
                        thread = Thread.currentThread();
                        isValid = false;
                        oldName = thread.getName();
                        try {
                            try {
                                thread.setName("resin-" + TcpConnectionController.this._handler.getClass().getSimpleName() + "-read-" + TcpConnectionController.this.getConnection().getId());
                                thread.setContextClassLoader(TcpConnectionController.this._loader);
                                while (TcpConnectionController.this.isActive()) {
                                    ReadStream is;
                                    TcpConnection conn;
                                    block14: {
                                        block13: {
                                            conn = (TcpConnection)TcpConnectionController.this.getConnection();
                                            is = TcpConnectionController.this._is;
                                            if (conn == null) break block13;
                                            if (is != null) break block14;
                                        }
                                        Object var7_7 = null;
                                        thread.setName(oldName);
                                        if (isValid) return;
                                        TcpConnectionController.this.close();
                                        return;
                                    }
                                    if (!conn.waitForKeepalive() && conn.waitForSelect()) {
                                        isValid = true;
                                        break block10;
                                    }
                                    if (TcpConnectionController.this._handler.serviceRead(is, TcpConnectionController.this)) continue;
                                    break block11;
                                }
                                break block12;
                            }
                            catch (Exception e) {
                                log.log(Level.FINE, e.toString(), e);
                                Object var7_11 = null;
                                thread.setName(oldName);
                                if (isValid) return;
                                TcpConnectionController.this.close();
                                return;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var7_12 = null;
                            thread.setName(oldName);
                            if (isValid) throw throwable;
                            TcpConnectionController.this.close();
                            throw throwable;
                        }
                    }
                    Object var7_8 = null;
                    thread.setName(oldName);
                    if (isValid) return;
                    TcpConnectionController.this.close();
                    return;
                }
                Object var7_9 = null;
                thread.setName(oldName);
                if (isValid) return;
                TcpConnectionController.this.close();
                return;
            }
            Object var7_10 = null;
            thread.setName(oldName);
            if (isValid) return;
            TcpConnectionController.this.close();
        }
    }
}

