/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.connection;

import com.caucho.log.Log;
import com.caucho.server.connection.AbstractHttpResponse;
import com.caucho.server.connection.AbstractResponseStream;
import com.caucho.util.L10N;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;

public class WrapperResponseStream
extends AbstractResponseStream {
    static final Logger log = Log.open(WrapperResponseStream.class);
    static final L10N L = new L10N(WrapperResponseStream.class);
    private static final int SIZE = 16384;
    private final byte[] _byteBuffer = new byte[16384];
    private final char[] _charBuffer = new char[16384];
    private HttpServletResponse _next;
    private ServletOutputStream _os;
    private PrintWriter _writer;

    public void init(HttpServletResponse next) {
        if (next == null) {
            throw new NullPointerException();
        }
        this._next = next;
        this._os = null;
        this._writer = null;
    }

    public boolean isCauchoResponseStream() {
        if (this._next instanceof AbstractHttpResponse) {
            return ((AbstractHttpResponse)this._next).isCauchoResponseStream();
        }
        return false;
    }

    public void setBufferSize(int size) {
        this._next.setBufferSize(size);
    }

    public int getBufferSize() {
        return this._next.getBufferSize();
    }

    public int getRemaining() {
        return 0;
    }

    public char[] getCharBuffer() {
        return this._charBuffer;
    }

    public int getCharOffset() {
        return 0;
    }

    public void setCharOffset(int offset) {
        if (offset > 0) {
            try {
                this.print(this._charBuffer, 0, offset);
            }
            catch (IOException e) {
                log.log(Level.FINE, e.toString(), e);
            }
        }
    }

    public char[] nextCharBuffer(int offset) throws IOException {
        if (offset > 0) {
            this.print(this._charBuffer, 0, offset);
        }
        return this._charBuffer;
    }

    public void print(int ch) throws IOException {
        if (this._writer == null) {
            if (this._next == null) {
                return;
            }
            this._writer = this._next.getWriter();
        }
        this._writer.write(ch);
    }

    public void print(char[] buffer, int offset, int length) throws IOException {
        if (length == 0) {
            return;
        }
        if (this._writer == null) {
            if (this._next == null) {
                return;
            }
            this._writer = this._next.getWriter();
        }
        this._writer.write(buffer, offset, length);
    }

    public int getBufferOffset() {
        return 0;
    }

    public void setBufferOffset(int offset) {
        if (offset > 0) {
            try {
                this.write(this._byteBuffer, 0, offset);
            }
            catch (IOException e) {
                log.log(Level.FINE, e.toString(), e);
            }
        }
    }

    public byte[] getBuffer() {
        return this._byteBuffer;
    }

    public byte[] nextBuffer(int offset) throws IOException {
        if (offset > 0) {
            this.write(this._byteBuffer, 0, offset);
        }
        return this._byteBuffer;
    }

    public void write(int ch) throws IOException {
        if (this._os == null) {
            if (this._next == null) {
                return;
            }
            this._os = this._next.getOutputStream();
        }
        this._os.write(ch);
    }

    public void write(byte[] buf, int offset, int length) throws IOException {
        if (length == 0) {
            return;
        }
        if (this._os == null) {
            if (this._next == null) {
                return;
            }
            this._os = this._next.getOutputStream();
        }
        this._os.write(buf, offset, length);
    }

    public void flushCharBuffer() throws IOException {
    }

    public void flushBuffer() throws IOException {
    }

    public void flushChar() throws IOException {
        if (this._writer == null) {
            if (this._next == null) {
                return;
            }
            this._writer = this._next.getWriter();
        }
        if (this._writer != null) {
            this._writer.flush();
        }
    }

    public void flushByte() throws IOException {
        if (this._os == null) {
            if (this._next == null) {
                return;
            }
            this._os = this._next.getOutputStream();
        }
        if (this._os != null) {
            this._os.flush();
        }
    }

    public void clearBuffer() {
        if (this._next != null) {
            this._next.resetBuffer();
        }
    }

    public void flush() throws IOException {
        if (this._writer != null) {
            this._writer.flush();
        }
        if (this._os != null) {
            this._os.flush();
        }
    }

    public void finish() throws IOException {
        this._next = null;
        this._os = null;
        this._writer = null;
    }

    public void close() throws IOException {
        PrintWriter writer = this._writer;
        this._writer = null;
        if (writer != null) {
            try {
                writer.close();
            }
            catch (Throwable e) {
                log.log(Level.FINER, e.toString(), e);
            }
        }
        ServletOutputStream os = this._os;
        this._os = null;
        if (os != null) {
            try {
                os.close();
            }
            catch (Throwable e) {
                log.log(Level.FINER, e.toString(), e);
            }
        }
        this._next = null;
    }
}

