/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.deploy;

import com.caucho.lifecycle.Lifecycle;
import com.caucho.loader.Environment;
import com.caucho.make.CachedDependency;
import com.caucho.server.deploy.DeployController;
import com.caucho.server.deploy.DeployGenerator;
import com.caucho.server.deploy.DeployListGenerator;
import com.caucho.util.L10N;
import com.caucho.vfs.Dependency;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeployContainer<C extends DeployController>
extends CachedDependency
implements Dependency {
    private static final L10N L = new L10N(DeployContainer.class);
    private static final Logger log = Logger.getLogger(DeployContainer.class.getName());
    private final DeployListGenerator<C> _deployListGenerator = new DeployListGenerator(this);
    private final ArrayList<C> _controllerList = new ArrayList();
    private final Lifecycle _lifecycle = new Lifecycle();

    public DeployContainer() {
        this.setCheckInterval(Environment.getDependencyCheckInterval());
    }

    public void add(DeployGenerator<C> generator) {
        TreeSet<String> names = new TreeSet<String>();
        generator.fillDeployedKeys(names);
        this._deployListGenerator.add(generator);
        if (this._lifecycle.isActive()) {
            this.update(names);
        }
    }

    public void remove(DeployGenerator<C> generator) {
        TreeSet<String> names = new TreeSet<String>();
        generator.fillDeployedKeys(names);
        this._deployListGenerator.remove(generator);
        if (this._lifecycle.isActive()) {
            this.update(names);
        }
    }

    @Override
    public boolean isModifiedImpl() {
        return this._deployListGenerator.isModified();
    }

    public boolean logModified(Logger log) {
        return this._deployListGenerator.logModified(log);
    }

    public void update() {
        this._deployListGenerator.update();
    }

    @PostConstruct
    public void init() {
        if (!this._lifecycle.toInit()) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void start() {
        void var3_6;
        ArrayList<C> controllerList;
        this.init();
        if (!this._lifecycle.toActive()) {
            return;
        }
        this._deployListGenerator.start();
        LinkedHashSet<String> keys = new LinkedHashSet<String>();
        this._deployListGenerator.fillDeployedKeys(keys);
        for (String string : keys) {
            this.startImpl(string);
        }
        ArrayList<C> arrayList = this._controllerList;
        synchronized (arrayList) {
            controllerList = new ArrayList<C>(this._controllerList);
            Collections.sort(controllerList, new StartupPriorityComparator());
        }
        boolean bl = false;
        while (var3_6 < controllerList.size()) {
            DeployController controller = (DeployController)controllerList.get((int)var3_6);
            controller.startOnInit();
            ++var3_6;
        }
    }

    public C findController(String name) {
        C controller = this.findDeployedController(name);
        if (controller != null) {
            return controller;
        }
        controller = this.generateController(name);
        if (controller == null) {
            return null;
        }
        if (((DeployController)controller).isNameMatch(name)) {
            return controller;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<C> getControllers() {
        ArrayList<C> list = new ArrayList<C>();
        ArrayList<C> arrayList = this._controllerList;
        synchronized (arrayList) {
            list.addAll(this._controllerList);
        }
        return list;
    }

    private void update(Set<String> names) {
        for (String name : names) {
            this.update(name);
        }
    }

    public C update(String name) {
        C newController = this.updateImpl(name);
        if (this._lifecycle.isActive() && newController != null) {
            ((DeployController)newController).startOnInit();
        }
        return newController;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    C updateImpl(String name) {
        DeployController oldController = null;
        ArrayList<C> arrayList = this._controllerList;
        synchronized (arrayList) {
            oldController = (DeployController)this.findDeployedController(name);
            if (oldController != null) {
                this._controllerList.remove(oldController);
            }
        }
        if (oldController != null) {
            oldController.destroy();
        }
        C newController = this.generateController(name);
        return newController;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private C startImpl(String name) {
        C oldController = null;
        ArrayList<C> arrayList = this._controllerList;
        synchronized (arrayList) {
            oldController = this.findDeployedController(name);
        }
        if (oldController != null) {
            return oldController;
        }
        return this.generateController(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String name) {
        DeployController oldController = null;
        ArrayList<C> arrayList = this._controllerList;
        synchronized (arrayList) {
            oldController = (DeployController)this.findDeployedController(name);
            if (oldController != null) {
                this._controllerList.remove(oldController);
            }
        }
        if (oldController != null) {
            oldController.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private C generateController(String name) {
        if (!this._lifecycle.isActive()) {
            return null;
        }
        C newController = this._deployListGenerator.generateController(name);
        if (newController == null) {
            return null;
        }
        ArrayList<C> arrayList = this._controllerList;
        synchronized (arrayList) {
            C controller = this.findDeployedController(((DeployController)newController).getId());
            if (controller != null) {
                return controller;
            }
            this._controllerList.add(newController);
        }
        this.init(newController);
        return newController;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(C controller) {
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(((DeployController)controller).getParentClassLoader());
            ((DeployController)controller).init();
            Object var5_4 = null;
            thread.setContextClassLoader(oldLoader);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            thread.setContextClassLoader(oldLoader);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private C findDeployedController(String name) {
        ArrayList<C> arrayList = this._controllerList;
        synchronized (arrayList) {
            for (int i = 0; i < this._controllerList.size(); ++i) {
                DeployController controller = (DeployController)this._controllerList.get(i);
                if (!controller.isNameMatch(name)) continue;
                return (C)controller;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        ArrayList<C> controllers;
        if (!this._lifecycle.toStop()) {
            return;
        }
        ArrayList<C> arrayList = this._controllerList;
        synchronized (arrayList) {
            controllers = new ArrayList<C>(this._controllerList);
            Collections.sort(controllers, new StartupPriorityComparator());
        }
        for (int i = controllers.size() - 1; i >= 0; --i) {
            ((DeployController)controllers.get(i)).stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        ArrayList<C> controllerList;
        this.stop();
        if (!this._lifecycle.toDestroy()) {
            return;
        }
        this._deployListGenerator.destroy();
        ArrayList<C> arrayList = this._controllerList;
        synchronized (arrayList) {
            controllerList = new ArrayList<C>(this._controllerList);
            this._controllerList.clear();
            Collections.sort(controllerList, new StartupPriorityComparator());
        }
        for (int i = controllerList.size() - 1; i >= 0; --i) {
            DeployController controller = (DeployController)controllerList.get(i);
            controller.destroy();
        }
    }

    public String toString() {
        return "DeployContainer$" + System.identityHashCode(this) + "[]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class StartupPriorityComparator
    implements Comparator<C> {
        @Override
        public int compare(C a, C b) {
            if (((DeployController)a).getStartupPriority() == ((DeployController)b).getStartupPriority()) {
                return 0;
            }
            if (((DeployController)a).getStartupPriority() < ((DeployController)b).getStartupPriority()) {
                return -1;
            }
            return 1;
        }
    }
}

