/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.deploy;

import com.caucho.config.ConfigException;
import com.caucho.config.types.Period;
import com.caucho.lifecycle.Lifecycle;
import com.caucho.lifecycle.LifecycleListener;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.server.deploy.DeployControllerAdmin;
import com.caucho.server.deploy.DeployControllerStrategy;
import com.caucho.server.deploy.DeployInstance;
import com.caucho.server.deploy.StartAutoRedeployAutoStrategy;
import com.caucho.server.deploy.StartAutoRedeployManualStrategy;
import com.caucho.server.deploy.StartLazyRedeployAutomaticStrategy;
import com.caucho.server.deploy.StartLazyRedeployManualStrategy;
import com.caucho.server.deploy.StartManualRedeployManualStrategy;
import com.caucho.util.Alarm;
import com.caucho.util.AlarmListener;
import com.caucho.util.L10N;
import com.caucho.util.WeakAlarm;
import com.caucho.vfs.Dependency;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DeployController<I extends DeployInstance>
implements Dependency,
AlarmListener {
    private static final Logger log = Logger.getLogger(DeployController.class.getName());
    private static final L10N L = new L10N(DeployController.class);
    public static final String STARTUP_DEFAULT = "default";
    public static final String STARTUP_AUTOMATIC = "automatic";
    public static final String STARTUP_LAZY = "lazy";
    public static final String STARTUP_MANUAL = "manual";
    public static final String REDEPLOY_DEFAULT = "default";
    public static final String REDEPLOY_AUTOMATIC = "automatic";
    public static final String REDEPLOY_LAZY = "lazy";
    public static final String REDEPLOY_MANUAL = "manual";
    public static final long REDEPLOY_CHECK_INTERVAL = 60000L;
    private ClassLoader _parentLoader;
    private String _id;
    private String _startupMode = "default";
    private String _redeployMode = "default";
    private int _startupPriority = Integer.MAX_VALUE;
    private DeployControllerStrategy _strategy;
    protected final Lifecycle _lifecycle;
    private Alarm _alarm = new WeakAlarm((AlarmListener)this);
    private long _redeployCheckInterval = 60000L;
    private long _startTime;
    private I _deployInstance;

    protected DeployController(String id) {
        this(id, null);
    }

    protected DeployController(String id, ClassLoader parentLoader) {
        this._id = id;
        if (parentLoader == null) {
            parentLoader = Thread.currentThread().getContextClassLoader();
        }
        this._parentLoader = parentLoader;
        this._lifecycle = new Lifecycle(this.getLog(), this.toString(), Level.FINEST);
    }

    public void addLifecycleListener(LifecycleListener listener) {
        this._lifecycle.addListener(listener);
    }

    public final String getId() {
        return this._id;
    }

    public ClassLoader getParentClassLoader() {
        return this._parentLoader;
    }

    public void setStartupMode(String mode) {
        try {
            this._startupMode = DeployController.toStartupCode(mode);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setStartupPriority(int priority) {
        this._startupPriority = priority;
    }

    public int getStartupPriority() {
        return this._startupPriority;
    }

    protected void mergeController(DeployController oldController) {
        this._parentLoader = oldController._parentLoader = this._parentLoader;
        if (oldController._startupPriority < this._startupPriority) {
            this._startupPriority = oldController._startupPriority;
        }
    }

    public void mergeStartupMode(String mode) {
        if (mode == null || "default".equals(mode)) {
            return;
        }
        this._startupMode = mode;
    }

    public String getStartupMode() {
        return this._startupMode;
    }

    public static String toStartupCode(String mode) throws ConfigException {
        if ("automatic".equals(mode)) {
            return "automatic";
        }
        if ("lazy".equals(mode)) {
            return "lazy";
        }
        if ("manual".equals(mode)) {
            return "manual";
        }
        throw new ConfigException(L.l("'{0}' is an unknown startup-mode.  'automatic', 'lazy', and 'manual' are the acceptable values.", (Object)mode));
    }

    public void setRedeployMode(String mode) {
        try {
            this._redeployMode = DeployController.toRedeployCode(mode);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void mergeRedeployMode(String mode) {
        if (mode == null || "default".equals(mode)) {
            return;
        }
        this._redeployMode = mode;
    }

    public String getRedeployMode() {
        return this._redeployMode;
    }

    public static String toRedeployCode(String mode) throws ConfigException {
        if ("automatic".equals(mode)) {
            return "automatic";
        }
        if ("lazy".equals(mode)) {
            return "lazy";
        }
        if ("manual".equals(mode)) {
            return "manual";
        }
        throw new ConfigException(L.l("'{0}' is an unknown redeploy-mode.  'automatic', 'lazy', and 'manual' are the acceptable values.", (Object)mode));
    }

    public void mergeRedeployCheckInterval(long interval) {
        if (interval != 60000L) {
            this._redeployCheckInterval = interval;
        }
    }

    public void setRedeployCheckInterval(Period period) {
        this._redeployCheckInterval = period.getPeriod();
        if (this._redeployCheckInterval < 0L) {
            this._redeployCheckInterval = 4611686018427387000L;
        }
        if (this._redeployCheckInterval < 5000L) {
            this._redeployCheckInterval = 5000L;
        }
    }

    public long getRedeployCheckInterval() {
        return this._redeployCheckInterval;
    }

    public boolean isNameMatch(String name) {
        return this.getId().equals(name);
    }

    public long getStartTime() {
        return this._startTime;
    }

    protected DeployControllerAdmin getDeployAdmin() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean init() {
        if (!this._lifecycle.toInitializing()) {
            return false;
        }
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this.getParentClassLoader());
            this.initBegin();
            if (this._startupMode == "manual") {
                if (this._redeployMode == "automatic") {
                    throw new IllegalStateException(L.l("startup='manual' and redeploy='automatic' is an unsupported combination."));
                }
                this._strategy = StartManualRedeployManualStrategy.create();
            } else {
                this._strategy = this._startupMode == "lazy" ? (this._redeployMode == "manual" ? StartLazyRedeployManualStrategy.create() : StartLazyRedeployAutomaticStrategy.create()) : (this._redeployMode == "manual" ? StartAutoRedeployManualStrategy.create() : StartAutoRedeployAutoStrategy.create());
            }
            this.initEnd();
            boolean bl = this._lifecycle.toInit();
            Object var5_4 = null;
            thread.setContextClassLoader(oldLoader);
            return bl;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            thread.setContextClassLoader(oldLoader);
            throw throwable;
        }
    }

    protected void initBegin() {
    }

    protected void initEnd() {
    }

    protected String getMBeanTypeName() {
        String className = this.getDeployInstance().getClass().getName();
        int p = className.lastIndexOf(46);
        if (p > 0) {
            className = className.substring(p + 1);
        }
        return className;
    }

    protected String getMBeanId() {
        String name = this.getId();
        if (name == null || name.equals("")) {
            name = "default";
        }
        return name;
    }

    public String getState() {
        if (this.isDestroyed()) {
            return "destroyed";
        }
        if (this.isStoppedLazy()) {
            return "stopped-lazy";
        }
        if (this.isStopped()) {
            return "stopped";
        }
        if (this.isError()) {
            return "error";
        }
        if (this.isModified()) {
            return "active-modified";
        }
        return "active";
    }

    public boolean isActive() {
        return this._lifecycle.isActive();
    }

    public boolean isStopped() {
        return this._lifecycle.isStopped() || this._lifecycle.isInit();
    }

    public boolean isStoppedLazy() {
        return this._lifecycle.isInit();
    }

    public boolean isActiveIdle() {
        I instance = this.getDeployInstance();
        if (!this._lifecycle.isActive()) {
            return false;
        }
        if (instance == null) {
            return false;
        }
        return instance.isDeployIdle();
    }

    public boolean isError() {
        if (this._lifecycle.isError()) {
            return true;
        }
        I instance = this.getDeployInstance();
        return instance != null && instance.getConfigException() != null;
    }

    public boolean isErrorNow() {
        if (this._lifecycle.isError()) {
            return true;
        }
        I instance = this.getDeployInstance();
        return instance != null && instance.getConfigException() != null;
    }

    public boolean isModified() {
        I instance = this.getDeployInstance();
        return instance == null || instance.isModified();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean logModified(Logger log) {
        I instance = this.getDeployInstance();
        if (instance != null) {
            Thread thread = Thread.currentThread();
            ClassLoader loader = thread.getContextClassLoader();
            try {
                thread.setContextClassLoader(instance.getClassLoader());
                boolean bl = instance.logModified(log);
                Object var7_6 = null;
                thread.setContextClassLoader(loader);
                return bl;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                thread.setContextClassLoader(loader);
                throw throwable;
            }
        }
        return false;
    }

    public boolean isModifiedNow() {
        I instance = this.getDeployInstance();
        return instance == null || instance.isModifiedNow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final I getDeployInstance() {
        DeployController deployController = this;
        synchronized (deployController) {
            if (this._deployInstance == null) {
                Thread thread = Thread.currentThread();
                ClassLoader oldLoader = thread.getContextClassLoader();
                try {
                    thread.setContextClassLoader(this._parentLoader);
                    this._deployInstance = this.instantiateDeployInstance();
                    Object var5_4 = null;
                    thread.setContextClassLoader(oldLoader);
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    thread.setContextClassLoader(oldLoader);
                    throw throwable;
                }
            }
            return this._deployInstance;
        }
    }

    public void startOnInit() {
        if (!this._lifecycle.isAfterInit()) {
            throw new IllegalStateException(L.l("startOnInit must be called after init (in '{0}')", (Object)this._lifecycle.getStateName()));
        }
        this._strategy.startOnInit(this);
    }

    public final void start() {
        this._strategy.start(this);
    }

    public Throwable getConfigException() {
        return null;
    }

    public final void stop() {
        this._strategy.stop(this);
    }

    public final void restart() {
        this._strategy.stop(this);
        this._strategy.start(this);
    }

    public final void update() {
        this._strategy.update(this);
    }

    public I request() {
        if (this._lifecycle.isDestroyed()) {
            return null;
        }
        if (this._strategy != null) {
            return this._strategy.request(this);
        }
        return null;
    }

    public I subrequest() {
        if (this._lifecycle.isDestroyed()) {
            return null;
        }
        if (this._strategy != null) {
            return this._strategy.subrequest(this);
        }
        return null;
    }

    I restartImpl() {
        if (!this._lifecycle.isStopped() && !this._lifecycle.isInit()) {
            this.stopImpl();
        }
        return this.startImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected I startImpl() {
        boolean isStarting;
        ClassLoader loader;
        ClassLoader oldLoader;
        Thread thread;
        I deployInstance;
        block29: {
            I i;
            block28: {
                assert (this._lifecycle.isAfterInit());
                if (DynamicClassLoader.isModified(this._parentLoader)) {
                    this._deployInstance = null;
                    return null;
                }
                deployInstance = this.getDeployInstance();
                thread = Thread.currentThread();
                oldLoader = thread.getContextClassLoader();
                loader = null;
                isStarting = false;
                try {
                    try {
                        loader = deployInstance.getClassLoader();
                        thread.setContextClassLoader(loader);
                        isStarting = this._lifecycle.toStarting();
                        if (!isStarting) {
                            i = deployInstance;
                            Object var8_9 = null;
                            if (isStarting) {
                                this._lifecycle.toActive();
                            }
                            break block28;
                        }
                        this.expandArchive();
                        this.addManifestClassPath();
                        this.configureInstance(deployInstance);
                        deployInstance.start();
                        this._startTime = Alarm.getCurrentTime();
                        break block29;
                    }
                    catch (ConfigException e) {
                        this._lifecycle.toError();
                        if (deployInstance != null) {
                            deployInstance.setConfigException(e);
                        } else {
                            log.severe(e.toString());
                            log.log(Level.FINEST, e.toString(), e);
                        }
                        Object var8_11 = null;
                        if (isStarting) {
                            this._lifecycle.toActive();
                        }
                        if (loader instanceof DynamicClassLoader) {
                            ((DynamicClassLoader)loader).clearModified();
                        }
                        if (this._alarm != null) {
                            this._alarm.queue(this._redeployCheckInterval);
                        }
                        thread.setContextClassLoader(oldLoader);
                        return deployInstance;
                    }
                    catch (Throwable e) {
                        this._lifecycle.toError();
                        if (deployInstance != null) {
                            deployInstance.setConfigException(e);
                        } else {
                            log.log(Level.SEVERE, e.toString(), e);
                        }
                        Object var8_12 = null;
                        if (isStarting) {
                            this._lifecycle.toActive();
                        }
                        if (loader instanceof DynamicClassLoader) {
                            ((DynamicClassLoader)loader).clearModified();
                        }
                        if (this._alarm != null) {
                            this._alarm.queue(this._redeployCheckInterval);
                        }
                        thread.setContextClassLoader(oldLoader);
                        return deployInstance;
                    }
                }
                catch (Throwable throwable) {
                    Object var8_13 = null;
                    if (isStarting) {
                        this._lifecycle.toActive();
                    }
                    if (loader instanceof DynamicClassLoader) {
                        ((DynamicClassLoader)loader).clearModified();
                    }
                    if (this._alarm != null) {
                        this._alarm.queue(this._redeployCheckInterval);
                    }
                    thread.setContextClassLoader(oldLoader);
                    throw throwable;
                }
            }
            if (loader instanceof DynamicClassLoader) {
                ((DynamicClassLoader)loader).clearModified();
            }
            if (this._alarm != null) {
                this._alarm.queue(this._redeployCheckInterval);
            }
            thread.setContextClassLoader(oldLoader);
            return i;
        }
        Object var8_10 = null;
        if (isStarting) {
            this._lifecycle.toActive();
        }
        if (loader instanceof DynamicClassLoader) {
            ((DynamicClassLoader)loader).clearModified();
        }
        if (this._alarm != null) {
            this._alarm.queue(this._redeployCheckInterval);
        }
        thread.setContextClassLoader(oldLoader);
        return deployInstance;
    }

    protected void expandArchive() throws Exception {
    }

    void stopLazyImpl() {
        if (this._lifecycle.isInit()) {
            return;
        }
        this.stopImpl();
        this._lifecycle.toPostInit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    void stopImpl() {
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        I oldInstance = this._deployInstance;
        boolean isStopping = false;
        if (oldInstance != null) {
            thread.setContextClassLoader(oldInstance.getClassLoader());
        }
        try {
            isStopping = this._lifecycle.toStopping();
            if (!isStopping) {
                Object var8_5 = null;
                if (isStopping) {
                    this._lifecycle.toStop();
                }
                thread.setContextClassLoader(oldLoader);
                return;
            }
            DeployController deployController = this;
            // MONITORENTER : deployController
            oldInstance = this._deployInstance;
            this._deployInstance = null;
            // MONITOREXIT : deployController
            if (oldInstance != null) {
                oldInstance.destroy();
            }
            Object var8_6 = null;
            if (isStopping) {
                this._lifecycle.toStop();
            }
            thread.setContextClassLoader(oldLoader);
            return;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            if (isStopping) {
                this._lifecycle.toStop();
            }
            thread.setContextClassLoader(oldLoader);
            throw throwable;
        }
    }

    protected abstract I instantiateDeployInstance();

    protected void addManifestClassPath() throws IOException {
    }

    protected void configureInstance(I deployInstance) throws Throwable {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handleAlarm(Alarm alarm) {
        try {
            this._strategy.alarm(this);
            Object var3_2 = null;
            if (this._lifecycle.isDestroyed()) return;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (this._lifecycle.isDestroyed()) throw throwable;
            alarm.queue(this._redeployCheckInterval);
            throw throwable;
        }
        alarm.queue(this._redeployCheckInterval);
    }

    public boolean isDestroyed() {
        return this._lifecycle.isDestroyed();
    }

    protected boolean destroy() {
        if (this._lifecycle.isAfterInit()) {
            this.stop();
        }
        if (!this._lifecycle.toDestroy()) {
            return false;
        }
        Alarm alarm = this._alarm;
        this._alarm = null;
        if (alarm != null) {
            alarm.dequeue();
        }
        return true;
    }

    protected Logger getLog() {
        return log;
    }

    public String toString() {
        String className = this.getClass().getName();
        int p = className.lastIndexOf(46);
        return className.substring(p + 1) + "[" + this.getId() + "]";
    }
}

