/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.deploy;

import com.caucho.lifecycle.Lifecycle;
import com.caucho.lifecycle.LifecycleListener;
import com.caucho.lifecycle.LifecycleNotification;
import com.caucho.management.server.AbstractManagedObject;
import com.caucho.management.server.DeployControllerMXBean;
import com.caucho.server.deploy.DeployController;
import com.caucho.server.deploy.EnvironmentDeployController;
import com.caucho.server.deploy.ExpandDeployController;
import com.caucho.util.Alarm;
import java.io.Serializable;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DeployControllerAdmin<C extends EnvironmentDeployController>
extends AbstractManagedObject
implements DeployControllerMXBean,
NotificationEmitter,
LifecycleListener,
Serializable {
    private final transient C _controller;
    private final transient NotificationBroadcasterSupport _broadcaster;
    private long _sequence = 0L;

    public DeployControllerAdmin(C controller) {
        this._controller = controller;
        this._broadcaster = new NotificationBroadcasterSupport();
        ((DeployController)controller).addLifecycleListener(this);
    }

    protected C getController() {
        return this._controller;
    }

    protected void register() {
        this.registerSelf();
    }

    protected void unregister() {
        this.unregisterSelf();
    }

    @Override
    public String getName() {
        return ((DeployController)this._controller).getMBeanId();
    }

    @Override
    public String getStartupMode() {
        return ((DeployController)this._controller).getStartupMode();
    }

    @Override
    public String getRedeployMode() {
        return ((DeployController)this._controller).getRedeployMode();
    }

    @Override
    public long getRedeployCheckInterval() {
        return ((DeployController)this._controller).getRedeployCheckInterval();
    }

    @Override
    public String getState() {
        return ((DeployController)this.getController()).getState();
    }

    @Override
    public Date getStartTime() {
        return new Date(((DeployController)this.getController()).getStartTime());
    }

    @Override
    public void start() throws Exception {
        ((DeployController)this.getController()).start();
    }

    @Override
    public void stop() throws Exception {
        ((DeployController)this.getController()).stop();
    }

    @Override
    public void restart() throws Exception {
        ((DeployController)this.getController()).stop();
        ((DeployController)this.getController()).start();
    }

    @Override
    public void update() throws Exception {
        ((DeployController)this.getController()).update();
    }

    public String getRootDirectory() {
        return ((ExpandDeployController)this._controller).getRootDirectory().getNativePath();
    }

    @Override
    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws IllegalArgumentException {
        this._broadcaster.addNotificationListener(listener, filter, handback);
    }

    @Override
    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        this._broadcaster.removeNotificationListener(listener);
    }

    @Override
    public void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        this._broadcaster.removeNotificationListener(listener, filter, handback);
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        MBeanNotificationInfo status = new MBeanNotificationInfo(new String[]{"jmx.attribute.change"}, "status", "status attribute changes");
        return new MBeanNotificationInfo[]{status};
    }

    @Override
    public synchronized void lifecycleEvent(int oldState, int newState) {
        LifecycleNotification notif;
        String newValue;
        Logger log = ((DeployController)this._controller).getLog();
        long timestamp = Alarm.getCurrentTime();
        String oldValue = Lifecycle.getStateName(oldState);
        String message = newValue = Lifecycle.getStateName(newState);
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, this.toString() + " lifecycleEvent `" + newValue + "'");
        }
        if (newState == 6) {
            notif = new LifecycleNotification("caucho.lifecycle.after-start", this, this._sequence++, timestamp, this.toString() + " started");
            this._broadcaster.sendNotification(notif);
        }
        if (oldState == 6) {
            notif = new LifecycleNotification("caucho.lifecycle.before-stop", this, this._sequence++, timestamp, this.toString() + " stopping");
            this._broadcaster.sendNotification(notif);
        }
    }

    @Override
    public String toString() {
        String name = this.getClass().getName();
        int i = name.lastIndexOf(46) + 1;
        if (i > 0 && i < name.length()) {
            name = name.substring(i);
        }
        return name + "[" + this.getObjectName() + "]";
    }
}

