/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.deploy;

import com.caucho.log.Log;
import com.caucho.server.deploy.DeployContainer;
import com.caucho.server.deploy.DeployController;
import com.caucho.server.deploy.DeployGenerator;
import com.caucho.util.L10N;
import com.caucho.vfs.Dependency;
import java.util.ArrayList;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeployListGenerator<E extends DeployController>
extends DeployGenerator<E>
implements Dependency {
    private static final Logger log = Log.open(DeployListGenerator.class);
    private static final L10N L = new L10N(DeployListGenerator.class);
    private ArrayList<DeployGenerator<E>> _generatorList = new ArrayList();

    public DeployListGenerator(DeployContainer container) {
        super(container);
    }

    public void add(DeployGenerator<E> deploy) {
        if (!this._generatorList.contains(deploy)) {
            this._generatorList.add(deploy);
        }
    }

    public void remove(DeployGenerator<E> deploy) {
        this._generatorList.remove(deploy);
    }

    @Override
    public boolean isModified() {
        for (int i = this._generatorList.size() - 1; i >= 0; --i) {
            if (!this._generatorList.get(i).isModified()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean logModified(Logger log) {
        for (int i = this._generatorList.size() - 1; i >= 0; --i) {
            if (!this._generatorList.get(i).logModified(log)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void request() {
        for (int i = this._generatorList.size() - 1; i >= 0; --i) {
            this._generatorList.get(i).request();
        }
    }

    @Override
    public void update() {
        for (int i = 0; i < this._generatorList.size(); ++i) {
            this._generatorList.get(i).update();
        }
    }

    @Override
    public void fillDeployedKeys(Set<String> keys) {
        for (int i = 0; i < this._generatorList.size(); ++i) {
            this._generatorList.get(i).fillDeployedKeys(keys);
        }
    }

    @Override
    protected E generateController(String key) {
        for (int i = 0; i < this._generatorList.size(); ++i) {
            E controller = this._generatorList.get(i).generateController(key);
            for (int j = 0; controller != null && j < this._generatorList.size(); ++j) {
                DeployGenerator<E> generator = this._generatorList.get(j);
                controller = this._generatorList.get(j).mergeController(controller, key);
            }
            if (controller == null) continue;
            return controller;
        }
        return null;
    }

    @Override
    protected E mergeController(E controller, String key) {
        for (int i = 0; i < this._generatorList.size(); ++i) {
            controller = this._generatorList.get(i).mergeController(controller, key);
        }
        return controller;
    }

    @Override
    protected void startImpl() {
        super.startImpl();
        for (int i = 0; i < this._generatorList.size(); ++i) {
            this._generatorList.get(i).start();
        }
    }

    @Override
    protected void stopImpl() {
        for (int i = 0; i < this._generatorList.size(); ++i) {
            this._generatorList.get(i).stop();
        }
        super.stopImpl();
    }

    @Override
    protected void destroyImpl() {
        ArrayList<DeployGenerator<E>> generatorList = new ArrayList<DeployGenerator<E>>(this._generatorList);
        this._generatorList.clear();
        for (int i = 0; i < generatorList.size(); ++i) {
            try {
                generatorList.get(i).destroy();
                continue;
            }
            catch (Throwable e) {
                log.log(Level.FINE, e.toString(), e);
            }
        }
        super.destroyImpl();
    }

    @Override
    public String toString() {
        return "DeployListGenerator[" + this._generatorList + "]";
    }
}

