/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.deploy;

import com.caucho.config.types.FileSetType;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.loader.Environment;
import com.caucho.server.deploy.DeployController;
import com.caucho.server.deploy.DeployInstance;
import com.caucho.util.L10N;
import com.caucho.util.Log;
import com.caucho.vfs.Depend;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.Vfs;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.TreeMap;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ExpandDeployController<I extends DeployInstance>
extends DeployController<I> {
    private static final L10N L = new L10N(ExpandDeployController.class);
    private static final Logger log = Log.open(ExpandDeployController.class);
    private Object _archiveExpandLock = new Object();
    private Path _rootDirectory;
    private Path _archivePath;
    private FileSetType _expandCleanupFileSet;
    private DynamicClassLoader _manifestLoader;
    private Manifest _manifest;

    protected ExpandDeployController(String id) {
        this(id, null, null);
    }

    protected ExpandDeployController(String id, ClassLoader loader, Path rootDirectory) {
        super(id, loader);
        if (rootDirectory == null) {
            rootDirectory = Vfs.getPwd(this.getParentClassLoader());
        }
        this._rootDirectory = rootDirectory;
    }

    public Path getRootDirectory() {
        return this._rootDirectory;
    }

    protected void setRootDirectory(Path rootDirectory) {
        this._rootDirectory = rootDirectory;
    }

    public Path getArchivePath() {
        return this._archivePath;
    }

    public void setArchivePath(Path path) {
        this._archivePath = path;
    }

    public Manifest getManifest() {
        return this._manifest;
    }

    public Map<String, String> getManifestAttributes() {
        if (this._manifest == null) {
            return null;
        }
        TreeMap<String, String> map = new TreeMap<String, String>();
        Attributes attr = this._manifest.getMainAttributes();
        if (attr != null) {
            for (Map.Entry<Object, Object> entry : attr.entrySet()) {
                map.put(String.valueOf(entry.getKey()), String.valueOf(entry.getValue()));
            }
        }
        return map;
    }

    public void setManifestClassLoader(DynamicClassLoader loader) {
        this._manifestLoader = loader;
    }

    public void setExpandCleanupFileSet(FileSetType fileSet) {
        this._expandCleanupFileSet = fileSet;
    }

    @Override
    protected void mergeController(DeployController oldControllerV) {
        super.mergeController(oldControllerV);
        ExpandDeployController oldController = (ExpandDeployController)oldControllerV;
        if (oldController._expandCleanupFileSet != null) {
            this._expandCleanupFileSet = oldController._expandCleanupFileSet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void expandArchive() throws IOException {
        Object object = this._archiveExpandLock;
        synchronized (object) {
            block9: {
                Path path;
                if (!this.expandArchiveImpl()) {
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    this.expandArchiveImpl();
                }
                if (!(path = this.getRootDirectory().lookup("META-INF/MANIFEST.MF")).canRead()) return;
                ReadStream is = path.openRead();
                try {
                    try {
                        this._manifest = new Manifest((InputStream)is);
                    }
                    catch (IOException e) {
                        log.warning(L.l("Manifest file cannot be read for '{0}'.\n{1}", (Object)this.getRootDirectory(), (Object)e));
                        log.log(Level.FINE, e.toString(), e);
                        Object var6_6 = null;
                        is.close();
                        break block9;
                    }
                    Object var6_5 = null;
                }
                catch (Throwable throwable) {
                    Object var6_7 = null;
                    is.close();
                    throw throwable;
                }
                is.close();
            }
            return;
        }
    }

    @Override
    protected void addManifestClassPath() throws IOException {
        DynamicClassLoader loader = Environment.getDynamicClassLoader();
        if (loader == null) {
            return;
        }
        Manifest manifest = this.getManifest();
        if (manifest == null) {
            return;
        }
        Attributes main = manifest.getMainAttributes();
        if (main == null) {
            return;
        }
        String classPath = main.getValue("Class-Path");
        Path pwd = null;
        pwd = this.getArchivePath() != null ? this.getArchivePath().getParent() : this.getRootDirectory();
        if (classPath != null) {
            if (this._manifestLoader != null) {
                this._manifestLoader.addManifestClassPath(classPath, pwd);
            } else {
                loader.addManifestClassPath(classPath, pwd);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean expandArchiveImpl() throws IOException {
        archivePath = this.getArchivePath();
        if (archivePath == null) {
            return true;
        }
        if (!archivePath.canRead()) {
            return true;
        }
        expandDir = this.getRootDirectory();
        parent = expandDir.getParent();
        try {
            parent.mkdirs();
        }
        catch (Throwable e) {
            // empty catch block
        }
        dependPath = expandDir.lookup("META-INF/resin-war.digest");
        depend = null;
        if (dependPath.canRead()) {
            is = null;
            try {
                block39: {
                    try {
                        is = dependPath.openRead();
                        line = is.readLine();
                        if (line == null || (depend = new Depend(archivePath, digest = Long.parseLong(line.trim()))).isModified()) break block39;
                        var10_14 = true;
                        var12_16 = null;
                        if (is == null) return var10_14;
                    }
                    catch (Throwable e) {
                        ExpandDeployController.log.log(Level.FINE, e.toString(), e);
                        var12_17 = null;
                        if (is != null) {
                            is.close();
                        }
                    }
                    is.close();
                    return var10_14;
                }
                var12_17 = null;
                if (is != null) {
                    is.close();
                }
            }
            catch (Throwable var11_22) {
                var12_18 = null;
                if (is == null) throw var11_22;
                is.close();
                throw var11_22;
            }
        }
        if (depend == null) {
            depend = new Depend(archivePath);
        }
        try {
            if (ExpandDeployController.log.isLoggable(Level.INFO)) {
                this.getLog().info("expanding " + archivePath + " to " + expandDir);
            }
            this.removeExpandDirectory(expandDir);
            expandDir.mkdirs();
            rs = archivePath.openRead();
            zis = new ZipInputStream((InputStream)rs);
            try {
                entry = zis.getNextEntry();
                buffer = new byte[1024];
                while (entry != null) {
                    name = entry.getName();
                    path = expandDir.lookup(name);
                    if (entry.isDirectory()) {
                        path.mkdirs();
                    } else {
                        length = entryLength = entry.getSize();
                        bufferLen = buffer.length;
                        if (length < 0L) {
                            length = 0x3FFFFFFFFFFFFFFFL;
                        } else if (length < (long)bufferLen) {
                            bufferLen = (int)length;
                        }
                        lastModified = entry.getTime();
                        path.getParent().mkdirs();
                        os = path.openWrite();
                        len = 0;
                        try {
                            try {
                                if (bufferLen == 1) {
                                    ch = zis.read();
                                    while (ch != -1) {
                                        os.write(ch);
                                        ch = zis.read();
                                    }
                                } else {
                                    while ((len = zis.read(buffer, 0, bufferLen)) > 0) {
                                        os.write(buffer, 0, len);
                                        if ((length -= (long)len) >= (long)bufferLen) continue;
                                        bufferLen = (int)length;
                                    }
                                }
                                var24_33 = null;
                            }
                            catch (IOException e) {
                                ex = new Exception("IOException when expanding entry " + entry + " in " + archivePath + ", entry.length: " + entryLength + " entry.compressed: " + entry.getCompressedSize() + ", bufferLen: " + bufferLen + ", read len: " + len + ", remaining: " + length, e);
                                ExpandDeployController.log.log(Level.FINE, ex.toString(), ex);
                                var24_33 = null;
                                os.close();
                            }
                            os.close();
                        }
                        catch (Throwable var23_34) {
                            var24_33 = null;
                            os.close();
                            throw var23_34;
                        }
                        if (lastModified > 0L) {
                            path.setLastModified(lastModified);
                        }
                    }
                    try {
                        entry = zis.getNextEntry();
                    }
                    catch (IOException e) {
                        ExpandDeployController.log.log(Level.FINE, e.toString(), e);
                        break;
                    }
                }
                var26_35 = null;
                try {
                    zis.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
                rs.close();
            }
            catch (Throwable var25_39) {
                block44: {
                    var26_36 = null;
                    ** try [egrp 8[TRYBLOCK] [13 : 677->685)] { 
lbl131:
                    // 1 sources

                    zis.close();
                    break block44;
lbl133:
                    // 1 sources

                    catch (IOException e) {
                        // empty catch block
                    }
                }
                rs.close();
                throw var25_39;
            }
        }
        catch (IOException e) {
            ExpandDeployController.log.log(Level.WARNING, e.toString(), e);
            return false;
        }
        try {
            dependPath.getParent().mkdirs();
            os = dependPath.openWrite();
            os.println(depend.getDigest());
            os.close();
            return true;
        }
        catch (Throwable e) {
            ExpandDeployController.log.log(Level.WARNING, e.toString(), e);
        }
        return true;
    }

    protected void removeExpandDirectory(Path path) {
        String prefix = path.getPath();
        if (!prefix.endsWith("/")) {
            prefix = prefix + "/";
        }
        this.removeExpandDirectory(path, prefix);
    }

    protected void removeExpandDirectory(Path path, String prefix) {
        try {
            if (path.isDirectory()) {
                String[] list = path.list();
                for (int i = 0; list != null && i < list.length; ++i) {
                    this.removeExpandDirectory(path.lookup(list[i]), prefix);
                }
            }
            this.removeExpandFile(path, prefix);
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    protected void removeExpandFile(Path path, String prefix) throws IOException {
        if (this._expandCleanupFileSet == null || this._expandCleanupFileSet.isMatch(path, prefix)) {
            path.remove();
        }
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public boolean equals(Object o) {
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        DeployController controller = (DeployController)o;
        return this.getId().equals(controller.getId());
    }
}

