/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.deploy;

import com.caucho.config.ConfigException;
import com.caucho.config.types.FileSetType;
import com.caucho.config.types.Period;
import com.caucho.loader.Environment;
import com.caucho.server.deploy.DeployContainer;
import com.caucho.server.deploy.DeployController;
import com.caucho.server.deploy.DeployGenerator;
import com.caucho.server.deploy.ExpandDeployController;
import com.caucho.server.util.CauchoSystem;
import com.caucho.util.Alarm;
import com.caucho.util.AlarmListener;
import com.caucho.util.L10N;
import com.caucho.util.WeakAlarm;
import com.caucho.vfs.Path;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ExpandDeployGenerator<E extends ExpandDeployController>
extends DeployGenerator<E>
implements AlarmListener {
    private static final Logger log = Logger.getLogger(ExpandDeployGenerator.class.getName());
    private static final L10N L = new L10N(ExpandDeployGenerator.class);
    private static final long MIN_CRON_INTERVAL = 5000L;
    private Path _path;
    private Path _containerRootDirectory;
    private Path _archiveDirectory;
    private Path _expandDirectory;
    private String _extension = ".jar";
    private String _expandPrefix = "";
    private String _expandSuffix = "";
    private boolean _isVersioning;
    private ArrayList<String> _requireFiles = new ArrayList();
    private TreeSet<String> _controllerNames = new TreeSet();
    private TreeMap<String, ArrayList<String>> _versionMap = new TreeMap();
    private FileSetType _expandCleanupFileSet;
    private Alarm _alarm;
    private long _cronInterval;
    private volatile long _lastCheckTime;
    private volatile boolean _isChecking;
    private long _checkInterval = 1000L;
    private long _digest;
    private volatile boolean _isModified;
    private volatile boolean _isDeploying;

    public ExpandDeployGenerator(DeployContainer<E> container, Path containerRootDirectory) {
        super(container);
        this._containerRootDirectory = containerRootDirectory;
        this._alarm = new WeakAlarm((AlarmListener)this);
        this._cronInterval = Environment.getDependencyCheckInterval();
        if (this._cronInterval < 5000L) {
            this._cronInterval = 5000L;
        }
    }

    Path getContainerRootDirectory() {
        return this._containerRootDirectory;
    }

    public Path getPath() {
        return this._path;
    }

    public void setPath(Path path) {
        this._path = path;
    }

    public void setExpandPath(Path path) {
        log.config("Use <expand-directory> instead of <expand-path>.  <expand-path> is deprecated.");
        this.setExpandDirectory(path);
    }

    public void setExpandDirectory(Path path) {
        this._expandDirectory = path;
    }

    public Path getExpandDirectory() {
        if (this._expandDirectory != null) {
            return this._expandDirectory;
        }
        return this._path;
    }

    public Path getExpandPath(String name) {
        if (!this.isDeployedKey(this.nameToEntryName(name))) {
            return null;
        }
        return this.getExpandDirectory().lookup(this.getExpandName(name));
    }

    protected String getExpandName(String name) {
        return this.getExpandPrefix() + name + this.getExpandSuffix();
    }

    public void setArchiveDirectory(Path path) {
        this._archiveDirectory = path;
    }

    public Path getArchiveDirectory() {
        if (this._archiveDirectory != null) {
            return this._archiveDirectory;
        }
        return this._path;
    }

    public Path getArchivePath(String name) {
        return this.getArchiveDirectory().lookup(name + this.getExtension());
    }

    public void setDependencyCheckInterval(Period period) {
        this._cronInterval = period.getPeriod();
        if (this._cronInterval < 0L) {
            this._cronInterval = 4611686018427387000L;
        } else if (this._cronInterval < 5000L) {
            this._cronInterval = 5000L;
        }
    }

    public long getDependencyCheckInterval() {
        return this._cronInterval;
    }

    public void setExpandCleanupFileset(FileSetType fileSet) {
        this._expandCleanupFileSet = fileSet;
    }

    public void setExtension(String extension) throws ConfigException {
        if (!extension.startsWith(".")) {
            throw new ConfigException(L.l("deployment extension '{0}' must begin with '.'", (Object)extension));
        }
        this._extension = extension;
    }

    public String getExtension() {
        return this._extension;
    }

    public void setExpandPrefix(String prefix) throws ConfigException {
        if (!(prefix.equals("") || prefix.startsWith("_") || prefix.startsWith("."))) {
            throw new ConfigException(L.l("expand-prefix '{0}' must start with '.' or '_'.", (Object)prefix));
        }
        this._expandPrefix = prefix;
    }

    public String getExpandPrefix() {
        return this._expandPrefix;
    }

    public void setExpandSuffix(String suffix) throws ConfigException {
        this._expandSuffix = suffix;
    }

    public String getExpandSuffix() {
        return this._expandSuffix;
    }

    public void addRequireFile(String file) throws ConfigException {
        this._requireFiles.add(file);
    }

    public void setVersioning(boolean isVersioning) {
        this._isVersioning = isVersioning;
    }

    public boolean isVersioning() {
        return this._isVersioning;
    }

    @Override
    protected Logger getLog() {
        return log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isModified() {
        ExpandDeployGenerator expandDeployGenerator = this;
        synchronized (expandDeployGenerator) {
            long now = Alarm.getCurrentTime();
            if (now < this._lastCheckTime + this._checkInterval || this._isChecking) {
                return this._isModified;
            }
            this._isChecking = true;
            this._lastCheckTime = Alarm.getCurrentTime();
        }
        try {
            long digest = this.getDigest();
            boolean bl = this._isModified = this._digest != digest;
            Object var6_8 = null;
            this._isChecking = false;
            return bl;
        }
        catch (Exception e) {
            try {
                log.log(Level.FINE, e.toString(), e);
                boolean bl = false;
                Object var6_9 = null;
                this._isChecking = false;
                return bl;
            }
            catch (Throwable throwable) {
                Object var6_10 = null;
                this._isChecking = false;
                throw throwable;
            }
        }
    }

    @Override
    public boolean logModified(Logger log) {
        long digest = this.getDigest();
        if (this._digest != digest) {
            Path expandDirectory;
            Path archiveDirectory;
            String reason = "";
            String name = this.getClass().getName();
            int p = name.lastIndexOf(46);
            if (p > 0) {
                name = name.substring(p + 1);
            }
            if ((archiveDirectory = this.getArchiveDirectory()) != null) {
                reason = name + "[" + archiveDirectory.getNativePath() + "] is modified";
            }
            if ((expandDirectory = this.getExpandDirectory()) != null && !expandDirectory.equals((Object)archiveDirectory)) {
                if (!"".equals(reason)) {
                    reason = reason + " or ";
                }
                reason = name + "[" + expandDirectory.getNativePath() + "] is modified";
            }
            log.info(reason);
            return true;
        }
        return false;
    }

    @Override
    protected void initImpl() throws ConfigException {
        super.initImpl();
        if (this.getExpandDirectory() == null) {
            throw new ConfigException(L.l("<expand-directory> must be specified for deployment of archive expansion."));
        }
        if (this.getArchiveDirectory() == null) {
            throw new ConfigException(L.l("<archive-directory> must be specified for deployment of archive expansion."));
        }
    }

    @Override
    protected void startImpl() {
        super.startImpl();
        this.handleAlarm(this._alarm);
    }

    @Override
    protected void fillDeployedKeys(Set<String> keys) {
        if (this.isModified()) {
            try {
                this.deploy();
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
        for (String name : this._controllerNames) {
            keys.add(name);
        }
    }

    protected boolean isDeployedKey(String key) {
        return this._controllerNames.contains(key);
    }

    @Override
    public void update() {
        this._lastCheckTime = 0L;
        this.request();
    }

    @Override
    public void request() {
        if (this.isModified()) {
            try {
                this.deploy();
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void deploy() throws Exception {
        boolean isDeploying = false;
        log.finer(this + " redeploy " + this._isDeploying);
        try {
            ArrayList<String> updatedNames = null;
            ExpandDeployGenerator expandDeployGenerator = this;
            synchronized (expandDeployGenerator) {
                if (this._isDeploying) {
                    // MONITOREXIT @DISABLED, blocks:[0, 3, 9] lbl8 : MonitorExitStatement: MONITOREXIT : var3_3
                    Object var9_5 = null;
                    if (!isDeploying) return;
                    this._isModified = false;
                    this._isDeploying = false;
                    return;
                }
                this._isDeploying = true;
                isDeploying = true;
                TreeSet<String> entryNames = this.findEntryNames();
                this._digest = this.getDigest();
                if (!this._controllerNames.equals(entryNames)) {
                    updatedNames = new ArrayList<String>();
                    for (String name : this._controllerNames) {
                        if (entryNames.contains(name)) continue;
                        updatedNames.add(name);
                    }
                    for (String name : entryNames) {
                        if (this._controllerNames.contains(name)) continue;
                        updatedNames.add(name);
                    }
                    this._controllerNames = entryNames;
                }
            }
            for (int i = 0; updatedNames != null && i < updatedNames.size(); ++i) {
                String name = (String)updatedNames.get(i);
                this.getDeployContainer().update(name);
            }
        }
        catch (Throwable throwable) {
            Object var9_7 = null;
            if (!isDeploying) throw throwable;
            this._isModified = false;
            this._isDeploying = false;
            throw throwable;
        }
        Object var9_6 = null;
        if (!isDeploying) return;
        this._isModified = false;
        this._isDeploying = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E generateController(String name) {
        E e;
        this.request();
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this.getParentClassLoader());
            E controller = this.createController(name);
            if (controller != null) {
                ((ExpandDeployController)controller).setExpandCleanupFileSet(this._expandCleanupFileSet);
                this._controllerNames.add(name);
            }
            e = controller;
            Object var7_6 = null;
            thread.setContextClassLoader(oldLoader);
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            thread.setContextClassLoader(oldLoader);
            throw throwable;
        }
        return e;
    }

    private long getDigest() {
        long archiveDigest = 0L;
        Path archiveDirectory = this.getArchiveDirectory();
        if (archiveDirectory != null) {
            archiveDigest = archiveDirectory.getCrc64();
        }
        long expandDigest = 0L;
        Path expandDirectory = this.getExpandDirectory();
        if (expandDirectory != null) {
            expandDigest = expandDirectory.getCrc64();
        }
        return archiveDigest * 65521L + expandDigest;
    }

    public ArrayList<String> getVersionNames(String name) {
        TreeSet<String> entryNames;
        if (!this.isVersioning()) {
            return null;
        }
        try {
            entryNames = this.findEntryNames();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        TreeMap<String, ArrayList<String>> versionMap = this.buildVersionMap(entryNames);
        return versionMap.get(name);
    }

    private TreeSet<String> findEntryNames() throws IOException {
        TreeSet<String> entryNames = new TreeSet<String>();
        Path archiveDirectory = this.getArchiveDirectory();
        Path expandDirectory = this.getExpandDirectory();
        if (archiveDirectory == null || expandDirectory == null) {
            return entryNames;
        }
        String[] entryList = archiveDirectory.list();
        for (int i = 0; i < entryList.length; ++i) {
            int p;
            String archiveName = entryList[i];
            Path archivePath = archiveDirectory.lookup(archiveName);
            String entryName = null;
            if (!archivePath.canRead() || (entryName = this.archiveNameToEntryName(archiveName)) == null) continue;
            entryNames.add(entryName);
            if (!this._isVersioning || (p = entryName.lastIndexOf(45)) < 0 || entryNames.contains(entryName = entryName.substring(0, p))) continue;
            entryNames.add(entryName);
        }
        String[] entryExpandList = expandDirectory.list();
        for (int i = 0; i < entryExpandList.length; ++i) {
            int p;
            String pathName = entryExpandList[i];
            Path rootDirectory = expandDirectory.lookup(pathName);
            String entryName = this.pathNameToEntryName(pathName);
            if (entryName == null || entryName.endsWith(this.getExtension()) || !this.isValidDirectory(rootDirectory, pathName)) continue;
            if (!entryNames.contains(entryName)) {
                entryNames.add(entryName);
            }
            if (!this._isVersioning || (p = entryName.lastIndexOf(45)) < 0 || entryNames.contains(entryName = entryName.substring(0, p))) continue;
            entryNames.add(entryName);
        }
        return entryNames;
    }

    private TreeMap<String, ArrayList<String>> buildVersionMap(TreeSet<String> entryNames) {
        TreeMap<String, ArrayList<String>> versionMap = new TreeMap<String, ArrayList<String>>();
        for (String name : entryNames) {
            String baseName = this.versionedNameToBaseName(name);
            if (!this._isVersioning || baseName.equals(name)) continue;
            ArrayList<String> list = versionMap.get(baseName);
            if (list == null) {
                list = new ArrayList();
            }
            list.add(name);
            versionMap.put(baseName, list);
        }
        return versionMap;
    }

    protected boolean isValidDirectory(Path rootDirectory, String pathName) {
        if (!rootDirectory.isDirectory() || pathName.startsWith(".")) {
            return false;
        }
        if (pathName.equalsIgnoreCase("web-inf") || pathName.equalsIgnoreCase("meta-inf")) {
            return false;
        }
        for (int j = 0; j < this._requireFiles.size(); ++j) {
            String file = this._requireFiles.get(j);
            if (rootDirectory.lookup(file).canRead()) continue;
            return false;
        }
        return true;
    }

    protected String pathNameToEntryName(String name) {
        if (this._expandPrefix != null) {
            if (this._expandPrefix.equals("") && (name.startsWith("_") || name.startsWith(".") || name.endsWith(".") && CauchoSystem.isWindows() || name.equalsIgnoreCase("META-INF") || name.equalsIgnoreCase("WEB-INF"))) {
                return null;
            }
            if (name.startsWith(this._expandPrefix)) {
                name = name.substring(this._expandPrefix.length());
            } else {
                return null;
            }
        }
        if (this._expandSuffix != null && !"".equals(this._expandSuffix)) {
            if (name.endsWith(this._expandSuffix)) {
                return name.substring(0, name.length() - this._expandSuffix.length());
            }
            return null;
        }
        if (this._extension != null && name.endsWith(this._extension)) {
            return name.substring(0, name.length() - this._extension.length());
        }
        return name;
    }

    protected String entryNameToArchiveName(String entryName) {
        return entryName + this.getExtension();
    }

    protected String archiveNameToEntryName(String archiveName) {
        if (!archiveName.endsWith(this._extension)) {
            return null;
        }
        int sublen = archiveName.length() - this._extension.length();
        return this.pathNameToEntryName(archiveName.substring(0, sublen));
    }

    protected abstract E createController(String var1);

    private String nameToEntryName(String name) {
        return this.archiveNameToEntryName(name + this.getExtension());
    }

    private String entryNameToName(String name) {
        String archiveName = this.entryNameToArchiveName(name);
        if (archiveName == null) {
            return null;
        }
        return archiveName.substring(0, archiveName.length() - this.getExtension().length());
    }

    private String versionedNameToBaseName(String name) {
        char ch;
        int p = name.lastIndexOf(45);
        if (p > 0 && p + 1 < name.length() && '0' <= (ch = name.charAt(p + 1)) && ch <= '9') {
            return name.substring(0, p);
        }
        return name;
    }

    public String[] getNames() {
        String[] names = new String[this._controllerNames.size()];
        int i = 0;
        for (String controllerName : this._controllerNames) {
            names[i++] = this.entryNameToName(controllerName);
        }
        return names;
    }

    private String getNamesAsString() {
        StringBuilder builder = new StringBuilder();
        for (String name : this.getNames()) {
            if (builder.length() > 0) {
                builder.append(", ");
            }
            builder.append(name);
        }
        builder.insert(0, '[');
        builder.append(']');
        return builder.toString();
    }

    public boolean start(String name) {
        Object controller = this.getDeployContainer().findController(this.nameToEntryName(name));
        if (controller == null) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, L.l("{0} unknown name '{1}' in start", (Object)this, (Object)name));
            }
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, L.l("{0} known names are {1} in start", (Object)this, (Object)this.getNamesAsString()));
            }
            return false;
        }
        ((DeployController)controller).start();
        return true;
    }

    public Throwable getConfigException(String name) {
        Object controller = this.getDeployContainer().findController(this.nameToEntryName(name));
        if (controller == null) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, L.l("unknown name '{0}'", (Object)name));
            }
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, L.l("known names are {0}", (Object)this.getNamesAsString()));
            }
            return new ConfigException(L.l("unknown name '{0}'", (Object)name));
        }
        return ((DeployController)controller).getConfigException();
    }

    public boolean stop(String name) {
        Object controller = this.getDeployContainer().findController(this.nameToEntryName(name));
        if (controller == null) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, L.l("unknown name '{0}'", (Object)name));
            }
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, L.l("known names are {0}", (Object)this.getNamesAsString()));
            }
            return false;
        }
        ((DeployController)controller).stop();
        return true;
    }

    public boolean undeploy(String name) {
        block11: {
            Path expandPath;
            block10: {
                Object controller = this.getDeployContainer().findController(this.nameToEntryName(name));
                if (controller == null) {
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, L.l("unknown name '{0}'", (Object)name));
                    }
                    if (log.isLoggable(Level.FINER)) {
                        log.log(Level.FINER, L.l("known names are {0}", (Object)this.getNamesAsString()));
                    }
                    return false;
                }
                Path archivePath = this.getArchivePath(name);
                expandPath = this.getExpandPath(name);
                ((DeployController)controller).stop();
                try {
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, L.l("deleting {0}", (Object)archivePath));
                    }
                    archivePath.removeAll();
                }
                catch (IOException ex) {
                    if (!log.isLoggable(Level.FINE)) break block10;
                    log.log(Level.FINE, ex.toString(), ex);
                }
            }
            try {
                if (expandPath != null) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, L.l("deleting {0}", (Object)expandPath));
                    }
                    expandPath.removeAll();
                }
            }
            catch (IOException ex) {
                if (!log.isLoggable(Level.FINE)) break block11;
                log.log(Level.FINE, ex.toString(), ex);
            }
        }
        this.getDeployContainer().update(this.nameToEntryName(name));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handleAlarm(Alarm alarm) {
        if (this.isDestroyed()) {
            return;
        }
        try {
            block5: {
                try {
                    if (!"automatic".equals(this.getRedeployMode()) || !this.isActive()) break block5;
                    this.request();
                }
                catch (Exception e) {
                    log.log(Level.WARNING, e.toString(), e);
                    Object var4_3 = null;
                    this._alarm.queue(this._cronInterval);
                    return;
                }
            }
            Object var4_2 = null;
            this._alarm.queue(this._cronInterval);
            return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this._alarm.queue(this._cronInterval);
            throw throwable;
        }
    }

    @Override
    protected void stopImpl() {
        this._alarm.dequeue();
        super.stopImpl();
    }

    public boolean equals(Object o) {
        Path deployExpandDirectory;
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        ExpandDeployGenerator deploy = (ExpandDeployGenerator)o;
        Path expandDirectory = this.getExpandDirectory();
        return expandDirectory == (deployExpandDirectory = deploy.getExpandDirectory()) || expandDirectory != null && expandDirectory.equals((Object)deployExpandDirectory);
    }

    @Override
    public String toString() {
        String name = this.getClass().getName();
        int p = name.lastIndexOf(46);
        if (p > 0) {
            name = name.substring(p + 1);
        }
        return name + "[" + this.getExpandDirectory() + "]";
    }
}

