/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.deploy;

import com.caucho.server.deploy.AbstractDeployControllerStrategy;
import com.caucho.server.deploy.DeployController;
import com.caucho.server.deploy.DeployControllerStrategy;
import com.caucho.server.deploy.DeployInstance;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StartLazyRedeployAutomaticStrategy
extends AbstractDeployControllerStrategy {
    private static final StartLazyRedeployAutomaticStrategy STRATEGY = new StartLazyRedeployAutomaticStrategy();

    private StartLazyRedeployAutomaticStrategy() {
    }

    public static DeployControllerStrategy create() {
        return STRATEGY;
    }

    @Override
    public <I extends DeployInstance> void startOnInit(DeployController<I> controller) {
        controller.stopLazyImpl();
    }

    @Override
    public <I extends DeployInstance> void update(DeployController<I> controller) {
        if (!controller.isStoppedLazy()) {
            if (controller.isStopped()) {
                controller.stopLazyImpl();
            } else if (controller.isModifiedNow()) {
                controller.stopLazyImpl();
            } else if (controller.isError()) {
                controller.stopLazyImpl();
            } else if (controller.isActiveIdle()) {
                controller.stopLazyImpl();
            }
        }
    }

    @Override
    public <I extends DeployInstance> I request(DeployController<I> controller) {
        if (controller.isStoppedLazy()) {
            return controller.startImpl();
        }
        if (controller.isStopped()) {
            return controller.getDeployInstance();
        }
        if (controller.isModified()) {
            return controller.restartImpl();
        }
        return controller.getDeployInstance();
    }

    @Override
    public <I extends DeployInstance> I subrequest(DeployController<I> controller) {
        if (controller.isStoppedLazy()) {
            return controller.startImpl();
        }
        if (controller.isStopped()) {
            return controller.getDeployInstance();
        }
        if (controller.isError() && controller.isModified()) {
            return controller.restartImpl();
        }
        if (controller.isModified()) {
            return controller.getDeployInstance();
        }
        return controller.getDeployInstance();
    }

    @Override
    public <I extends DeployInstance> void alarm(DeployController<I> controller) {
        if (!(controller.isStoppedLazy() || controller.isStopped() || controller.isError())) {
            if (controller.isModified()) {
                controller.stopLazyImpl();
            } else if (controller.isActiveIdle()) {
                controller.stopLazyImpl();
            }
        }
    }
}

