/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.dispatch;

import com.caucho.lifecycle.Lifecycle;
import com.caucho.server.dispatch.DispatchBuilder;
import com.caucho.server.dispatch.Invocation;
import com.caucho.server.dispatch.InvocationDecoder;
import com.caucho.server.dispatch.InvocationMatcher;
import com.caucho.server.dispatch.ServerListener;
import com.caucho.util.LruCache;
import com.caucho.vfs.Dependency;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DispatchServer
implements Dependency {
    private String _serverId = "";
    private DispatchBuilder _dispatchBuilder;
    private LruCache<Object, Invocation> _invocationCache;
    private InvocationDecoder _invocationDecoder;
    private HashMap<String, Object> _attributeMap = new HashMap();
    private ArrayList<ServerListener> _listeners = new ArrayList();
    private int _invocationCacheSize = 65536;
    private int _maxURLLength = 256;
    private final Lifecycle _lifecycle = new Lifecycle();

    public String getServerId() {
        return this._serverId;
    }

    public void setServerId(String serverId) {
        this._serverId = serverId;
    }

    public ClassLoader getClassLoader() {
        return null;
    }

    public void setDispatchBuilder(DispatchBuilder builder) {
        this._dispatchBuilder = builder;
    }

    public DispatchBuilder getDispatchBuilder() {
        return this._dispatchBuilder;
    }

    public boolean isIgnoreClientDisconnect() {
        return true;
    }

    public void setInvocationCacheSize(int size) {
        this._invocationCacheSize = size;
        if (this._invocationCacheSize <= 16) {
            this._invocationCacheSize = 16;
        }
    }

    public void setInvocationCacheMaxURLLength(int length) {
        this._maxURLLength = length;
    }

    @PostConstruct
    public void init() {
        this._invocationCache = new LruCache(this._invocationCacheSize);
    }

    public InvocationDecoder getInvocationDecoder() {
        if (this._invocationDecoder == null) {
            this._invocationDecoder = new InvocationDecoder();
        }
        return this._invocationDecoder;
    }

    public String getURLCharacterEncoding() {
        return this.getInvocationDecoder().getEncoding();
    }

    public InvocationDecoder createInvocationDecoder() {
        return this.getInvocationDecoder();
    }

    public final Invocation getInvocation(Object protocolKey) {
        Invocation invocation = null;
        LruCache<Object, Invocation> invocationCache = this._invocationCache;
        if (invocationCache != null) {
            invocation = (Invocation)invocationCache.get(protocolKey);
        }
        if (invocation == null) {
            return null;
        }
        if (invocation.isModified()) {
            return null;
        }
        return invocation;
    }

    public Invocation createInvocation() {
        return new Invocation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Invocation buildInvocation(Object protocolKey, Invocation invocation) throws Throwable {
        invocation = this.buildInvocation(invocation);
        LruCache<Object, Invocation> invocationCache = this._invocationCache;
        if (invocationCache != null) {
            LruCache<Object, Invocation> lruCache = invocationCache;
            synchronized (lruCache) {
                Invocation oldInvocation = (Invocation)invocationCache.get(protocolKey);
                if (oldInvocation != null && !oldInvocation.isModified()) {
                    return oldInvocation;
                }
                if (invocation.getURLLength() < this._maxURLLength) {
                    invocationCache.put(protocolKey, (Object)invocation);
                }
            }
        }
        return invocation;
    }

    public Invocation buildInvocation(Invocation invocation) throws Throwable {
        return this.getDispatchBuilder().buildInvocation(invocation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache() {
        LruCache<Object, Invocation> invocationCache = this._invocationCache;
        if (invocationCache != null) {
            LruCache<Object, Invocation> lruCache = invocationCache;
            synchronized (lruCache) {
                invocationCache.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invalidateMatchingInvocations(InvocationMatcher matcher) {
        LruCache<Object, Invocation> invocationCache = this._invocationCache;
        if (invocationCache != null) {
            LruCache<Object, Invocation> lruCache = invocationCache;
            synchronized (lruCache) {
                Iterator iter = invocationCache.iterator();
                while (iter.hasNext()) {
                    LruCache.Entry entry = (LruCache.Entry)iter.next();
                    Invocation value = (Invocation)entry.getValue();
                    if (value == null || !matcher.isMatch(value)) continue;
                    iter.remove();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Invocation> getInvocations() {
        LruCache<Object, Invocation> invocationCache = this._invocationCache;
        if (invocationCache != null) {
            ArrayList<Invocation> invocationList = new ArrayList<Invocation>();
            LruCache<Object, Invocation> lruCache = invocationCache;
            synchronized (lruCache) {
                Iterator iter = invocationCache.values();
                while (iter.hasNext()) {
                    invocationList.add((Invocation)iter.next());
                }
            }
            return invocationList;
        }
        return null;
    }

    public long getInvocationCacheHitCount() {
        LruCache<Object, Invocation> invocationCache = this._invocationCache;
        if (invocationCache != null) {
            return invocationCache.getHitCount();
        }
        return 0L;
    }

    public long getInvocationCacheMissCount() {
        LruCache<Object, Invocation> invocationCache = this._invocationCache;
        if (invocationCache != null) {
            return invocationCache.getMissCount();
        }
        return 0L;
    }

    public synchronized Object getAttribute(String key) {
        return this._attributeMap.get(key);
    }

    public synchronized Iterator getAttributeNames() {
        return this._attributeMap.keySet().iterator();
    }

    public synchronized Object setAttribute(String key, Object value) {
        return this._attributeMap.put(key, value);
    }

    public synchronized Object removeAttribute(String key) {
        return this._attributeMap.remove(key);
    }

    public boolean isModified() {
        return false;
    }

    public boolean logModified(Logger log) {
        return false;
    }

    public void addServerListener(ServerListener listener) {
        this._listeners.add(listener);
    }

    public boolean isDestroyed() {
        return this._lifecycle.isDestroyed();
    }

    public void update() {
        this.destroy();
    }

    public void restart() {
        this.destroy();
    }

    public void destroy() {
        ArrayList<ServerListener> listeners = new ArrayList<ServerListener>(this._listeners);
        this._listeners.clear();
        for (int i = 0; i < listeners.size(); ++i) {
            ServerListener listener = listeners.get(i);
            listener.closeEvent(this);
        }
        this._invocationCache = null;
    }
}

