/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.dispatch;

import com.caucho.config.Config;
import com.caucho.config.ConfigException;
import com.caucho.config.program.ContainerProgram;
import com.caucho.config.types.InitParam;
import com.caucho.server.util.CauchoSystem;
import com.caucho.util.L10N;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;

public class FilterConfigImpl
implements FilterConfig {
    private static final L10N L = new L10N(FilterConfigImpl.class);
    private String _filterName;
    private String _filterClassName;
    private Class _filterClass;
    private String _displayName;
    private HashMap<String, String> _initParams = new HashMap();
    private ContainerProgram _init;
    private ServletContext _servletContext;

    public void setId(String id) {
    }

    public void setFilterName(String name) {
        this._filterName = name;
    }

    public String getFilterName() {
        return this._filterName;
    }

    public void setFilterClass(String filterClassName) throws ConfigException, ClassNotFoundException {
        this._filterClassName = filterClassName;
        this._filterClass = CauchoSystem.loadClass(filterClassName);
        Config.validate(this._filterClass, Filter.class);
    }

    public Class getFilterClass() {
        return this._filterClass;
    }

    public String getFilterClassName() {
        return this._filterClassName;
    }

    public void setInitParam(String param, String value) {
        this._initParams.put(param, value);
    }

    public void setInitParam(InitParam initParam) {
        this._initParams.putAll(initParam.getParameters());
    }

    public Map getInitParamMap() {
        return this._initParams;
    }

    public String getInitParameter(String name) {
        return this._initParams.get(name);
    }

    public Enumeration getInitParameterNames() {
        return Collections.enumeration(this._initParams.keySet());
    }

    public ServletContext getServletContext() {
        return this._servletContext;
    }

    public void setServletContext(ServletContext app) {
        this._servletContext = app;
    }

    public void setInit(ContainerProgram init) {
        this._init = init;
    }

    public ContainerProgram getInit() {
        return this._init;
    }

    public void setDisplayName(String displayName) {
        this._displayName = displayName;
    }

    public String getDisplayName() {
        return this._displayName;
    }

    public void setDescription(String description) {
    }

    public void setIcon(String icon) {
    }

    public String toString() {
        return "FilterConfigImpl[name=" + this._filterName + ",class=" + this._filterClass + "]";
    }
}

