/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.dispatch;

import com.caucho.server.dispatch.AbstractFilterChain;
import com.caucho.servlet.comet.CometFilterChain;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class FilterFilterChain
extends AbstractFilterChain {
    private static final Logger log = Logger.getLogger(FilterFilterChain.class.getName());
    private FilterChain _next;
    private Filter _filter;
    private boolean _isFinest;

    public FilterFilterChain(FilterChain next, Filter filter) {
        this._next = next;
        this._filter = filter;
        this._isFinest = log.isLoggable(Level.FINEST);
    }

    public void doFilter(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        if (this._isFinest) {
            log.finest("Dispatch " + request + " filter=" + this._filter + " next=" + this._next);
        }
        this._filter.doFilter(request, response, this._next);
    }

    public boolean doResume(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        if (this._next instanceof CometFilterChain) {
            CometFilterChain next = (CometFilterChain)this._next;
            return next.doResume(request, response);
        }
        return false;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._filter + "]";
    }
}

