/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.dispatch;

import com.caucho.config.Config;
import com.caucho.config.program.ContainerProgram;
import com.caucho.server.dispatch.FilterConfigImpl;
import com.caucho.util.L10N;
import com.caucho.webbeans.component.ComponentImpl;
import com.caucho.webbeans.manager.WebBeansContainer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;

public class FilterManager {
    static final Logger log = Logger.getLogger(FilterManager.class.getName());
    static final L10N L = new L10N(FilterManager.class);
    private Hashtable<String, FilterConfigImpl> _filters = new Hashtable();
    private ComponentImpl _comp;
    private Hashtable<String, Filter> _instances = new Hashtable();

    public void addFilter(FilterConfigImpl config) {
        if (config.getServletContext() == null) {
            throw new NullPointerException();
        }
        this._filters.put(config.getFilterName(), config);
    }

    public FilterConfigImpl getFilter(String filterName) {
        return this._filters.get(filterName);
    }

    @PostConstruct
    public void init() {
        for (String name : this._filters.keySet()) {
            try {
                this.createFilter(name);
            }
            catch (Exception e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
    }

    public Filter createFilter(String filterName) throws ServletException {
        FilterConfigImpl config = this._filters.get(filterName);
        if (config == null) {
            throw new ServletException(L.l("`{0}' is not a known filter.  Filters must be defined by <filter> before being used.", (Object)filterName));
        }
        Class filterClass = config.getFilterClass();
        FilterConfigImpl filterConfigImpl = config;
        synchronized (filterConfigImpl) {
            try {
                Filter filter = this._instances.get(filterName);
                if (filter != null) {
                    return filter;
                }
                WebBeansContainer webBeans = WebBeansContainer.create();
                this._comp = (ComponentImpl)webBeans.createTransient(filterClass);
                filter = (Filter)this._comp.createNoInit();
                ContainerProgram init = config.getInit();
                if (init != null) {
                    init.configure(filter);
                }
                Config.init(filter);
                filter.init((FilterConfig)config);
                this._instances.put(filterName, filter);
                return filter;
            }
            catch (ServletException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new ServletException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        ArrayList<Filter> filterList = new ArrayList<Filter>();
        if (this._instances != null) {
            Hashtable<String, Filter> hashtable = this._instances;
            synchronized (hashtable) {
                Enumeration<Filter> en = this._instances.elements();
                while (en.hasMoreElements()) {
                    Filter filter = en.nextElement();
                    filterList.add(filter);
                }
            }
        }
        for (int i = 0; i < filterList.size(); ++i) {
            Filter filter = (Filter)filterList.get(i);
            try {
                if (this._comp != null) {
                    this._comp.destroy(filter);
                }
                filter.destroy();
                continue;
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
    }
}

